# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiEnableLlamaRmArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'llama1_host_id': 'str',
        'llama1_role_name': 'str',
        'llama2_host_id': 'str',
        'llama2_role_name': 'str',
        'zk_service_name': 'str',
        'skip_restart': 'bool'
    }

    attribute_map = {
        'llama1_host_id': 'llama1HostId',
        'llama1_role_name': 'llama1RoleName',
        'llama2_host_id': 'llama2HostId',
        'llama2_role_name': 'llama2RoleName',
        'zk_service_name': 'zkServiceName',
        'skip_restart': 'skipRestart'
    }

    def __init__(self, llama1_host_id=None, llama1_role_name=None, llama2_host_id=None, llama2_role_name=None, zk_service_name=None, skip_restart=None):
        """
        ApiEnableLlamaRmArguments - a model defined in Swagger
        """

        self._llama1_host_id = None
        self._llama1_role_name = None
        self._llama2_host_id = None
        self._llama2_role_name = None
        self._zk_service_name = None
        self._skip_restart = None

        if llama1_host_id is not None:
          self.llama1_host_id = llama1_host_id
        if llama1_role_name is not None:
          self.llama1_role_name = llama1_role_name
        if llama2_host_id is not None:
          self.llama2_host_id = llama2_host_id
        if llama2_role_name is not None:
          self.llama2_role_name = llama2_role_name
        if zk_service_name is not None:
          self.zk_service_name = zk_service_name
        if skip_restart is not None:
          self.skip_restart = skip_restart

    @property
    def llama1_host_id(self):
        """
        Gets the llama1_host_id of this ApiEnableLlamaRmArguments.
        HostId of the host on which the first Llama role will be created.

        :return: The llama1_host_id of this ApiEnableLlamaRmArguments.
        :rtype: str
        """
        return self._llama1_host_id

    @llama1_host_id.setter
    def llama1_host_id(self, llama1_host_id):
        """
        Sets the llama1_host_id of this ApiEnableLlamaRmArguments.
        HostId of the host on which the first Llama role will be created.

        :param llama1_host_id: The llama1_host_id of this ApiEnableLlamaRmArguments.
        :type: str
        """

        self._llama1_host_id = llama1_host_id

    @property
    def llama1_role_name(self):
        """
        Gets the llama1_role_name of this ApiEnableLlamaRmArguments.
        Name of the first Llama role to be created (optional).

        :return: The llama1_role_name of this ApiEnableLlamaRmArguments.
        :rtype: str
        """
        return self._llama1_role_name

    @llama1_role_name.setter
    def llama1_role_name(self, llama1_role_name):
        """
        Sets the llama1_role_name of this ApiEnableLlamaRmArguments.
        Name of the first Llama role to be created (optional).

        :param llama1_role_name: The llama1_role_name of this ApiEnableLlamaRmArguments.
        :type: str
        """

        self._llama1_role_name = llama1_role_name

    @property
    def llama2_host_id(self):
        """
        Gets the llama2_host_id of this ApiEnableLlamaRmArguments.
        HostId of the host on which the second Llama role will be created.

        :return: The llama2_host_id of this ApiEnableLlamaRmArguments.
        :rtype: str
        """
        return self._llama2_host_id

    @llama2_host_id.setter
    def llama2_host_id(self, llama2_host_id):
        """
        Sets the llama2_host_id of this ApiEnableLlamaRmArguments.
        HostId of the host on which the second Llama role will be created.

        :param llama2_host_id: The llama2_host_id of this ApiEnableLlamaRmArguments.
        :type: str
        """

        self._llama2_host_id = llama2_host_id

    @property
    def llama2_role_name(self):
        """
        Gets the llama2_role_name of this ApiEnableLlamaRmArguments.
        Name of the second Llama role to be created (optional).

        :return: The llama2_role_name of this ApiEnableLlamaRmArguments.
        :rtype: str
        """
        return self._llama2_role_name

    @llama2_role_name.setter
    def llama2_role_name(self, llama2_role_name):
        """
        Sets the llama2_role_name of this ApiEnableLlamaRmArguments.
        Name of the second Llama role to be created (optional).

        :param llama2_role_name: The llama2_role_name of this ApiEnableLlamaRmArguments.
        :type: str
        """

        self._llama2_role_name = llama2_role_name

    @property
    def zk_service_name(self):
        """
        Gets the zk_service_name of this ApiEnableLlamaRmArguments.
        Name of the ZooKeeper service that will be used for auto-failover. Only relevant when enabling Llama RM in HA mode (i.e., when two Llama roles are being created). This argument may be omitted if the ZooKeeper dependency for Impala is already configured.

        :return: The zk_service_name of this ApiEnableLlamaRmArguments.
        :rtype: str
        """
        return self._zk_service_name

    @zk_service_name.setter
    def zk_service_name(self, zk_service_name):
        """
        Sets the zk_service_name of this ApiEnableLlamaRmArguments.
        Name of the ZooKeeper service that will be used for auto-failover. Only relevant when enabling Llama RM in HA mode (i.e., when two Llama roles are being created). This argument may be omitted if the ZooKeeper dependency for Impala is already configured.

        :param zk_service_name: The zk_service_name of this ApiEnableLlamaRmArguments.
        :type: str
        """

        self._zk_service_name = zk_service_name

    @property
    def skip_restart(self):
        """
        Gets the skip_restart of this ApiEnableLlamaRmArguments.
        Skip the restart of Yarn, Impala, and their dependent services, and don't deploy client configuration. Default is false (i.e., by default, the services are restarted and client configuration is deployed).

        :return: The skip_restart of this ApiEnableLlamaRmArguments.
        :rtype: bool
        """
        return self._skip_restart

    @skip_restart.setter
    def skip_restart(self, skip_restart):
        """
        Sets the skip_restart of this ApiEnableLlamaRmArguments.
        Skip the restart of Yarn, Impala, and their dependent services, and don't deploy client configuration. Default is false (i.e., by default, the services are restarted and client configuration is deployed).

        :param skip_restart: The skip_restart of this ApiEnableLlamaRmArguments.
        :type: bool
        """

        self._skip_restart = skip_restart

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiEnableLlamaRmArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
