# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHiveReplicationResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'phase': 'str',
        'table_count': 'float',
        'tables': 'list[ApiHiveTable]',
        'impala_udf_count': 'float',
        'hive_udf_count': 'float',
        'impala_ud_fs': 'list[ApiImpalaUDF]',
        'hive_ud_fs': 'list[ApiHiveUDF]',
        'error_count': 'float',
        'errors': 'list[ApiHiveReplicationError]',
        'data_replication_result': 'ApiHdfsReplicationResult',
        'dry_run': 'bool',
        'run_as_user': 'str',
        'run_on_source_as_user': 'str'
    }

    attribute_map = {
        'phase': 'phase',
        'table_count': 'tableCount',
        'tables': 'tables',
        'impala_udf_count': 'impalaUDFCount',
        'hive_udf_count': 'hiveUDFCount',
        'impala_ud_fs': 'impalaUDFs',
        'hive_ud_fs': 'hiveUDFs',
        'error_count': 'errorCount',
        'errors': 'errors',
        'data_replication_result': 'dataReplicationResult',
        'dry_run': 'dryRun',
        'run_as_user': 'runAsUser',
        'run_on_source_as_user': 'runOnSourceAsUser'
    }

    def __init__(self, phase=None, table_count=None, tables=None, impala_udf_count=None, hive_udf_count=None, impala_ud_fs=None, hive_ud_fs=None, error_count=None, errors=None, data_replication_result=None, dry_run=None, run_as_user=None, run_on_source_as_user=None):
        """
        ApiHiveReplicationResult - a model defined in Swagger
        """

        self._phase = None
        self._table_count = None
        self._tables = None
        self._impala_udf_count = None
        self._hive_udf_count = None
        self._impala_ud_fs = None
        self._hive_ud_fs = None
        self._error_count = None
        self._errors = None
        self._data_replication_result = None
        self._dry_run = None
        self._run_as_user = None
        self._run_on_source_as_user = None

        if phase is not None:
          self.phase = phase
        if table_count is not None:
          self.table_count = table_count
        if tables is not None:
          self.tables = tables
        if impala_udf_count is not None:
          self.impala_udf_count = impala_udf_count
        if hive_udf_count is not None:
          self.hive_udf_count = hive_udf_count
        if impala_ud_fs is not None:
          self.impala_ud_fs = impala_ud_fs
        if hive_ud_fs is not None:
          self.hive_ud_fs = hive_ud_fs
        if error_count is not None:
          self.error_count = error_count
        if errors is not None:
          self.errors = errors
        if data_replication_result is not None:
          self.data_replication_result = data_replication_result
        if dry_run is not None:
          self.dry_run = dry_run
        if run_as_user is not None:
          self.run_as_user = run_as_user
        if run_on_source_as_user is not None:
          self.run_on_source_as_user = run_on_source_as_user

    @property
    def phase(self):
        """
        Gets the phase of this ApiHiveReplicationResult.
        Phase the replication is in. <p/> If the replication job is still active, this will contain a string describing the current phase. This will be one of: EXPORT, DATA or IMPORT, for, respectively, exporting the source metastore information, replicating table data (if configured), and importing metastore information in the target. <p/> This value will not be present if the replication is not active. <p/> Available since API v4.

        :return: The phase of this ApiHiveReplicationResult.
        :rtype: str
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """
        Sets the phase of this ApiHiveReplicationResult.
        Phase the replication is in. <p/> If the replication job is still active, this will contain a string describing the current phase. This will be one of: EXPORT, DATA or IMPORT, for, respectively, exporting the source metastore information, replicating table data (if configured), and importing metastore information in the target. <p/> This value will not be present if the replication is not active. <p/> Available since API v4.

        :param phase: The phase of this ApiHiveReplicationResult.
        :type: str
        """

        self._phase = phase

    @property
    def table_count(self):
        """
        Gets the table_count of this ApiHiveReplicationResult.
        Number of tables that were successfully replicated. Available since API v4.

        :return: The table_count of this ApiHiveReplicationResult.
        :rtype: float
        """
        return self._table_count

    @table_count.setter
    def table_count(self, table_count):
        """
        Sets the table_count of this ApiHiveReplicationResult.
        Number of tables that were successfully replicated. Available since API v4.

        :param table_count: The table_count of this ApiHiveReplicationResult.
        :type: float
        """

        self._table_count = table_count

    @property
    def tables(self):
        """
        Gets the tables of this ApiHiveReplicationResult.
        The list of tables successfully replicated. <p/> Since API v4, this is only available in the full view.

        :return: The tables of this ApiHiveReplicationResult.
        :rtype: list[ApiHiveTable]
        """
        return self._tables

    @tables.setter
    def tables(self, tables):
        """
        Sets the tables of this ApiHiveReplicationResult.
        The list of tables successfully replicated. <p/> Since API v4, this is only available in the full view.

        :param tables: The tables of this ApiHiveReplicationResult.
        :type: list[ApiHiveTable]
        """

        self._tables = tables

    @property
    def impala_udf_count(self):
        """
        Gets the impala_udf_count of this ApiHiveReplicationResult.
        Number of impala UDFs that were successfully replicated. Available since API v6.

        :return: The impala_udf_count of this ApiHiveReplicationResult.
        :rtype: float
        """
        return self._impala_udf_count

    @impala_udf_count.setter
    def impala_udf_count(self, impala_udf_count):
        """
        Sets the impala_udf_count of this ApiHiveReplicationResult.
        Number of impala UDFs that were successfully replicated. Available since API v6.

        :param impala_udf_count: The impala_udf_count of this ApiHiveReplicationResult.
        :type: float
        """

        self._impala_udf_count = impala_udf_count

    @property
    def hive_udf_count(self):
        """
        Gets the hive_udf_count of this ApiHiveReplicationResult.
        Number of hive UDFs that were successfully replicated. Available since API v14.

        :return: The hive_udf_count of this ApiHiveReplicationResult.
        :rtype: float
        """
        return self._hive_udf_count

    @hive_udf_count.setter
    def hive_udf_count(self, hive_udf_count):
        """
        Sets the hive_udf_count of this ApiHiveReplicationResult.
        Number of hive UDFs that were successfully replicated. Available since API v14.

        :param hive_udf_count: The hive_udf_count of this ApiHiveReplicationResult.
        :type: float
        """

        self._hive_udf_count = hive_udf_count

    @property
    def impala_ud_fs(self):
        """
        Gets the impala_ud_fs of this ApiHiveReplicationResult.
        The list of Impala UDFs successfully replicated. Available since API v6 in the full view.

        :return: The impala_ud_fs of this ApiHiveReplicationResult.
        :rtype: list[ApiImpalaUDF]
        """
        return self._impala_ud_fs

    @impala_ud_fs.setter
    def impala_ud_fs(self, impala_ud_fs):
        """
        Sets the impala_ud_fs of this ApiHiveReplicationResult.
        The list of Impala UDFs successfully replicated. Available since API v6 in the full view.

        :param impala_ud_fs: The impala_ud_fs of this ApiHiveReplicationResult.
        :type: list[ApiImpalaUDF]
        """

        self._impala_ud_fs = impala_ud_fs

    @property
    def hive_ud_fs(self):
        """
        Gets the hive_ud_fs of this ApiHiveReplicationResult.
        The list of Impala UDFs successfully replicated. Available since API v6 in the full view.

        :return: The hive_ud_fs of this ApiHiveReplicationResult.
        :rtype: list[ApiHiveUDF]
        """
        return self._hive_ud_fs

    @hive_ud_fs.setter
    def hive_ud_fs(self, hive_ud_fs):
        """
        Sets the hive_ud_fs of this ApiHiveReplicationResult.
        The list of Impala UDFs successfully replicated. Available since API v6 in the full view.

        :param hive_ud_fs: The hive_ud_fs of this ApiHiveReplicationResult.
        :type: list[ApiHiveUDF]
        """

        self._hive_ud_fs = hive_ud_fs

    @property
    def error_count(self):
        """
        Gets the error_count of this ApiHiveReplicationResult.
        Number of errors detected during replication job. Available since API v4.

        :return: The error_count of this ApiHiveReplicationResult.
        :rtype: float
        """
        return self._error_count

    @error_count.setter
    def error_count(self, error_count):
        """
        Sets the error_count of this ApiHiveReplicationResult.
        Number of errors detected during replication job. Available since API v4.

        :param error_count: The error_count of this ApiHiveReplicationResult.
        :type: float
        """

        self._error_count = error_count

    @property
    def errors(self):
        """
        Gets the errors of this ApiHiveReplicationResult.
        List of errors encountered during replication. <p/> Since API v4, this is only available in the full view.

        :return: The errors of this ApiHiveReplicationResult.
        :rtype: list[ApiHiveReplicationError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this ApiHiveReplicationResult.
        List of errors encountered during replication. <p/> Since API v4, this is only available in the full view.

        :param errors: The errors of this ApiHiveReplicationResult.
        :type: list[ApiHiveReplicationError]
        """

        self._errors = errors

    @property
    def data_replication_result(self):
        """
        Gets the data_replication_result of this ApiHiveReplicationResult.
        Result of table data replication, if performed.

        :return: The data_replication_result of this ApiHiveReplicationResult.
        :rtype: ApiHdfsReplicationResult
        """
        return self._data_replication_result

    @data_replication_result.setter
    def data_replication_result(self, data_replication_result):
        """
        Sets the data_replication_result of this ApiHiveReplicationResult.
        Result of table data replication, if performed.

        :param data_replication_result: The data_replication_result of this ApiHiveReplicationResult.
        :type: ApiHdfsReplicationResult
        """

        self._data_replication_result = data_replication_result

    @property
    def dry_run(self):
        """
        Gets the dry_run of this ApiHiveReplicationResult.
        Whether this was a dry run.

        :return: The dry_run of this ApiHiveReplicationResult.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this ApiHiveReplicationResult.
        Whether this was a dry run.

        :param dry_run: The dry_run of this ApiHiveReplicationResult.
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this ApiHiveReplicationResult.
        Name of the of proxy user, if any. Available since API v11.

        :return: The run_as_user of this ApiHiveReplicationResult.
        :rtype: str
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this ApiHiveReplicationResult.
        Name of the of proxy user, if any. Available since API v11.

        :param run_as_user: The run_as_user of this ApiHiveReplicationResult.
        :type: str
        """

        self._run_as_user = run_as_user

    @property
    def run_on_source_as_user(self):
        """
        Gets the run_on_source_as_user of this ApiHiveReplicationResult.
        Name of the source proxy user, if any. Available since API v18.

        :return: The run_on_source_as_user of this ApiHiveReplicationResult.
        :rtype: str
        """
        return self._run_on_source_as_user

    @run_on_source_as_user.setter
    def run_on_source_as_user(self, run_on_source_as_user):
        """
        Sets the run_on_source_as_user of this ApiHiveReplicationResult.
        Name of the source proxy user, if any. Available since API v18.

        :param run_on_source_as_user: The run_on_source_as_user of this ApiHiveReplicationResult.
        :type: str
        """

        self._run_on_source_as_user = run_on_source_as_user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHiveReplicationResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
