# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHostTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'cluster_ref': 'ApiClusterRef',
        'role_config_group_refs': 'list[ApiRoleConfigGroupRef]'
    }

    attribute_map = {
        'name': 'name',
        'cluster_ref': 'clusterRef',
        'role_config_group_refs': 'roleConfigGroupRefs'
    }

    def __init__(self, name=None, cluster_ref=None, role_config_group_refs=None):
        """
        ApiHostTemplate - a model defined in Swagger
        """

        self._name = None
        self._cluster_ref = None
        self._role_config_group_refs = None

        if name is not None:
          self.name = name
        if cluster_ref is not None:
          self.cluster_ref = cluster_ref
        if role_config_group_refs is not None:
          self.role_config_group_refs = role_config_group_refs

    @property
    def name(self):
        """
        Gets the name of this ApiHostTemplate.
        The name of the host template. Unique across clusters.

        :return: The name of this ApiHostTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiHostTemplate.
        The name of the host template. Unique across clusters.

        :param name: The name of this ApiHostTemplate.
        :type: str
        """

        self._name = name

    @property
    def cluster_ref(self):
        """
        Gets the cluster_ref of this ApiHostTemplate.
        Readonly. A reference to the cluster the host template belongs to.

        :return: The cluster_ref of this ApiHostTemplate.
        :rtype: ApiClusterRef
        """
        return self._cluster_ref

    @cluster_ref.setter
    def cluster_ref(self, cluster_ref):
        """
        Sets the cluster_ref of this ApiHostTemplate.
        Readonly. A reference to the cluster the host template belongs to.

        :param cluster_ref: The cluster_ref of this ApiHostTemplate.
        :type: ApiClusterRef
        """

        self._cluster_ref = cluster_ref

    @property
    def role_config_group_refs(self):
        """
        Gets the role_config_group_refs of this ApiHostTemplate.
        The role config groups belonging to this host tempalte.

        :return: The role_config_group_refs of this ApiHostTemplate.
        :rtype: list[ApiRoleConfigGroupRef]
        """
        return self._role_config_group_refs

    @role_config_group_refs.setter
    def role_config_group_refs(self, role_config_group_refs):
        """
        Sets the role_config_group_refs of this ApiHostTemplate.
        The role config groups belonging to this host tempalte.

        :param role_config_group_refs: The role_config_group_refs of this ApiHostTemplate.
        :type: list[ApiRoleConfigGroupRef]
        """

        self._role_config_group_refs = role_config_group_refs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHostTemplate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
