# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiMetric(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'context': 'str',
        'unit': 'str',
        'data': 'list[ApiMetricData]',
        'display_name': 'str',
        'description': 'str'
    }

    attribute_map = {
        'name': 'name',
        'context': 'context',
        'unit': 'unit',
        'data': 'data',
        'display_name': 'displayName',
        'description': 'description'
    }

    def __init__(self, name=None, context=None, unit=None, data=None, display_name=None, description=None):
        """
        ApiMetric - a model defined in Swagger
        """

        self._name = None
        self._context = None
        self._unit = None
        self._data = None
        self._display_name = None
        self._description = None

        if name is not None:
          self.name = name
        if context is not None:
          self.context = context
        if unit is not None:
          self.unit = unit
        if data is not None:
          self.data = data
        if display_name is not None:
          self.display_name = display_name
        if description is not None:
          self.description = description

    @property
    def name(self):
        """
        Gets the name of this ApiMetric.
        Name of the metric.

        :return: The name of this ApiMetric.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiMetric.
        Name of the metric.

        :param name: The name of this ApiMetric.
        :type: str
        """

        self._name = name

    @property
    def context(self):
        """
        Gets the context of this ApiMetric.
        Context the metric is associated with.

        :return: The context of this ApiMetric.
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context):
        """
        Sets the context of this ApiMetric.
        Context the metric is associated with.

        :param context: The context of this ApiMetric.
        :type: str
        """

        self._context = context

    @property
    def unit(self):
        """
        Gets the unit of this ApiMetric.
        Unit of the metric values.

        :return: The unit of this ApiMetric.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this ApiMetric.
        Unit of the metric values.

        :param unit: The unit of this ApiMetric.
        :type: str
        """

        self._unit = unit

    @property
    def data(self):
        """
        Gets the data of this ApiMetric.
        List of readings retrieved from the monitors.

        :return: The data of this ApiMetric.
        :rtype: list[ApiMetricData]
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this ApiMetric.
        List of readings retrieved from the monitors.

        :param data: The data of this ApiMetric.
        :type: list[ApiMetricData]
        """

        self._data = data

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiMetric.
        Requires \"full\" view. User-friendly display name for the metric.

        :return: The display_name of this ApiMetric.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiMetric.
        Requires \"full\" view. User-friendly display name for the metric.

        :param display_name: The display_name of this ApiMetric.
        :type: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ApiMetric.
        Requires \"full\" view. Description of the metric.

        :return: The description of this ApiMetric.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiMetric.
        Requires \"full\" view. Description of the metric.

        :param description: The description of this ApiMetric.
        :type: str
        """

        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiMetric):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
