# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiParcel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'product': 'str',
        'version': 'str',
        'stage': 'str',
        'state': 'ApiParcelState',
        'cluster_ref': 'ApiClusterRef'
    }

    attribute_map = {
        'product': 'product',
        'version': 'version',
        'stage': 'stage',
        'state': 'state',
        'cluster_ref': 'clusterRef'
    }

    def __init__(self, product=None, version=None, stage=None, state=None, cluster_ref=None):
        """
        ApiParcel - a model defined in Swagger
        """

        self._product = None
        self._version = None
        self._stage = None
        self._state = None
        self._cluster_ref = None

        if product is not None:
          self.product = product
        if version is not None:
          self.version = version
        if stage is not None:
          self.stage = stage
        if state is not None:
          self.state = state
        if cluster_ref is not None:
          self.cluster_ref = cluster_ref

    @property
    def product(self):
        """
        Gets the product of this ApiParcel.
        The name of the product, e.g. CDH, Impala

        :return: The product of this ApiParcel.
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """
        Sets the product of this ApiParcel.
        The name of the product, e.g. CDH, Impala

        :param product: The product of this ApiParcel.
        :type: str
        """

        self._product = product

    @property
    def version(self):
        """
        Gets the version of this ApiParcel.
        The version of the product, e.g. 1.1.0, 2.3.0.

        :return: The version of this ApiParcel.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ApiParcel.
        The version of the product, e.g. 1.1.0, 2.3.0.

        :param version: The version of this ApiParcel.
        :type: str
        """

        self._version = version

    @property
    def stage(self):
        """
        Gets the stage of this ApiParcel.
        Returns the current stage of the parcel. <p> There are a number of stages a parcel can be in. There are two types of stages - stable and transient. A parcel is in a transient stage when it is transitioning between two stable stages. The stages are listed below with some additional information.  <ul> <li><b>AVAILABLE_REMOTELY</b>: Stable stage - the parcel can be downloaded to the server.</li> <li><b>DOWNLOADING</b>: Transient stage - the parcel is in the process of being downloaded to the server.</li> <li><b>DOWNLOADED</b>: Stable stage - the parcel is downloaded and ready to be distributed or removed from the server.</li> <li><b>DISTRIBUTING</b>: Transient stage - the parcel is being sent to all the hosts in the cluster.</li> <li><b>DISTRIBUTED</b>: Stable stage - the parcel is on all the hosts in the cluster. The parcel can now be activated, or removed from all the hosts.</li> <li><b>UNDISTRIBUTING</b>: Transient stage - the parcel is being removed from all the hosts in the cluster></li> <li><b>ACTIVATING</b>: Transient stage - the parcel is being activated on the hosts in the cluster. <i>New in API v7</i></li> <li><b>ACTIVATED</b>: Steady stage - the parcel is set to active on every host in the cluster. If desired, a parcel can be deactivated from this stage.</li> </ul>

        :return: The stage of this ApiParcel.
        :rtype: str
        """
        return self._stage

    @stage.setter
    def stage(self, stage):
        """
        Sets the stage of this ApiParcel.
        Returns the current stage of the parcel. <p> There are a number of stages a parcel can be in. There are two types of stages - stable and transient. A parcel is in a transient stage when it is transitioning between two stable stages. The stages are listed below with some additional information.  <ul> <li><b>AVAILABLE_REMOTELY</b>: Stable stage - the parcel can be downloaded to the server.</li> <li><b>DOWNLOADING</b>: Transient stage - the parcel is in the process of being downloaded to the server.</li> <li><b>DOWNLOADED</b>: Stable stage - the parcel is downloaded and ready to be distributed or removed from the server.</li> <li><b>DISTRIBUTING</b>: Transient stage - the parcel is being sent to all the hosts in the cluster.</li> <li><b>DISTRIBUTED</b>: Stable stage - the parcel is on all the hosts in the cluster. The parcel can now be activated, or removed from all the hosts.</li> <li><b>UNDISTRIBUTING</b>: Transient stage - the parcel is being removed from all the hosts in the cluster></li> <li><b>ACTIVATING</b>: Transient stage - the parcel is being activated on the hosts in the cluster. <i>New in API v7</i></li> <li><b>ACTIVATED</b>: Steady stage - the parcel is set to active on every host in the cluster. If desired, a parcel can be deactivated from this stage.</li> </ul>

        :param stage: The stage of this ApiParcel.
        :type: str
        """

        self._stage = stage

    @property
    def state(self):
        """
        Gets the state of this ApiParcel.
        The state of the parcel. This shows the progress of state transitions and if there were any errors.

        :return: The state of this ApiParcel.
        :rtype: ApiParcelState
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ApiParcel.
        The state of the parcel. This shows the progress of state transitions and if there were any errors.

        :param state: The state of this ApiParcel.
        :type: ApiParcelState
        """

        self._state = state

    @property
    def cluster_ref(self):
        """
        Gets the cluster_ref of this ApiParcel.
        Readonly. A reference to the enclosing cluster.

        :return: The cluster_ref of this ApiParcel.
        :rtype: ApiClusterRef
        """
        return self._cluster_ref

    @cluster_ref.setter
    def cluster_ref(self, cluster_ref):
        """
        Sets the cluster_ref of this ApiParcel.
        Readonly. A reference to the enclosing cluster.

        :param cluster_ref: The cluster_ref of this ApiParcel.
        :type: ApiClusterRef
        """

        self._cluster_ref = cluster_ref

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiParcel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
