# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRoleConfigGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'role_type': 'str',
        'base': 'bool',
        'config': 'ApiConfigList',
        'display_name': 'str',
        'service_ref': 'ApiServiceRef'
    }

    attribute_map = {
        'name': 'name',
        'role_type': 'roleType',
        'base': 'base',
        'config': 'config',
        'display_name': 'displayName',
        'service_ref': 'serviceRef'
    }

    def __init__(self, name=None, role_type=None, base=None, config=None, display_name=None, service_ref=None):
        """
        ApiRoleConfigGroup - a model defined in Swagger
        """

        self._name = None
        self._role_type = None
        self._base = None
        self._config = None
        self._display_name = None
        self._service_ref = None

        if name is not None:
          self.name = name
        if role_type is not None:
          self.role_type = role_type
        if base is not None:
          self.base = base
        if config is not None:
          self.config = config
        if display_name is not None:
          self.display_name = display_name
        if service_ref is not None:
          self.service_ref = service_ref

    @property
    def name(self):
        """
        Gets the name of this ApiRoleConfigGroup.
        Readonly. The unique name of this role config group.

        :return: The name of this ApiRoleConfigGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiRoleConfigGroup.
        Readonly. The unique name of this role config group.

        :param name: The name of this ApiRoleConfigGroup.
        :type: str
        """

        self._name = name

    @property
    def role_type(self):
        """
        Gets the role_type of this ApiRoleConfigGroup.
        Readonly. The type of the roles in this group.

        :return: The role_type of this ApiRoleConfigGroup.
        :rtype: str
        """
        return self._role_type

    @role_type.setter
    def role_type(self, role_type):
        """
        Sets the role_type of this ApiRoleConfigGroup.
        Readonly. The type of the roles in this group.

        :param role_type: The role_type of this ApiRoleConfigGroup.
        :type: str
        """

        self._role_type = role_type

    @property
    def base(self):
        """
        Gets the base of this ApiRoleConfigGroup.
        Readonly. Indicates whether this is a base group.

        :return: The base of this ApiRoleConfigGroup.
        :rtype: bool
        """
        return self._base

    @base.setter
    def base(self, base):
        """
        Sets the base of this ApiRoleConfigGroup.
        Readonly. Indicates whether this is a base group.

        :param base: The base of this ApiRoleConfigGroup.
        :type: bool
        """

        self._base = base

    @property
    def config(self):
        """
        Gets the config of this ApiRoleConfigGroup.
        The configuration for this group. Optional.

        :return: The config of this ApiRoleConfigGroup.
        :rtype: ApiConfigList
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this ApiRoleConfigGroup.
        The configuration for this group. Optional.

        :param config: The config of this ApiRoleConfigGroup.
        :type: ApiConfigList
        """

        self._config = config

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiRoleConfigGroup.
        The display name of this group.

        :return: The display_name of this ApiRoleConfigGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiRoleConfigGroup.
        The display name of this group.

        :param display_name: The display_name of this ApiRoleConfigGroup.
        :type: str
        """

        self._display_name = display_name

    @property
    def service_ref(self):
        """
        Gets the service_ref of this ApiRoleConfigGroup.
        Readonly. The service reference (service name and cluster name) of this group.

        :return: The service_ref of this ApiRoleConfigGroup.
        :rtype: ApiServiceRef
        """
        return self._service_ref

    @service_ref.setter
    def service_ref(self, service_ref):
        """
        Sets the service_ref of this ApiRoleConfigGroup.
        Readonly. The service reference (service name and cluster name) of this group.

        :param service_ref: The service_ref of this ApiRoleConfigGroup.
        :type: ApiServiceRef
        """

        self._service_ref = service_ref

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRoleConfigGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
