# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiTimeSeriesMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'metric_name': 'str',
        'entity_name': 'str',
        'start_time': 'str',
        'end_time': 'str',
        'attributes': 'dict(str, str)',
        'unit_numerators': 'list[str]',
        'unit_denominators': 'list[str]',
        'expression': 'str',
        'alias': 'str',
        'metric_collection_frequency_ms': 'float',
        'rollup_used': 'str'
    }

    attribute_map = {
        'metric_name': 'metricName',
        'entity_name': 'entityName',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'attributes': 'attributes',
        'unit_numerators': 'unitNumerators',
        'unit_denominators': 'unitDenominators',
        'expression': 'expression',
        'alias': 'alias',
        'metric_collection_frequency_ms': 'metricCollectionFrequencyMs',
        'rollup_used': 'rollupUsed'
    }

    def __init__(self, metric_name=None, entity_name=None, start_time=None, end_time=None, attributes=None, unit_numerators=None, unit_denominators=None, expression=None, alias=None, metric_collection_frequency_ms=None, rollup_used=None):
        """
        ApiTimeSeriesMetadata - a model defined in Swagger
        """

        self._metric_name = None
        self._entity_name = None
        self._start_time = None
        self._end_time = None
        self._attributes = None
        self._unit_numerators = None
        self._unit_denominators = None
        self._expression = None
        self._alias = None
        self._metric_collection_frequency_ms = None
        self._rollup_used = None

        if metric_name is not None:
          self.metric_name = metric_name
        if entity_name is not None:
          self.entity_name = entity_name
        if start_time is not None:
          self.start_time = start_time
        if end_time is not None:
          self.end_time = end_time
        if attributes is not None:
          self.attributes = attributes
        if unit_numerators is not None:
          self.unit_numerators = unit_numerators
        if unit_denominators is not None:
          self.unit_denominators = unit_denominators
        if expression is not None:
          self.expression = expression
        if alias is not None:
          self.alias = alias
        if metric_collection_frequency_ms is not None:
          self.metric_collection_frequency_ms = metric_collection_frequency_ms
        if rollup_used is not None:
          self.rollup_used = rollup_used

    @property
    def metric_name(self):
        """
        Gets the metric_name of this ApiTimeSeriesMetadata.
        The metric name for the time series.

        :return: The metric_name of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this ApiTimeSeriesMetadata.
        The metric name for the time series.

        :param metric_name: The metric_name of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._metric_name = metric_name

    @property
    def entity_name(self):
        """
        Gets the entity_name of this ApiTimeSeriesMetadata.
        The display name for the entity associated with this time series. For example, if this was a time series for an HDFS service the entity name might be something like \"My HDFS Service\". If it was for a host it might be something like \"myhost.mysite.com\".

        :return: The entity_name of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._entity_name

    @entity_name.setter
    def entity_name(self, entity_name):
        """
        Sets the entity_name of this ApiTimeSeriesMetadata.
        The display name for the entity associated with this time series. For example, if this was a time series for an HDFS service the entity name might be something like \"My HDFS Service\". If it was for a host it might be something like \"myhost.mysite.com\".

        :param entity_name: The entity_name of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._entity_name = entity_name

    @property
    def start_time(self):
        """
        Gets the start_time of this ApiTimeSeriesMetadata.
        The start time for the time series.

        :return: The start_time of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this ApiTimeSeriesMetadata.
        The start time for the time series.

        :param start_time: The start_time of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this ApiTimeSeriesMetadata.
        The end time for the time series.

        :return: The end_time of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this ApiTimeSeriesMetadata.
        The end time for the time series.

        :param end_time: The end_time of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._end_time = end_time

    @property
    def attributes(self):
        """
        Gets the attributes of this ApiTimeSeriesMetadata.
        The attributes for the time series. Note that the entityName entry in this map is not the same as the entityName field in this ApiTimeSeriesMetadata. The entityName entry in this map is a unique identifier for the entity and not the name displayed in the UI.  For example, if this was a time series for the YARN Job History Server the entityName entry in this map might be something like \"yarn-JOBHISTORY-6bd17ceb1489aae93fef4c867350d0dd\"

        :return: The attributes of this ApiTimeSeriesMetadata.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this ApiTimeSeriesMetadata.
        The attributes for the time series. Note that the entityName entry in this map is not the same as the entityName field in this ApiTimeSeriesMetadata. The entityName entry in this map is a unique identifier for the entity and not the name displayed in the UI.  For example, if this was a time series for the YARN Job History Server the entityName entry in this map might be something like \"yarn-JOBHISTORY-6bd17ceb1489aae93fef4c867350d0dd\"

        :param attributes: The attributes of this ApiTimeSeriesMetadata.
        :type: dict(str, str)
        """

        self._attributes = attributes

    @property
    def unit_numerators(self):
        """
        Gets the unit_numerators of this ApiTimeSeriesMetadata.
        The numerators of the units for the time series.

        :return: The unit_numerators of this ApiTimeSeriesMetadata.
        :rtype: list[str]
        """
        return self._unit_numerators

    @unit_numerators.setter
    def unit_numerators(self, unit_numerators):
        """
        Sets the unit_numerators of this ApiTimeSeriesMetadata.
        The numerators of the units for the time series.

        :param unit_numerators: The unit_numerators of this ApiTimeSeriesMetadata.
        :type: list[str]
        """

        self._unit_numerators = unit_numerators

    @property
    def unit_denominators(self):
        """
        Gets the unit_denominators of this ApiTimeSeriesMetadata.
        The denominators of the units for the time series.

        :return: The unit_denominators of this ApiTimeSeriesMetadata.
        :rtype: list[str]
        """
        return self._unit_denominators

    @unit_denominators.setter
    def unit_denominators(self, unit_denominators):
        """
        Sets the unit_denominators of this ApiTimeSeriesMetadata.
        The denominators of the units for the time series.

        :param unit_denominators: The unit_denominators of this ApiTimeSeriesMetadata.
        :type: list[str]
        """

        self._unit_denominators = unit_denominators

    @property
    def expression(self):
        """
        Gets the expression of this ApiTimeSeriesMetadata.
        The tsquery expression that could be used to extract just this stream.

        :return: The expression of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._expression

    @expression.setter
    def expression(self, expression):
        """
        Sets the expression of this ApiTimeSeriesMetadata.
        The tsquery expression that could be used to extract just this stream.

        :param expression: The expression of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._expression = expression

    @property
    def alias(self):
        """
        Gets the alias of this ApiTimeSeriesMetadata.
        The alias for this stream's metric. Aliases correspond to use of the 'as' keyword in the tsquery.

        :return: The alias of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this ApiTimeSeriesMetadata.
        The alias for this stream's metric. Aliases correspond to use of the 'as' keyword in the tsquery.

        :param alias: The alias of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._alias = alias

    @property
    def metric_collection_frequency_ms(self):
        """
        Gets the metric_collection_frequency_ms of this ApiTimeSeriesMetadata.
        The minimum frequency at which the underlying metric for this stream is collected. Note that this can be null if the stream returns irregularly sampled data.

        :return: The metric_collection_frequency_ms of this ApiTimeSeriesMetadata.
        :rtype: float
        """
        return self._metric_collection_frequency_ms

    @metric_collection_frequency_ms.setter
    def metric_collection_frequency_ms(self, metric_collection_frequency_ms):
        """
        Sets the metric_collection_frequency_ms of this ApiTimeSeriesMetadata.
        The minimum frequency at which the underlying metric for this stream is collected. Note that this can be null if the stream returns irregularly sampled data.

        :param metric_collection_frequency_ms: The metric_collection_frequency_ms of this ApiTimeSeriesMetadata.
        :type: float
        """

        self._metric_collection_frequency_ms = metric_collection_frequency_ms

    @property
    def rollup_used(self):
        """
        Gets the rollup_used of this ApiTimeSeriesMetadata.
        The aggregate rollup for the returned data. This can be TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, or WEEKLY.

        :return: The rollup_used of this ApiTimeSeriesMetadata.
        :rtype: str
        """
        return self._rollup_used

    @rollup_used.setter
    def rollup_used(self, rollup_used):
        """
        Sets the rollup_used of this ApiTimeSeriesMetadata.
        The aggregate rollup for the returned data. This can be TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, or WEEKLY.

        :param rollup_used: The rollup_used of this ApiTimeSeriesMetadata.
        :type: str
        """

        self._rollup_used = rollup_used

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiTimeSeriesMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
