# YouTube Playlist Exporter

Tired of videos disappearing from your YouTube playlists, without leaving you the option to know what was there before?

Fear not! For this CLI will have you covered

![alt text](memes/1.jpg)

This CLI allows exporting data about videos in your playlist to local files, that can be used as a backup in case
videos from the playlist become private/get deleted.

If the CLI runs in a directory which contains output files from a previous run (with the same parameters), it will
automatically detect differences in the specified playlist, and export them to files as well.

## Installation

This CLI requires Python 3.10+ to run. It is published to [PyPI](https://pypi.org/project/youtube-playlist-exporter/)
and can be installed with pip using:

`pip install youtube-playlist-exporter`

## Usage

1. Get a YouTube API Key. To do so, you can follow the instructions
   in [this guide](https://elfsight.com/help/how-to-get-youtube-api-key/)
2. Retrieve the YouTube ID of the playlist you want to create a backup for. This can be done in several ways. One of
   them is by navigating to the playlist's main YouTube page, and copying the text after "...list=" in the URL
3. If you didn't do so already, install the CLI (see [installation](#installation))
4. Run the CLI using either the `ype` or `youtube-playlist-export` commands (full details on the CLI syntax are provided
   by running with the `--help` flag)
5. Several `.csv` files (tables which can be opened with Excel/imported to Google Sheets etc.) will be generated by the
   script in the output directory (`<PLAYLIST_NAME>` will be replaced with the name provided as an argument to the CLI):
    * `YouTube-<PLAYLIST_NAME>-items.csv`: contains the current details of all the videos in the playlist
    * `YouTube-<PLAYLIST_NAME>-items-backup.csv`: if an `...items.csv` file existed in the output directory before
      running the script, this file will be a backup for it (in case something went wrong with running the script etc.)
    * `YouTube-<PLAYLIST_NAME>-diff.csv`: if an `...items.csv` file existed in the output directory before
      running the script, this file will contain information about videos whose title changed. This can help detect
      videos that now appear as private or deleted, or any other unexpected changes
    * `YouTube-<PLAYLIST_NAME>-diff-backup.csv`: if a `...diff.csv` file existed in the output directory
      before running the script, this file will contain a backup for it
    * `YouTube-<PLAYLIST_NAME>-missing-videos.csv`: if an `...items.csv` file existed in the output directory before
      running the script, this file will contain information about videos that existed before and now don't exist in
      the playlist anymore. Note: sometimes deleted videos will still appear but just with a title change of "deleted
      video", and sometimes they will go missing completely and appear in this file
    * `YouTube-<PLAYLIST_NAME>-missing-videos-backup.csv`: if a `...missing-videos.csv` file existed in the output
      directory before running the script, this file will contain a backup for it

## TODOs

1. Add additional backup mechanisms? GIT backup?