# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from . import lazo_index_pb2 as lazo__index__pb2


class LazoIndexStub(object):
    """Service responsible for indexing the values of a textual or categorical
    column using Lazo.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.IndexData = channel.stream_unary(
                '/lazo_index.LazoIndex/IndexData',
                request_serializer=lazo__index__pb2.ColumnValue.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoSketchData.FromString,
                )
        self.IndexDataPath = channel.unary_unary(
                '/lazo_index.LazoIndex/IndexDataPath',
                request_serializer=lazo__index__pb2.DataPath.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoSketchDataList.FromString,
                )
        self.GetLazoSketchFromData = channel.stream_unary(
                '/lazo_index.LazoIndex/GetLazoSketchFromData',
                request_serializer=lazo__index__pb2.ColumnValue.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoSketchData.FromString,
                )
        self.GetLazoSketchFromDataPath = channel.unary_unary(
                '/lazo_index.LazoIndex/GetLazoSketchFromDataPath',
                request_serializer=lazo__index__pb2.DataPath.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoSketchDataList.FromString,
                )
        self.RemoveSketches = channel.unary_unary(
                '/lazo_index.LazoIndex/RemoveSketches',
                request_serializer=lazo__index__pb2.Dataset.SerializeToString,
                response_deserializer=lazo__index__pb2.Ack.FromString,
                )
        self.QueryData = channel.stream_unary(
                '/lazo_index.LazoIndex/QueryData',
                request_serializer=lazo__index__pb2.Value.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoQueryResults.FromString,
                )
        self.QueryDataPath = channel.unary_unary(
                '/lazo_index.LazoIndex/QueryDataPath',
                request_serializer=lazo__index__pb2.DataPath.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoQueryResultsList.FromString,
                )
        self.QueryLazoSketchData = channel.unary_unary(
                '/lazo_index.LazoIndex/QueryLazoSketchData',
                request_serializer=lazo__index__pb2.LazoSketchData.SerializeToString,
                response_deserializer=lazo__index__pb2.LazoQueryResults.FromString,
                )


class LazoIndexServicer(object):
    """Service responsible for indexing the values of a textual or categorical
    column using Lazo.
    """

    def IndexData(self, request_iterator, context):
        """Obtains a stream of values from a column and returns its
        corresponding Lazo sketch, while indexing the results.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IndexDataPath(self, request, context):
        """Obtains the path for a dataset and a set of columns,
        and returns their corresponding Lazo sketches,
        while indexing the results
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetLazoSketchFromData(self, request_iterator, context):
        """Obtains a stream of values from a column and returns its
        corresponding Lazo sketch. Does not index the results.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetLazoSketchFromDataPath(self, request, context):
        """Obtains the path for a dataset and a set of columns,
        and returns their corresponding Lazo sketches.
        Does not index the results
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveSketches(self, request, context):
        """Removes sketches corresponding to the input dataset
        from both the index and the storage.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def QueryData(self, request_iterator, context):
        """Obtains a stream of values from an input column, queries the Lazo index,
        and returns all the datasets that intersect with that input column.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def QueryDataPath(self, request, context):
        """Obtains the path for a dataset and a set of columns, queries the Lazo index,
        and returns all the datasets that intersect with the input columns.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def QueryLazoSketchData(self, request, context):
        """Obtains a Lazo sketch, queries the Lazo index,
        and returns all the datasets that intersect with the input columns.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_LazoIndexServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'IndexData': grpc.stream_unary_rpc_method_handler(
                    servicer.IndexData,
                    request_deserializer=lazo__index__pb2.ColumnValue.FromString,
                    response_serializer=lazo__index__pb2.LazoSketchData.SerializeToString,
            ),
            'IndexDataPath': grpc.unary_unary_rpc_method_handler(
                    servicer.IndexDataPath,
                    request_deserializer=lazo__index__pb2.DataPath.FromString,
                    response_serializer=lazo__index__pb2.LazoSketchDataList.SerializeToString,
            ),
            'GetLazoSketchFromData': grpc.stream_unary_rpc_method_handler(
                    servicer.GetLazoSketchFromData,
                    request_deserializer=lazo__index__pb2.ColumnValue.FromString,
                    response_serializer=lazo__index__pb2.LazoSketchData.SerializeToString,
            ),
            'GetLazoSketchFromDataPath': grpc.unary_unary_rpc_method_handler(
                    servicer.GetLazoSketchFromDataPath,
                    request_deserializer=lazo__index__pb2.DataPath.FromString,
                    response_serializer=lazo__index__pb2.LazoSketchDataList.SerializeToString,
            ),
            'RemoveSketches': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveSketches,
                    request_deserializer=lazo__index__pb2.Dataset.FromString,
                    response_serializer=lazo__index__pb2.Ack.SerializeToString,
            ),
            'QueryData': grpc.stream_unary_rpc_method_handler(
                    servicer.QueryData,
                    request_deserializer=lazo__index__pb2.Value.FromString,
                    response_serializer=lazo__index__pb2.LazoQueryResults.SerializeToString,
            ),
            'QueryDataPath': grpc.unary_unary_rpc_method_handler(
                    servicer.QueryDataPath,
                    request_deserializer=lazo__index__pb2.DataPath.FromString,
                    response_serializer=lazo__index__pb2.LazoQueryResultsList.SerializeToString,
            ),
            'QueryLazoSketchData': grpc.unary_unary_rpc_method_handler(
                    servicer.QueryLazoSketchData,
                    request_deserializer=lazo__index__pb2.LazoSketchData.FromString,
                    response_serializer=lazo__index__pb2.LazoQueryResults.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'lazo_index.LazoIndex', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class LazoIndex(object):
    """Service responsible for indexing the values of a textual or categorical
    column using Lazo.
    """

    @staticmethod
    def IndexData(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(request_iterator, target, '/lazo_index.LazoIndex/IndexData',
            lazo__index__pb2.ColumnValue.SerializeToString,
            lazo__index__pb2.LazoSketchData.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def IndexDataPath(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/lazo_index.LazoIndex/IndexDataPath',
            lazo__index__pb2.DataPath.SerializeToString,
            lazo__index__pb2.LazoSketchDataList.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetLazoSketchFromData(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(request_iterator, target, '/lazo_index.LazoIndex/GetLazoSketchFromData',
            lazo__index__pb2.ColumnValue.SerializeToString,
            lazo__index__pb2.LazoSketchData.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetLazoSketchFromDataPath(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/lazo_index.LazoIndex/GetLazoSketchFromDataPath',
            lazo__index__pb2.DataPath.SerializeToString,
            lazo__index__pb2.LazoSketchDataList.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RemoveSketches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/lazo_index.LazoIndex/RemoveSketches',
            lazo__index__pb2.Dataset.SerializeToString,
            lazo__index__pb2.Ack.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def QueryData(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(request_iterator, target, '/lazo_index.LazoIndex/QueryData',
            lazo__index__pb2.Value.SerializeToString,
            lazo__index__pb2.LazoQueryResults.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def QueryDataPath(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/lazo_index.LazoIndex/QueryDataPath',
            lazo__index__pb2.DataPath.SerializeToString,
            lazo__index__pb2.LazoQueryResultsList.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def QueryLazoSketchData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/lazo_index.LazoIndex/QueryLazoSketchData',
            lazo__index__pb2.LazoSketchData.SerializeToString,
            lazo__index__pb2.LazoQueryResults.FromString,
            options, channel_credentials,
            call_credentials, compression, wait_for_ready, timeout, metadata)
