# SPDX-FileCopyrightText: 2022 Kenneth Ryerson
#
# SPDX-License-Identifier: MIT
"""Pin definitions for the Radxa CM3."""

from adafruit_blinka.microcontroller.rockchip.rk3566 import pin

# CM3 IO pins

D0_B6 = pin.GPIO0_B6  # /I2C2_SDA_M0/SPI0_MOSI_M0/PWM2_M1
D0_B5 = pin.GPIO0_B5  # /I2C2_SCL_M0/SPI0_CLK_M0/PWM1_M1
D3_D5 = pin.GPIO3_D5  # /I2S1_SDI3_M1/SDMMC2_PWREN_M0
D0_D1 = pin.GPIO0_D1  # /UART2_TX_M0
D0_D0 = pin.GPIO0_D0  # /UART2_RX_M0
D0_C7 = pin.GPIO0_C7  # /PWM0_M1/UART0_CTSn
D3_C7 = pin.GPIO3_C7  # /I2S1_SCLK_TX_M1/SDMMC2_D1_M0
D0_B7 = pin.GPIO0_B7  # /PWM0_M0
D0_C3 = pin.GPIO0_C3  # /PWM4
D3_D4 = pin.GPIO3_D4  # /I2S1_SDI2_M1/SDMMC2_DET_M0
D3_D3 = pin.GPIO3_D3  # /I2S1_SDI1_M1/SDMMC2_CLK_M0
D4_B2 = pin.GPIO4_B2  # /SPI3_MOSI_M0/I2S2_SDI_M1/I2C4_SDA_M0
D4_B0 = pin.GPIO4_B0  # /SPI3_MISO_M0/I2S1_SDO1_M1
D3_C6 = pin.GPIO3_C6  # /I2S1_MCLK_M1/SDMMC2_D0_M0
D4_B3 = pin.GPIO4_B3  # /SPI3_CLK_M0/I2S2_SDO_M1/I2C4_SCL_M0
D4_A6 = pin.GPIO4_A6  # /SPI3_CS0_M0/I2S1_SCLK_RX
D4_B4 = pin.GPIO4_B4  # /I2C2_SDA_M1
D4_B5 = pin.GPIO4_B5  # /I2C2_SCL_M1/I2S1_SDO3_M1
D4_B1 = pin.GPIO4_B1  # /I2S1_SDO2_M1/ISP_PRELIGHT_TRIG
D0_C5 = pin.GPIO0_C5  # /SPI0_MISO_M0/PWM6
D4_C0 = pin.GPIO4_C0  # /PWM11_IR_M1
D0_C6 = pin.GPIO0_C6  # /SPI0_CS0_M0/PWM7_IR
D3_D0 = pin.GPIO3_D0  # /I2S1_LRCK_TX_M1/SDMMC2_D2_M0
D4_A7 = pin.GPIO4_A7  # /I2S1_LRCK_RX_M1/SPI3_CS1_M0
D0_C2 = pin.GPIO0_C2  # /PWM3_IR
D3_D2 = pin.GPIO3_D2  # /I2S1_SDI0_M1
D3_D1 = pin.GPIO3_D1  # /I2S1_SDO0_M1/SDMMC2_D3_M0
D0_B1 = pin.GPIO0_B1  # /I2C0_SCL
D0_B2 = pin.GPIO0_B2  # /I2C0_SDA


# Aliases for Raspberry Pi compute module compatibility

D2 = D0_B6
D3 = D0_B5
D4 = D3_D5
D5 = D4_B1
D6 = D0_C5

D8 = D4_A6
D9 = D4_B0
D10 = D4_B2
D11 = D4_B3
D12 = D4_C0
D13 = D0_C6
D14 = D0_D1
D15 = D0_D0
D16 = D4_A7
D17 = D0_C7
D18 = D3_C7
D19 = D3_D0
D20 = D3_D2
D21 = D3_D1
D22 = D0_C3
D23 = D3_D4
D24 = D3_D3
D25 = D3_C6
D26 = D0_C2
D27 = D0_B7

D44 = D0_B2
D45 = D0_B1


# I2C
SDA = D0_B6
SCL = D0_B5

# SPI
CE0 = D4_A6
SCLK = D4_B3
SCK = D4_B3
MOSI = D4_B2
MISO = D4_B0

# UART aliases
UART_TX = D0_D1
UART_RX = D0_D0
TXD = D0_D1
RXD = D0_D0
TX = D0_D1
RX = D0_D0
