from woningwaardering.vera.bvg.generated import Referentiedata
from woningwaardering.vera.referentiedatasoort import Referentiedatasoort


class UitexploitatieredenReferentiedata(Referentiedata):
    pass


class Uitexploitatiereden(Referentiedatasoort):
    administratief = UitexploitatieredenReferentiedata(
        code="ADM",
        naam="Administratief",
    )
    """
    De exploitatie van de eenheid van een andere eigenaar is beëindigd
    """

    planmatig_onderhoud = UitexploitatieredenReferentiedata(
        code="PLA",
        naam="Planmatig onderhoud",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat planmatig onderhoud
    plaatsvindt
    """

    renovatie = UitexploitatieredenReferentiedata(
        code="REN",
        naam="Renovatie",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat deze wordt gerenoveerd
    """

    samengevoegd = UitexploitatieredenReferentiedata(
        code="SAM",
        naam="Samengevoegd",
    )
    """
    De eenheid is uit exploitatie genomen omdat deze is samengevoegd met een andere
    eenheid
    """

    sloop = UitexploitatieredenReferentiedata(
        code="SLO",
        naam="Sloop",
    )
    """
    De eenheid is uit exploitatie genomen in afwachting van sloop
    """

    transformatie = UitexploitatieredenReferentiedata(
        code="TRA",
        naam="Transformatie",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen in afwachting van transformatie /
    sanering
    """

    uitruil = UitexploitatieredenReferentiedata(
        code="UIT",
        naam="Uitruil",
    )
    """
    De eenheid is uit exploitatie genomen nadat deze is uitgeruild met een andere
    vastgoedeigenaar
    """

    verkoop_aan_belegger = UitexploitatieredenReferentiedata(
        code="VAB",
        naam="Verkoop aan belegger",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    belegger
    """

    verkoop_aan_huurder = UitexploitatieredenReferentiedata(
        code="VAH",
        naam="Verkoop aan huurder",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    (voormalig) huurder
    """

    verkoop_aan_overige_natuurlijke_persoon = UitexploitatieredenReferentiedata(
        code="VAO",
        naam="Verkoop aan overige natuurlijke persoon",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze permanent is verkocht aan een
    overig natuurlijke persoon
    """

    vernieuwbouw = UitexploitatieredenReferentiedata(
        code="VEN",
        naam="Vernieuwbouw",
    )
    """
    De eenheid is (tijdelijk) uit exploitatie genomen omdat deze wordt verniewbouwd
    """

    verkoop_onder_voorwaarden = UitexploitatieredenReferentiedata(
        code="VOV",
        naam="Verkoop onder Voorwaarden",
    )
    """
    De eenheid is niet meer in exploitatie omdat deze is verkocht onder voorwaarden
    (VoV)
    """
