# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/musique.eval.ipynb.

# %% auto 0
__all__ = ['calculate_metrics', 'compare_answers']

# %% ../../nbs/musique.eval.ipynb 3
import evaluate
import pandas as pd

from ..text.utils import fuzzy_match

# %% ../../nbs/musique.eval.ipynb 4
def calculate_metrics(dataf: pd.DataFrame) -> dict:
    metric = evaluate.load("bdsaglam/musique")
    predictions = dataf["predicted_answer"].tolist()
    references = dataf["answer_aliases"].tolist()
    scores = metric.compute(predictions=predictions, references=references)
    return scores

# %% ../../nbs/musique.eval.ipynb 5
def _exact_match(example):
    pred = example['predicted_answer']
    return pred is not None and any(pred == ref for ref in example['answer_aliases'])

def _fuzzy_match(example):
    pred = example['predicted_answer']
    return pred is not None and any((pred in ref) or (ref in pred) or fuzzy_match(pred, ref) for ref in example['answer_aliases'])


def compare_answers(dataf: pd.DataFrame) -> pd.DataFrame:
    dataf['exact_match'] = dataf.apply(_exact_match, axis=1)
    dataf['fuzzy_match'] = dataf.apply(_fuzzy_match, axis=1)
    return dataf
