# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .user_account_status import UserAccountStatus
from .user_data import UserData
from .user_provider import UserProvider


class User(UniversalBaseModel):
    id: str
    seq: float
    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")]
    provider: UserProvider
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")]
    email: str
    name: str
    account_status: typing_extensions.Annotated[UserAccountStatus, FieldMetadata(alias="accountStatus")]
    location: typing.Optional[str] = None
    profile_image_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="profileImageUrl")] = None
    data: typing.Optional[UserData] = None
    org_id: typing_extensions.Annotated[str, FieldMetadata(alias="orgId")]
    org: typing.Optional["Org"] = None
    projects: typing.Optional[typing.List["Project"]] = None
    invites: typing.Optional[typing.List["Invite"]] = None
    chat_sessions: typing_extensions.Annotated[
        typing.Optional[typing.List["ChatSession"]], FieldMetadata(alias="chatSessions")
    ] = None
    moderators: typing.Optional[typing.List["Moderator"]] = None
    uploaded_files: typing_extensions.Annotated[
        typing.Optional[typing.List["File"]], FieldMetadata(alias="uploadedFiles")
    ] = None
    threads: typing.Optional[typing.List["Thread"]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .call import Call  # noqa: E402, F401, I001
from .call_event import CallEvent  # noqa: E402, F401, I001
from .chat_message import ChatMessage  # noqa: E402, F401, I001
from .chat_session import ChatSession  # noqa: E402, F401, I001
from .conversation_message import ConversationMessage  # noqa: E402, F401, I001
from .conversation_message_topic import ConversationMessageTopic  # noqa: E402, F401, I001
from .file import File  # noqa: E402, F401, I001
from .invite import Invite  # noqa: E402, F401, I001
from .invite_response import InviteResponse  # noqa: E402, F401, I001
from .moderator import Moderator  # noqa: E402, F401, I001
from .org import Org  # noqa: E402, F401, I001
from .participant import Participant  # noqa: E402, F401, I001
from .participant_invite import ParticipantInvite  # noqa: E402, F401, I001
from .project import Project  # noqa: E402, F401, I001
from .project_file import ProjectFile  # noqa: E402, F401, I001
from .thread import Thread  # noqa: E402, F401, I001
from .thread_file import ThreadFile  # noqa: E402, F401, I001

update_forward_refs(User)
