# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: sidra@plainconcepts.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class MetadataEntitiesEntityApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_metadata_entities_all_get(self, **kwargs):  # noqa: E501
        """api_metadata_entities_all_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_all_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param str api_version: The requested API version
        :return: list[CommonModelEntityResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_all_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_all_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_all_get_with_http_info(self, **kwargs):  # noqa: E501
        """api_metadata_entities_all_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_all_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date:
        :param str api_version: The requested API version
        :return: list[CommonModelEntityResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_all_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CommonModelEntityResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post(self, item_id_pipeline, **kwargs):  # noqa: E501
        """Associate a list of entities to a Pipeline  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post(item_id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id_pipeline: The Pipeline to associate the entities to (required)
        :param list[int] body: List of the entities ids to associate to the pipeline
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post_with_http_info(item_id_pipeline, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post_with_http_info(item_id_pipeline, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post_with_http_info(self, item_id_pipeline, **kwargs):  # noqa: E501
        """Associate a list of entities to a Pipeline  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post_with_http_info(item_id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id_pipeline: The Pipeline to associate the entities to (required)
        :param list[int] body: List of the entities ids to associate to the pipeline
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id_pipeline', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id_pipeline' is set
        if ('item_id_pipeline' not in params or
                params['item_id_pipeline'] is None):
            raise ValueError("Missing the required parameter `item_id_pipeline` when calling `api_metadata_entities_associate_entities_to_pipeline_item_id_pipeline_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id_pipeline' in params:
            path_params['itemIdPipeline'] = params['item_id_pipeline']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/associateEntitiesToPipeline/{itemIdPipeline}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_deploy_id_entity_put(self, id_entity, **kwargs):  # noqa: E501
        """Update the entity to allow deploy it in the next data ingestion execution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_deploy_id_entity_put(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_deploy_id_entity_put_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_deploy_id_entity_put_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_deploy_id_entity_put_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Update the entity to allow deploy it in the next data ingestion execution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_deploy_id_entity_put_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_deploy_id_entity_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_deploy_id_entity_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/deploy/{idEntity}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_asset_additional_properties_get(self, entity_id, **kwargs):  # noqa: E501
        """Get all asset additional properties for a specific entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_asset_additional_properties_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity to get additional properties from (required)
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: list[MetadataAssetsAssetAdditionalPropertiesDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_asset_additional_properties_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_asset_additional_properties_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_asset_additional_properties_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Get all asset additional properties for a specific entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_asset_additional_properties_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity to get additional properties from (required)
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: list[MetadataAssetsAssetAdditionalPropertiesDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'skip', 'take', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_asset_additional_properties_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_asset_additional_properties_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/assetAdditionalProperties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataAssetsAssetAdditionalPropertiesDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_attributes_detail_get(self, entity_id, **kwargs):  # noqa: E501
        """Gets a list of Attributes filtered by entity Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_attributes_detail_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity id (required)
        :param str api_version: The requested API version
        :return: list[MetadataAttributesAttributeDetailDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_attributes_detail_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_attributes_detail_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_attributes_detail_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Gets a list of Attributes filtered by entity Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_attributes_detail_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity id (required)
        :param str api_version: The requested API version
        :return: list[MetadataAttributesAttributeDetailDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_attributes_detail_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_attributes_detail_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/attributes/detail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataAttributesAttributeDetailDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_tags_get(self, entity_id, **kwargs):  # noqa: E501
        """Gets tag of this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to get the tags. (required)
        :param str api_version: The requested API version
        :return: list[MetadataTagsTagTagTypeFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_tags_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_tags_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_tags_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Gets tag of this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to get the tags. (required)
        :param str api_version: The requested API version
        :return: list[MetadataTagsTagTagTypeFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_tags_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_tags_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataTagsTagTagTypeFullDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_tags_post(self, entity_id, **kwargs):  # noqa: E501
        """Adds tag to this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_post(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to assign a tag. (required)
        :param MetadataTagsTagTagTypeDTO body: Information of the tag to be assigned
        :param str api_version: The requested API version
        :return: MetadataTagsTagTagTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_tags_post_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_tags_post_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_tags_post_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Adds tag to this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_post_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to assign a tag. (required)
        :param MetadataTagsTagTagTypeDTO body: Information of the tag to be assigned
        :param str api_version: The requested API version
        :return: MetadataTagsTagTagTypeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_tags_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_tags_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataTagsTagTagTypeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_tags_tag_id_delete(self, entity_id, tag_id, **kwargs):  # noqa: E501
        """Removes tag to this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_tag_id_delete(entity_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to unassing a tag. (required)
        :param int tag_id: The Id of the tag to remove from Entity. (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_tags_tag_id_delete_with_http_info(entity_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_tags_tag_id_delete_with_http_info(entity_id, tag_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_tags_tag_id_delete_with_http_info(self, entity_id, tag_id, **kwargs):  # noqa: E501
        """Removes tag to this entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_tags_tag_id_delete_with_http_info(entity_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: The Id of the Entity to unassing a tag. (required)
        :param int tag_id: The Id of the tag to remove from Entity. (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'tag_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_tags_tag_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_tags_tag_id_delete`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params or
                params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `api_metadata_entities_entity_id_tags_tag_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/tags/{tagId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_entity_id_view_definition_put(self, entity_id, **kwargs):  # noqa: E501
        """Updates the view definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_view_definition_put(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity Id to update (required)
        :param str body: View definition value
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_entity_id_view_definition_put_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_entity_id_view_definition_put_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_entity_id_view_definition_put_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Updates the view definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_entity_id_view_definition_put_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity Id to update (required)
        :param str body: View definition value
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_entity_id_view_definition_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_entities_entity_id_view_definition_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{entityId}/viewDefinition', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_get(self, **kwargs):  # noqa: E501
        """Gets a list of Entities filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseMetadataEntitiesEntityListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_get_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of Entities filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseMetadataEntitiesEntityListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'take', 'text', 'field', 'exact_match', 'sort_field', 'sort_desc', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'text' in params:
            query_params.append(('text', params['text']))  # noqa: E501
        if 'field' in params:
            query_params.append(('field', params['field']))  # noqa: E501
        if 'exact_match' in params:
            query_params.append(('exactMatch', params['exact_match']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))  # noqa: E501
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilterResponseMetadataEntitiesEntityListItemDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a specific Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The id of the Entity to remove. NOTE: You should remove all references related for this Entity before (Attributes, AttributeFormat, Assets...) (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a specific Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The id of the Entity to remove. NOTE: You should remove all references related for this Entity before (Attributes, AttributeFormat, Assets...) (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_entities_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_entity_attributes_get(self, id_entity, **kwargs):  # noqa: E501
        """Gets all the Attributes associated with the Entiy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_attributes_get(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param str api_version: The requested API version
        :return: list[MetadataAttributesAttributeFlattenedTagsFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_entity_attributes_get_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_entity_attributes_get_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_entity_attributes_get_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Gets all the Attributes associated with the Entiy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_attributes_get_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param str api_version: The requested API version
        :return: list[MetadataAttributesAttributeFlattenedTagsFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_entity_attributes_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_id_entity_attributes_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{idEntity}/attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataAttributesAttributeFlattenedTagsFullDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_entity_attributes_put(self, id_entity, **kwargs):  # noqa: E501
        """Replaces all Attributes associated with the Entity with the provided ones  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_attributes_put(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param list[MetadataAttributesAttributeFlattenedTagsFullDto] body: Attributes to assign to the entity
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_entity_attributes_put_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_entity_attributes_put_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_entity_attributes_put_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Replaces all Attributes associated with the Entity with the provided ones  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_attributes_put_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param list[MetadataAttributesAttributeFlattenedTagsFullDto] body: Attributes to assign to the entity
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_entity_attributes_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_id_entity_attributes_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{idEntity}/attributes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_entity_pipelines_get(self, id_entity, **kwargs):  # noqa: E501
        """Get all pipelines associated with the specific Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_get(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to query (required)
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_entity_pipelines_get_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_entity_pipelines_get_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_entity_pipelines_get_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Get all pipelines associated with the specific Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_get_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to query (required)
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_entity_pipelines_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_id_entity_pipelines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{idEntity}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityPipelineDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_entity_pipelines_id_pipeline_delete(self, id_entity, id_pipeline, **kwargs):  # noqa: E501
        """Delete the association of the Pipeline with the Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_id_pipeline_delete(id_entity, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param int id_pipeline: The Pipeline to remove (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_entity_pipelines_id_pipeline_delete_with_http_info(id_entity, id_pipeline, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_entity_pipelines_id_pipeline_delete_with_http_info(id_entity, id_pipeline, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_entity_pipelines_id_pipeline_delete_with_http_info(self, id_entity, id_pipeline, **kwargs):  # noqa: E501
        """Delete the association of the Pipeline with the Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_id_pipeline_delete_with_http_info(id_entity, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param int id_pipeline: The Pipeline to remove (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'id_pipeline', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_entity_pipelines_id_pipeline_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_id_entity_pipelines_id_pipeline_delete`")  # noqa: E501
        # verify the required parameter 'id_pipeline' is set
        if ('id_pipeline' not in params or
                params['id_pipeline'] is None):
            raise ValueError("Missing the required parameter `id_pipeline` when calling `api_metadata_entities_id_entity_pipelines_id_pipeline_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501
        if 'id_pipeline' in params:
            path_params['idPipeline'] = params['id_pipeline']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{idEntity}/pipelines/{idPipeline}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_entity_pipelines_id_pipeline_post(self, id_entity, id_pipeline, **kwargs):  # noqa: E501
        """Associate a Pipeline with the Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_id_pipeline_post(id_entity, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param int id_pipeline: The Pipeline to associate (required)
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_entity_pipelines_id_pipeline_post_with_http_info(id_entity, id_pipeline, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_entity_pipelines_id_pipeline_post_with_http_info(id_entity, id_pipeline, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_entity_pipelines_id_pipeline_post_with_http_info(self, id_entity, id_pipeline, **kwargs):  # noqa: E501
        """Associate a Pipeline with the Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_entity_pipelines_id_pipeline_post_with_http_info(id_entity, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Entity to use (required)
        :param int id_pipeline: The Pipeline to associate (required)
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'id_pipeline', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_entity_pipelines_id_pipeline_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_metadata_entities_id_entity_pipelines_id_pipeline_post`")  # noqa: E501
        # verify the required parameter 'id_pipeline' is set
        if ('id_pipeline' not in params or
                params['id_pipeline'] is None):
            raise ValueError("Missing the required parameter `id_pipeline` when calling `api_metadata_entities_id_entity_pipelines_id_pipeline_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501
        if 'id_pipeline' in params:
            path_params['idPipeline'] = params['id_pipeline']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{idEntity}/pipelines/{idPipeline}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityPipelineDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_get(self, id, **kwargs):  # noqa: E501
        """Get a Entity by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Entity to find (required)
        :param str include: Comma separated navigation properties from Entity which would be included in the returned result, e.g., Tags, Attributes.AttributeFormats
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullWithAttributesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a Entity by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Entity to find (required)
        :param str include: Comma separated navigation properties from Entity which would be included in the returned result, e.g., Tags, Attributes.AttributeFormats
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullWithAttributesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_entities_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntitiesEntityFullWithAttributesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_patch(self, id, **kwargs):  # noqa: E501
        """Update Partial entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: entityId to update (required)
        :param MetadataEntitiesEntityPartialUpdateDto body: Model to edit Entity
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityPartialUpdateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update Partial entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: entityId to update (required)
        :param MetadataEntitiesEntityPartialUpdateDto body: Model to edit Entity
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityPartialUpdateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_entities_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntitiesEntityPartialUpdateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_id_put(self, id, **kwargs):  # noqa: E501
        """Updates a Entity by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Entity to edit (required)
        :param MetadataEntitiesEntityDTO body: Model to edit Entity
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_id_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_id_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_id_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates a Entity by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_id_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Entity to edit (required)
        :param MetadataEntitiesEntityDTO body: Model to edit Entity
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_entities_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntitiesEntityFullDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_latest_get(self, **kwargs):  # noqa: E501
        """Get a list of entities for selected providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_latest_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] providers_ids: IDs of the providers associated to the entities to be retrieved.
        :param datetime start_date: Date from which Entity will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Entities from history.
        :param str api_version: The requested API version
        :return: list[CommonModelEntityResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_latest_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_latest_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_latest_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of entities for selected providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_latest_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] providers_ids: IDs of the providers associated to the entities to be retrieved.
        :param datetime start_date: Date from which Entity will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Entities from history.
        :param str api_version: The requested API version
        :return: list[CommonModelEntityResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ids', 'start_date', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_latest_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'providers_ids' in params:
            query_params.append(('providersIds', params['providers_ids']))  # noqa: E501
            collection_formats['providersIds'] = 'multi'  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CommonModelEntityResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_post(self, **kwargs):  # noqa: E501
        """Creates a Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataEntitiesEntityDTO body: Entity model to create
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_post_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a Entity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataEntitiesEntityDTO body: Entity model to create
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntityFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntitiesEntityFullDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_related_get(self, **kwargs):  # noqa: E501
        """Get a list of related entities given the parent entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_related_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int parent_entity_id: Parent entity of the relation.
        :param PersistenceCommonEntitiesDataIngestionEntityEntityRelationshipType entity_entity_relationship: Relation type between parent and child entities.
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_related_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_related_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_related_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of related entities given the parent entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_related_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int parent_entity_id: Parent entity of the relation.
        :param PersistenceCommonEntitiesDataIngestionEntityEntityRelationshipType entity_entity_relationship: Relation type between parent and child entities.
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent_entity_id', 'entity_entity_relationship', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_related_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent_entity_id' in params:
            query_params.append(('parentEntityId', params['parent_entity_id']))  # noqa: E501
        if 'entity_entity_relationship' in params:
            query_params.append(('entityEntityRelationship', params['entity_entity_relationship']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/related', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityFullDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_updatedeploymentdate_put(self, **kwargs):  # noqa: E501
        """Update the specified entities' deployment date to today's date.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_updatedeploymentdate_put(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: The entities to update
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_updatedeploymentdate_put_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_updatedeploymentdate_put_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_updatedeploymentdate_put_with_http_info(self, **kwargs):  # noqa: E501
        """Update the specified entities' deployment date to today's date.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_updatedeploymentdate_put_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: The entities to update
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_updatedeploymentdate_put" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/updatedeploymentdate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityFullDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_updaterecreatetable_put(self, **kwargs):  # noqa: E501
        """Update the specified entities' table recreation for the next deployment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_updaterecreatetable_put(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataEntitiesEntityRecreateTableDTO body: Request that contain the id of the entities to update and the new value for the recreate table flag.
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_updaterecreatetable_put_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_updaterecreatetable_put_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_updaterecreatetable_put_with_http_info(self, **kwargs):  # noqa: E501
        """Update the specified entities' table recreation for the next deployment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_updaterecreatetable_put_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataEntitiesEntityRecreateTableDTO body: Request that contain the id of the entities to update and the new value for the recreate table flag.
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_updaterecreatetable_put" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/updaterecreatetable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityFullDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_with_storage_volume_by_provider_provider_id_get(self, provider_id, **kwargs):  # noqa: E501
        """Gets a list of X number of entities paginated and sorted by storage volume.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_with_storage_volume_by_provider_provider_id_get(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: Identifier of the provider (required)
        :param bool sort_desc: Indicates if the ordering should be 'desc' or 'asc'
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntitiesWithTagsAndSizeDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_with_storage_volume_by_provider_provider_id_get_with_http_info(provider_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_with_storage_volume_by_provider_provider_id_get_with_http_info(provider_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_entities_with_storage_volume_by_provider_provider_id_get_with_http_info(self, provider_id, **kwargs):  # noqa: E501
        """Gets a list of X number of entities paginated and sorted by storage volume.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_with_storage_volume_by_provider_provider_id_get_with_http_info(provider_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int provider_id: Identifier of the provider (required)
        :param bool sort_desc: Indicates if the ordering should be 'desc' or 'asc'
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: MetadataEntitiesEntitiesWithTagsAndSizeDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_id', 'sort_desc', 'skip', 'take', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_with_storage_volume_by_provider_provider_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_id' is set
        if ('provider_id' not in params or
                params['provider_id'] is None):
            raise ValueError("Missing the required parameter `provider_id` when calling `api_metadata_entities_with_storage_volume_by_provider_provider_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_id' in params:
            path_params['providerId'] = params['provider_id']  # noqa: E501

        query_params = []
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/withStorageVolumeByProvider/{providerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataEntitiesEntitiesWithTagsAndSizeDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_entities_withattributes_get(self, **kwargs):  # noqa: E501
        """Get a list of entities filtered by their ids with their attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_withattributes_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body:
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullWithAttributesDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_entities_withattributes_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_entities_withattributes_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_entities_withattributes_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of entities filtered by their ids with their attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_entities_withattributes_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body:
        :param str api_version: The requested API version
        :return: list[MetadataEntitiesEntityFullWithAttributesDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_entities_withattributes_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/entities/withattributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataEntitiesEntityFullWithAttributesDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
