"""
[Module QPandaLitePy]
"""
from __future__ import annotations
import typing
__all__ = ['DensityOperatorSimulator', 'StatevectorSimulator', 'rand', 'seed']
class DensityOperatorSimulator:
    max_qubit_num: typing.ClassVar[int] = 10
    def __init__(self) -> None:
        ...
    def amplitude_damping(self, qn: int, gamma: float) -> None:
        ...
    def bitflip(self, qn: int, p: float) -> None:
        ...
    def cnot(self, controller: int, target: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def cswap(self, controller: int, target1: int, target2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def cz(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def depolarizing(self, qn: int, p: float) -> None:
        ...
    @typing.overload
    def get_prob(self, arg0: int, arg1: int) -> float:
        ...
    @typing.overload
    def get_prob(self, arg0: dict[int, int]) -> float:
        ...
    def hadamard(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def init_n_qubit(self, arg0: int) -> None:
        ...
    def iswap(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def kraus1q(self, qn: int, kraus_ops: list[list[complex[4]]]) -> None:
        ...
    def pauli_error_1q(self, qn: int, px: float, py: float, pz: float) -> None:
        ...
    def pauli_error_2q(self, qn1: int, qn2: int, p: list[float]) -> None:
        ...
    def phase2q(self, qn1: int, qn2: int, theta1: float, theta2: float, thetazz: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def phaseflip(self, qn: int, p: float) -> None:
        ...
    @typing.overload
    def pmeasure(self, arg0: int) -> list[float]:
        ...
    @typing.overload
    def pmeasure(self, arg0: list[int]) -> list[float]:
        ...
    def rphi(self, qn: int, theta: float, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rphi180(self, qn: int, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rphi90(self, qn: int, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rx(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def ry(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rz(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def s(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def stateprob(self) -> list[float]:
        ...
    def swap(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def sx(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def t(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def toffoli(self, controller1: int, controller2: int, target: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def twoqubit_depolarizing(self, qn1: int, qn2: int, p: float) -> None:
        ...
    def u1(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u2(self, qn: int, phi: float, lamda: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u22(self, qn: int, unitary: list[complex[4]], global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u3(self, qn: int, theta: float, phi: float, lamda: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def uu15(self, qn1: int, qn2: int, parameters: list[float], global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def x(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def xx(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def xy(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def y(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def yy(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def z(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def zz(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    @property
    def state(self) -> list[complex]:
        ...
    @property
    def total_qubit(self) -> int:
        ...
class StatevectorSimulator:
    max_qubit_num: typing.ClassVar[int] = 30
    def __init__(self) -> None:
        ...
    def amplitude_damping(self, qn: int, gamma: float) -> None:
        ...
    def bitflip(self, qn: int, p: float) -> None:
        ...
    def cnot(self, controller: int, target: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def cswap(self, controller: int, target1: int, target2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def cz(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def depolarizing(self, qn: int, p: float) -> None:
        ...
    @typing.overload
    def get_prob(self, qn: int, qstate: int) -> float:
        ...
    @typing.overload
    def get_prob(self, measure_map: dict[int, int]) -> float:
        ...
    def hadamard(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def init_n_qubit(self, arg0: int) -> None:
        ...
    def iswap(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def kraus1q(self, qn: int, kraus_ops: list[list[complex[4]]]) -> None:
        ...
    @typing.overload
    def measure_single_shot(self, qubit: int) -> int:
        ...
    @typing.overload
    def measure_single_shot(self, qubits: list[int]) -> int:
        ...
    def pauli_error_1q(self, qn: int, px: float, py: float, pz: float) -> None:
        ...
    def pauli_error_2q(self, qn1: int, qn2: int, p: list[float]) -> None:
        ...
    def phase2q(self, qn1: int, qn2: int, theta1: float, theta2: float, thetazz: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def phaseflip(self, qn: int, p: float) -> None:
        ...
    @typing.overload
    def pmeasure(self, qn: int) -> list[float]:
        ...
    @typing.overload
    def pmeasure(self, measure_qubits: list[int]) -> list[float]:
        ...
    def rphi(self, qn: int, theta: float, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rphi180(self, qn: int, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rphi90(self, qn: int, phi: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rx(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def ry(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def rz(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def s(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def swap(self, qn1: int, qn2: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def sx(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def t(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def toffoli(self, controller1: int, controller2: int, target: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def twoqubit_depolarizing(self, qn1: int, qn2: int, p: float) -> None:
        ...
    def u1(self, qn: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u2(self, qn: int, phi: float, lamda: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u22(self, qn: int, unitary: list[complex[4]], global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def u3(self, qn: int, theta: float, phi: float, lamda: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def uu15(self, qn1: int, qn2: int, parameters: list[float], global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def x(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def xx(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def xy(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def y(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def yy(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def z(self, qn: int, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    def zz(self, qn1: int, qn2: int, theta: float, global_controller: list[int] = [], dagger: bool = False) -> None:
        ...
    @property
    def state(self) -> list[complex]:
        ...
    @property
    def total_qubit(self) -> int:
        ...
def rand() -> float:
    ...
def seed(arg0: int) -> None:
    ...
