import pprint,time
from .utils import ImageUtils

class OCR:              

    def imgToText(self, screen:bytes) -> str:        
        pass
           

    def imgToTexts(self, screen:bytes)-> list[str]:   
        pass


simplePng = b'\xff\xd8\xff\xe0\x00\x10JFIF\x00\x01\x01\x00\x00\x01\x00\x01\x00\x00\xff\xdb\x00C\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xff\xdb\x00C\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xff\xc0\x00\x11\x08\x00\x1a\x00G\x03\x01"\x00\x02\x11\x01\x03\x11\x01\xff\xc4\x00\x1c\x00\x00\x03\x00\x02\x03\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x08\x06\n\x03\x05\t\x04\xff\xc4\x00*\x10\x00\x02\x02\x02\x02\x02\x01\x02\x05\x05\x00\x00\x00\x00\x00\x00\x05\x06\x03\x04\x02\x07\x01\x08\x00\x13\x14\t\x12\x11\x15\x16\x17\x18\n&5x\xb6\xff\xc4\x00\x17\x01\x01\x01\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x02\x04\x00\xff\xc4\x00$\x11\x00\x03\x01\x00\x02\x02\x02\x02\x03\x01\x01\x00\x00\x00\x00\x00\x01\x02\x03\x04\x05\x12\x11\x13\x14!\x00\x06#1Q"2\xff\xda\x00\x0c\x03\x01\x00\x02\x11\x03\x11\x00?\x00\xdf\xe3\xc9\xc7q\xf6\x10\x9e\xaduK\xd7j\xba\x0fs\xef\xb7\x07Eg7HDjB\x1a G\x00\x96\x91\x8b%\x03.D\xe9\r\xe9\xbb\xb4\xb0\xcey\x9c\xa3\xf2\xfda\xf4\xc1]9~o\xba\xe4\xd6*\xd5\xaf[\xdb\x9d\x1d\xe7\x96\x1d\xcd\x17Y\x97\xb5z\x14.:\xa3\xb4\x9b\x8e\xe5\x1e\xbev\x00\xa4\xeb\x9dO\xec>}ot\rZ\xde\xc7\xeb\xb5J\xa6\xd9\xdbx\xed\x07Uc2\xafbZ\xb7(\xc4\xb9\x9b\xab\x06v\x0bqX\x9cj\xf2b*R\xc3 vmx`;x\xd0\xfb\xfb\x84\x04\xbb.N\x17\x94\xe4\x87_\x12\xb1\n\xaf\x89\x1e\xa4 \x02\x0b^\xd5\x82v\xbc\x96bbziR\xaa\xb2\x94\xc8g`\xa8)mY\xb2\xc8\x12\xd4\x90\xedJ\xe8II{\x12\xf7\xa4\x91\'ge\x8d*\rg\xd9\xf3\xef\x1br\x9e\x9bs\xea\xef`\xf4S\x11-~\xc9\xb2\x05\x17\xdaE\xfa\xc8ep\x90%S\xea\x8bekAcH\xf6?q\x18\xaeS\x82NA\xfe5r\x01iU\x9a\xbf\xcb\x97\x9b\xb8s\x068H\xdf\xdc\xfb\\\x1e\x8f\xd6\x8c\xdbE\x8cI\xf3\xa1\xd61\x13\xf2\x04+B&s\xe4&4tb\xf5\n\xc3b<e|?2\xe6@\xb5_fd\x0c\x8f\xaf\x14\x1cK.S\xfe8q\x86~o\xf5\x8dg\xf4\xdfu\x87a\xfb\'\xdc-5\xf2\xfa\xb7\xb3\xf2\xf4v\xdb\xb4?\xc9{\xac\x1e\x9d\xb3\xa4\xf8\xf7#[\xfe_v\xcf\xf4\x85Q\xbe\xdf\xb1\x82\xbf\xcdG\xfc\xeak\xa2%\xf8\xa7\xff\x00,\xf6\x88y\xfdJv6\xabL\xea\xebj\xe6\xcb\xd9c\xf5\xc4\xdb\n\xf2\xe0UY\xe2\xd8]q@s"@;b\xeb\r\xf9\xd0\xe7\xed>\xd6\xd3\xba\x84\xa9\x90TG\xe4Vz\xcc-\x93AV\xac|\xdb\xc9}\x9b,#^)\xdbXK\x86\xc1\xb2~F\x9d\x99yA\xfcfg\xb6\xa8~\xcb\xcep\xb8\x96b\x94\xacV\x8e\x98\xb2M\xbd\xae\xb2\xf7\x97{&ug\x94\xb2\xe3g\xaf%\xc9f`\xa6X\xb5\xe1T\x14\x14\x03\xd1_\xd7\xf8~[A\xa9EJ\xb2-v\xe9`d\xbd\xc4\x02$\xda\xac\xabZ|\x04~\xa0\xf4C\xa8\xdfl3\xd5\xfd\xf4\x1b\x01a\x898\x13\x1c_etLeQ\x9a\xdc%\xbc\x83\x9d\xd9\x85v\r\xde\xe7A\xa7D\xaa\x83g\xc7\x85B\xd4I\xec\x9an\x94\x8ds&r\xa9p\x1e\xad\xd2\xd5\xaa\x0e\xbd\xee\xda=\x85\xd6T\xb6p\xe4G\xbdqV\xdb+\xe2\xa4\x8a\xbb\x1f\x94\\\xda)\x94\xd7/\x0c\x1a\xf5\x82I\xa5\xd7\x0f\x1b\x15F\xd8\xe9X\x96\x0bp \x88\x96\xc2UK\r\x8e\xb1Z\xb2eJ\xedYe\xd5\x92\x0e\xd5iZ\x9b\xea\xb1Z}\xaf\xedLB\xe4]8\xf1f\xe6\x1d\x92\xfe\x9cNl\xdd\xd8\xe4\xf6e\x16\xf9\x08\x90\xcf\x17\xac\xb5\x01<8c\xe7\x07jcK\xfc\x97Q\xee\xe3\x01\xb8\x82\xa3W\x10\x14\xcaP\xd8\x8f\xa1\xaf\xfa\xa9\x9fEZQO\xd8\x16\xdc\xd8\x10\x1b\xf6F\x1btc\xd6\xc6\xeb\x13\xfe\xd6Ytt\xd8\xee\xeeL8m\xa8\xfa\x9e\xe4\xe9\xa6V\x0b\x19.P\xed\xea@\x81\xdb\x17\x151Q\xe3J\xd8A7\xe8\x90\x1dQ\xa2\x8c\xdcZm\xa0\x9f\xc9i\xe9m\x12\xec\xc9\x9b?\xc5\xe4\xb5\xe14\xcdR\r)\x10\x90\xc6\xba\xad\xa1\x7f\xe7N\xaaZp\x94t\xe6\xcb\x86\xe8\xd2Mo\x94=\x88]RL\xf4\xe9>\xd7\x8d\xb8\xdc\xfbB^`\xb7[\x96\xbd\xe9)\xc0\x84\x94!,\xf5\xd1\xa6\xd2\xae\xbd\xcd\x96N\xd1ke\x0c\x9e\xeb\x9f\x07\xb9$+\xae\\\x83\xa5\xb3/\xa4hM\xcd\xb9\x19p\x9d\x98\x15\x86uVQ\xab\xdaA\x1fd\x96*\x8e\xc4\x02\xb4\x96\xe0q\xa3R`aI\xf1"\x8be\xa5\xe7z\xd7\x16kcT;\xa9\xa4\x0b\x17\x04\x100\xce\xc3\x9b\xb4~\xc0\xca1[\t\xd3~\xe0\x19\x04\x08\xa1KXR\xc8\x1b\xd38\xbd\x15mo\\0\x82\xb7\x9f\x15\xdc\xd7v\x01U\x93\x882a6.\xe3\xd7\xfd\x13z\xfa^\xa6\x9bSd\x8d\xc3\x8ds\xbe(v\x13Y\xa3\x9b6\x11)\xd0!\xc1\x8da\xc3V{-\xfb\x87\x16\xb3\x89\xd4Y\x03\xb0\xbcU\xd6)\x045\xb8 ,s\x1e\xbc[!v\xe4\xaa{9\x88\xc7\xcc\x98d\xbdU\xff\x00\x11\xbc\x7f\xda^\xc0\x7f\xdcZ\xf3<\xe8\xc7t2\xba\x15F\xe0\xef\xcc\xd01\x1f \x0c\xdb\x7f]\xc3\xf1\x9c\xafh%\xacy\xc3\xa5\xef\x13\xa3:z\x16QZ\xa5Ef\x9a@\x9esY\x9f\xe4<\xc0\xe2\t=\x9a\x1e\xca\xe4\xe7\xf7.\x98\x86\x12\xd0sMxt\xce\x99\xf4\xacu\xb8\xb1\xa5\xde5\x99\x93\xd4\xbe\x1e\x1e\x1e/\xe4\xfe\x1e%5\xce\xb52-\xc9\xcbm\xbf\xdb\x1dwe<\x8b\x04\xaf\x9d\x00W\x08\xdeSGCQ"\xc4EiA^R\x95\x07\xda\xbbf[\xac\xe5\xcc\xb8\xb5\xcc$5\xd6\xf3Vi\xe30\xb1\xc1\x17\x15\xc3\x07u\xf8y\x05\x01\xaaW\xcbw\x9a\xd5S\xec\xf5\x1e\xe5\x08\xec\x17\xfa\x14\xf5\x87\x90q\xe1\x84\xabyy\xe9j+Wf\xe8\xf3\xf2BP\xcc\xd1A S\xd4\xe2\x93Zx\xf1\xdekU\x9d\xc4\xdf\xb4\xfd\xf1\x85\xfa\xfba\x17I)\x1fPo\xb8\xfb4\x7fs\xed\xad\x95\xa8Z\x12\x84kVmu\xa9\x96\xf5\xd6\xa7s\xd7\xed#F\xbb\xbe\x00l/\x8e\xc40\xcb\xb8\xb6`\x96K\xcb\xe3\x91\x14\x86\x8d4\xb4-J\x06\x1b\xa5X\xaf\xda[\\\x82\x88\xca7\x1e\x1b5Y\xcd\xc4\x10\xb0\x89\x8f\x98k\xcc\xf2mU \xd2f \x16\x8d\x19&\x90$\xc5bL\xea\x8bW+2.\xf0\xa6m\xb2\x8d^\x01`\xe3<L\\\x01\x1dt\x8c\xd5\x17-\x13\x92\x85\xe1\xac_\x0f\x11IX\xe4\xce\xbe=8C\xaei\x90\x18(\xae\xfd<\x9d\x85K\xf6m\x1e\xed\xda\xf4\xde\xdf \xd7\xdb\xeeyS\xb4H\x98!4\x15\xd7o\x00\xd3s+\xe9c\xf6\x1d\x93\x16~:eW\xff\x00\x11\xf5\xe2\xcb\x9e3\x11Y\x89\xfa\x96\xa9\xe2\xdehP\\i\xe7\x1cK\x17#\x86\xebz\x8a\xbf;\xf4V\xe1Q\x1f\x84\x93\xcd\x02\xeavI`\x15\xdc\xb4\xa1lo\x95\xbd\x03\x9a+QNv\x1b@\xd8\xcd\xd6\xc6\x04BN\xc0\xe4O\x144\x8e\xb1J/S+\xd5Z\xcf-YI\xb8\x15&\x83G\x14\xc9\xba\xdfcD^35\x9b\x98\xeb%\xa2a\xc0\xc7>\xbb\x02J\xf5\xdb\xd7\xad)\ri\xa8\xcauLl\xb9\xd6\xa0\x98\x01\x8a\x86\xbdZ\x1e9EA~\x9c-/\x0f)(\xc91\x15\xf0&\xb1L\xe8\xa5Q\x84\xe19\xe1\x94\xe52\xcaL\x91\x13\x8e\xcePL\xafWm\x95\x1e+\xc8\xf2\x0f\xa9\xebZY\xbbQ\xbc\xfd\xcc\xf4@\'"\xf2;\x18X\xcaa$t;o\xd6\xd7\xd0P\xdfCX\xb6\x8aU\x92e"J]K\xd9C\x88\xbd\xdfZ\xee^\xf3\xd5\x90;\xedM\x85\xb2\xac\x05\xd4Z\xfb\xabuC\xff\x00{\x15\x86\xed\x1a\x058\xdd\x1a\x0bz\x98\xbeT\x00\xea\xd5DHpI\x95\xcaGp\x83\x82w\xd7b-b\xe5\xcb=2\x9fJ\xb6BDG X\xfa\x83\xf7,l,\x8dG\xdd\x8d\xc7\xca\x9fAn\xf1y\x99\xa2\xfeD\x8f\x12\xe7+\xfd\x1a\xb5%n/\xdd\xcf)\xb9\xa7O:\xf4*\xfe>\xbaUkE\xc7\x18qzxx1\x9a@g\x12P\xbf\x13\x0cx\xcc\xe5\x87v\x9f\x1f\x9dq\xa4\xb1w\xa7g|\xca\xbc~\x1e\xd2vd\xa3c\xcc\xf4\x0c\xf1FX\xa3\x1a\xb5\x99\xfc\x13}\xb7\xe4\xaa\x02\xaa\xa3o\xd0\xfa\xde\xda\xc4\xd4\t\xa5\x99\xb7\xed\x01\xd1T\xa2j\xd14\xeb:\xba\x9e8c\xca(b\x8b9\xa4\xb1\x9cq\xe1\x1ev&\xe2\x1cf\x9f,1\xe3\x1c\xa6\x97\x1a\xf1A_\x89%\xe7\x8es\x93\x88 \x86\x1e2\xcb\x9e"\x8a<>\xdc8<\xe4\xf0\xf1\t\xf2I><\x92O\xd0\x00}\xff\x00\x80\x00\x00\xff\x00\x00\x00\x0f\xe8\x0f\x1f\x92\x00P\x14y\xf0\x00\x03\xc9,|\x01\xe3\xed\x98\x96c\xfe\x96$\x93\xf6I?\x9f\xff\xd9'


class OCR_Paddle(OCR):
    
    def __init__(self, **kargs):
        from paddleocr import PaddleOCR

        # 不带预测的 标准OCR，精度高，但是多耗很多时间
        self.ocrEngine_std = PaddleOCR(lang='ch' , 
                 use_angle_cls=False, 
                 enable_mkldnn=False,
                 show_log=False, 
                 det_db_box_thresh=0.80,
                 **kargs
                 ) 
              
        # 带预测的 快速 OCR，精度也行，而且快很多
        self.ocrEngine_fast = PaddleOCR(lang='ch' , 
                 use_angle_cls=False, 
                 enable_mkldnn=True, # enable prediction to be fast
                 show_log=False, 
                 det_db_box_thresh=0.80,
                 **kargs
                 ) 
        
    
        self.ocrEngine =  self.ocrEngine_fast # use fast engine by default

        
        # PaddleOCR 存在一个奇怪的bug， 
        # enable_mkldnn=True 的 PaddleOCR实例
        # 需要先识别一次png， OCR结果就会准确很多
        # 否则至少第一次结果不准确

        txt = self.imgToText(simplePng)
        # print(txt)
        # time.sleep(1)


    def setOcrEngine(self, name:str='fast'):
        """set OCR engine betwine fast and std

        Parameters
        ----------
        name : str 
            engine name, 'fast' or 'std', by default 'fast'
        """
        if name == 'fast':
            self.ocrEngine =  self.ocrEngine_fast
        elif name == 'std':
            self.ocrEngine =  self.ocrEngine_std
        else:
            return 

    def imgToText(self, image:bytes, cropRange=None)-> str:    
        """OCR detect texts from image

        Parameters
        ----------
        image : bytes
            image bytes
        cropRange : tuple, optional
            crop range, in order of left_top_right_bottom, like (0,0,1000,2000)

        Returns
        -------
        str
            put all detected texts in one string seperated by new lines.
        """
        if cropRange:
            image = ImageUtils.imgBytesCrop(image, cropRange)

        ret =  self.ocrEngine.ocr(image,  cls=False)

        items = ret[0]

        # pprint.pprint(items,indent=2)

        if not items:
            return ''
        
        ret = [line[1][0] for line in items]

        return '\n'.join(ret)
            

    def imgToTexts(self, image:bytes, cropRange=None)-> list[str]:    
        """OCR detect texts from image

        Parameters
        ----------
        image : bytes
            image bytes
        cropRange : tuple, optional
            crop range, in order of left_top_right_bottom, like (0,0,1000,2000)

        Returns
        -------
        str
            put all detected texts in list
        """
        if cropRange:
            image = ImageUtils.imgBytesCrop(image, cropRange)

        ret = self.ocrEngine.ocr(image,  cls=False)

        items = ret[0]

        if not items:
            return []
        
        return items
    

    def imgFileToText(self, imageFile:str, cropRange=None)-> str:    
        """OCR detect texts from image

        Parameters
        ----------
        imageFile : str
            image file path
        cropRange : tuple, optional
            crop range, in order of left_top_right_bottom, like (0,0,1000,2000)

        Returns
        -------
        str
            put all detected texts in one string seperated by new lines.
        """

        with open(imageFile,'rb') as f:
            content = f.read()
        
        return self.imgToText(content, cropRange)


    def imgFileToTexts(self, imageFile:str, cropRange=None)-> list[str]:    
        """OCR detect texts from image

        Parameters
        ----------
        imageFile : str
            image file path
        cropRange : tuple, optional
            crop range, in order of left_top_right_bottom, like (0,0,1000,2000)

        Returns
        -------
        str
            put all detected texts in list
        """

        with open(imageFile,'rb') as f:
            content = f.read()
        
        return self.imgToTexts(content, cropRange)


class CFG:
    Default_OCR = OCR_Paddle