# Copyright 2021, Gurobi Optimization, LLC

from types import TracebackType
from typing import (
    Any,
    Callable,
    Dict,
    Generator,
    List,
    Literal,
    Iterable,
    Mapping,
    Optional,
    Sequence,
    Tuple,
    Type,
    TypeVar,
    Union,
    overload
)
import numpy as np

_T = TypeVar('_T')
_U = TypeVar('_U')
_LinExprLike = Union[float, Var, LinExpr]
_QuadExprLike = Union[float, Var, LinExpr, QuadExpr]
_NLExprLike = Union[float, Var, LinExpr, QuadExpr, NLExpr]
_Scalar = Union[int, float, str]
_ConstComponent = Union[int, float, np.ndarray]
_LinearComponent = Union[Var, LinExpr, MVar, MLinExpr]
_QuadComponent = Union[QuadExpr, MQuadExpr]
_ModelComponent = Union[Var, MVar, Constr, MConstr, QConstr, SOS, GenConstr]
_ShapeLike = Union[int, Tuple[int, ...]]
_IndexLike = Union[int, slice, Tuple[int, ...], Sequence[int], Tuple[Union[Sequence[int], int, slice], ...]]
_MLinExprLike = Union[np.ndarray, MVar, MLinExpr]
_MQuadExprLike = Union[np.ndarray, MVar, MLinExpr, MQuadExpr]
_MNLExprLike = Union[np.ndarray, MVar, MLinExpr, MQuadExpr, MNLExpr]

def abs_(__var: Var) -> GenExprAbs: ...
@overload
def and_(*args: Var) -> GenExprAnd: ...
@overload
def and_(__vars: Sequence[Var]) -> GenExprAnd: ...
@overload
def and_(__vars: tupledict[Any, Var]) -> GenExprAnd: ...
@overload
def max_(*args: Var, constant: Optional[float] = None) -> GenExprMax: ...
@overload
def max_(
    __vars: Sequence[Var],
    constant: Optional[float] = None
) -> GenExprMax: ...
@overload
def max_(
    __vars: tupledict[Any, Var],
    constant: Optional[float] = None
) -> GenExprMax: ...
@overload
def min_(*args: Var, constant: Optional[float] = None) -> GenExprMin: ...
@overload
def min_(
    __vars: Sequence[Var],
    constant: Optional[float] = None
) -> GenExprMin: ...
@overload
def min_(
    __vars: tupledict[Any, Var],
    constant: Optional[float] = None
) -> GenExprMin: ...
@overload
def norm(argvars: Sequence[Var], which: float) -> GenExprNorm: ...
@overload
def norm(argvars: tupledict[Any, Var], which: float) -> GenExprNorm: ...
@overload
def norm(argvars: MVar, which: float) -> GenExprNorm: ...
@overload
def or_(*args: Var) -> GenExprOr: ...
@overload
def or_(__vars: Sequence[Var]) -> GenExprOr: ...
@overload
def or_(__vars: tupledict[Any, Var]) -> GenExprOr: ...

def disposeDefaultEnv() -> None: ...
def getParamInfo(
    __paramname: str
) -> Tuple[str, Type[Any], Any, Any, Any, Any]: ...
def help(argument: Any = None) -> None: ...
def models() -> None: ...
@overload
def multidict(
    __data: Mapping[_T, float]
) -> Tuple[tuplelist[_T], tupledict[_T, float]]: ...
@overload
def multidict(
    __data: Mapping[Any, Iterable[float]]
) -> Tuple[Any, ...]: ...
@overload
def multidict(
    __data: Iterable[Tuple[Any, Iterable[float]]]
) -> Tuple[Any, ...]: ...
def paramHelp(paramname: Optional[str] = None) -> None: ...
@overload
def quicksum(__x: tupledict[Any, Var]) -> LinExpr: ...  # type: ignore[misc]
# Cannot write concisely without overlapping signature 3
@overload
def quicksum(__x: Iterable[_LinExprLike]) -> LinExpr: ...  # type: ignore[misc]
@overload
def quicksum(__x: Iterable[_QuadExprLike]) -> QuadExpr: ...  # type: ignore[misc]
@overload
def quicksum(__x: Iterable[_NLExprLike]) -> NLExpr: ...
@overload
def hstack(tup: Iterable[MVar]) -> MVar: ...  # type: ignore[misc]
@overload
def hstack(tup: Iterable[_MLinExprLike]) -> MLinExpr: ...  # type: ignore[misc]
@overload
def hstack(tup: Iterable[_MQuadExprLike]) -> MQuadExpr: ...  # type: ignore[misc]
@overload
def hstack(tup: Iterable[_MNLExprLike]) -> MNLExpr: ...
@overload
def hstack(tup: Iterable[MConstr]) -> MConstr: ...
@overload
def hstack(tup: Iterable[MQConstr]) -> MQConstr: ...
@overload
def vstack(tup: Iterable[MVar]) -> MVar: ...  # type: ignore[misc]
@overload
def vstack(tup: Iterable[_MLinExprLike]) -> MLinExpr: ...  # type: ignore[misc]
@overload
def vstack(tup: Iterable[_MQuadExprLike]) -> MQuadExpr: ...  # type: ignore[misc]
@overload
def vstack(tup: Iterable[_MNLExprLike]) -> MNLExpr: ...
@overload
def vstack(tup: Iterable[MConstr]) -> MConstr: ...
@overload
def vstack(tup: Iterable[MQConstr]) -> MQConstr: ...
@overload
def concatenate(tup: Iterable[MVar], axis: Optional[int] = None) -> MVar: ...  # type: ignore[misc]
@overload
def concatenate(tup: Iterable[_MLinExprLike], axis: Optional[int] = None) -> MLinExpr: ...  # type: ignore[misc]
@overload
def concatenate(tup: Iterable[_MQuadExprLike], axis: Optional[int] = None) -> MQuadExpr: ...  # type: ignore[misc]
@overload
def concatenate(tup: Iterable[_MNLExprLike], axis: Optional[int] = None) -> MNLExpr: ...
@overload
def concatenate(tup: Iterable[MConstr], axis: Optional[int] = None) -> MConstr: ...
@overload
def concatenate(tup: Iterable[MQConstr], axis: Optional[int] = None) -> MQConstr: ...
def read(filename: str, env: Optional[Env] = None) -> Model: ...
def readParams(__filename: str) -> None: ...
def resetParams() -> None: ...
@overload
def setParam(paramname: str, newvalue: float) -> None: ...
@overload
def setParam(paramname: str, newvalue: str) -> None: ...
def system(__command: str) -> None: ...
def writeParams(__filename: str) -> None: ...

class AttrConstClass:
    BarIterCount: str = ...
    BarX: str = ...
    BarPi: str = ...
    BatchErrorCode: str = ...
    BatchErrorMessage: str = ...
    BatchID: str = ...
    BatchStatus: str = ...
    BoundSVio: str = ...
    BoundSVioIndex: str = ...
    BoundSVioSum: str = ...
    BoundVio: str = ...
    BoundVioIndex: str = ...
    BoundVioSum: str = ...
    BranchPriority: str = ...
    CBasis: str = ...
    CTag: str = ...
    ComplVio: str = ...
    ComplVioIndex: str = ...
    ComplVioSum: str = ...
    ConcurrentWinMethod: str = ...
    ConstrName: str = ...
    ConstrResidual: str = ...
    ConstrResidualIndex: str = ...
    ConstrResidualSum: str = ...
    ConstrSResidual: str = ...
    ConstrSResidualIndex: str = ...
    ConstrSResidualSum: str = ...
    ConstrSVio: str = ...
    ConstrSVioIndex: str = ...
    ConstrSVioSum: str = ...
    ConstrVio: str = ...
    ConstrVioIndex: str = ...
    ConstrVioSum: str = ...
    DNumNZs: str = ...
    DStart: str = ...
    DualResidual: str = ...
    DualResidualIndex: str = ...
    DualResidualSum: str = ...
    DualSResidual: str = ...
    DualSResidualIndex: str = ...
    DualSResidualSum: str = ...
    DualSVio: str = ...
    DualSVioIndex: str = ...
    DualSVioSum: str = ...
    DualVio: str = ...
    DualVioIndex: str = ...
    DualVioSum: str = ...
    FarkasDual: str = ...
    FarkasProof: str = ...
    Fingerprint: str = ...
    FuncPieceError: str = ...
    FuncPieceLength: str = ...
    FuncPieceRatio: str = ...
    FuncPieces: str = ...
    GenConstrName: str = ...
    GenConstrType: str = ...
    IISConstr: str = ...
    IISConstrForce: str = ...
    IISGenConstr: str = ...
    IISGenConstrForce: str = ...
    IISLB: str = ...
    IISLBForce: str = ...
    IISMinimal: str = ...
    IISQConstr: str = ...
    IISQConstrForce: str = ...
    IISSOS: str = ...
    IISSOSForce: str = ...
    IISUB: str = ...
    IISUBForce: str = ...
    IntVio: str = ...
    IntVioIndex: str = ...
    IntVioSum: str = ...
    IsMIP: str = ...
    IsMultiObj: str = ...
    IsQCP: str = ...
    IsQP: str = ...
    IterCount: str = ...
    JobID: str = ...
    Kappa: str = ...
    KappaExact: str = ...
    LB: str = ...
    Lazy: str = ...
    LicenseExpiration: str = ...
    MIPGap: str = ...
    MaxBound: str = ...
    MaxCoeff: str = ...
    MaxMemUsed: str = ...
    MaxObjCoeff: str = ...
    MaxQCCoeff: str = ...
    MaxQCLCoeff: str = ...
    MaxQCRHS: str = ...
    MaxQObjCoeff: str = ...
    MaxRHS: str = ...
    MaxVio: str = ...
    MemUsed: str = ...
    MinBound: str = ...
    MinCoeff: str = ...
    MinObjCoeff: str = ...
    MinQCCoeff: str = ...
    MinQCLCoeff: str = ...
    MinQCRHS: str = ...
    MinQObjCoeff: str = ...
    MinRHS: str = ...
    ModelName: str = ...
    ModelSense: str = ...
    NodeCount: str = ...
    NumBinVars: str = ...
    NumConstrs: str = ...
    NumGenConstrs: str = ...
    NumIntVars: str = ...
    NumNZs: str = ...
    NumObj: str = ...
    NumPWLObjVars: str = ...
    NumQCNZs: str = ...
    NumQConstrs: str = ...
    NumQNZs: str = ...
    NumSOS: str = ...
    NumScenarios: str = ...
    NumStart: str = ...
    NumVars: str = ...
    Obj: str = ...
    ObjBound: str = ...
    ObjBoundC: str = ...
    ObjCon: str = ...
    ObjN: str = ...
    ObjNAbsTol: str = ...
    ObjNCon: str = ...
    ObjNName: str = ...
    ObjNPriority: str = ...
    ObjNRelTol: str = ...
    ObjNVal: str = ...
    ObjNWeight: str = ...
    ObjVal: str = ...
    OpenNodeCount: str = ...
    PStart: str = ...
    PWLObjCvx: str = ...
    Partition: str = ...
    Pi: str = ...
    PoolIgnore: str = ...
    PoolObjBound: str = ...
    PoolObjVal: str = ...
    PreFixVal: str = ...
    QCName: str = ...
    QCPi: str = ...
    QCRHS: str = ...
    QCSense: str = ...
    QCSlack: str = ...
    QCTag: str = ...
    RC: str = ...
    RHS: str = ...
    Runtime: str = ...
    Work: str = ...
    SALBLow: str = ...
    SALBUp: str = ...
    SAObjLow: str = ...
    SAObjUp: str = ...
    SARHSLow: str = ...
    SARHSUp: str = ...
    SAUBLow: str = ...
    SAUBUp: str = ...
    ScenNLB: str = ...
    ScenNName: str = ...
    ScenNObj: str = ...
    ScenNObjBound: str = ...
    ScenNObjVal: str = ...
    ScenNRHS: str = ...
    ScenNUB: str = ...
    ScenNX: str = ...
    Sense: str = ...
    Server: str = ...
    Slack: str = ...
    SolCount: str = ...
    Start: str = ...
    Status: str = ...
    TuneResultCount: str = ...
    UB: str = ...
    UnbdRay: str = ...
    VBasis: str = ...
    VTag: str = ...
    VType: str = ...
    VarHintPri: str = ...
    VarHintVal: str = ...
    VarName: str = ...
    VarPreStat: str = ...
    X: str = ...
    Xn: str = ...

class Batch:
    BatchErrorCode: int = ...
    BatchErrorMessage: str = ...
    BatchID: str = ...
    BatchStatus: int = ...
    def __init__(self, batchID: str, env: Env) -> None: ...
    def abort(self) -> None: ...
    def close(self) -> None: ...
    def discard(self) -> None: ...
    def dispose(self) -> None: ...
    def getJSONSolution(self) -> str: ...
    def retry(self) -> None: ...
    def update(self) -> None: ...
    def writeJSONSolution(self, filename: str) -> None: ...
    def __enter__(self) -> Batch: ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType]
    ) -> Optional[bool]: ...

class CallbackClass:
    BARRIER: int = ...
    BARRIER_COMPL: int = ...
    BARRIER_DUALINF: int = ...
    BARRIER_DUALOBJ: int = ...
    BARRIER_ITRCNT: int = ...
    BARRIER_PRIMINF: int = ...
    BARRIER_PRIMOBJ: int = ...
    IIS: int = ...
    IIS_BOUNDGUESS: int = ...
    IIS_BOUNDMAX: int = ...
    IIS_BOUNDMIN: int = ...
    IIS_CONSTRGUESS: int = ...
    IIS_CONSTRMAX: int = ...
    IIS_CONSTRMIN: int = ...
    MAXMEMUSED: int = ...
    MEMUSED: int = ...
    MESSAGE: int = ...
    MIP: int = ...
    MIPNODE: int = ...
    MIPNODE_BRVAR: int = ...
    MIPNODE_NODCNT: int = ...
    MIPNODE_OBJBND: int = ...
    MIPNODE_OBJBST: int = ...
    MIPNODE_OPENSCENARIOS: int = ...
    MIPNODE_PHASE: int = ...
    MIPNODE_REL: int = ...
    MIPNODE_SOLCNT: int = ...
    MIPNODE_STATUS: int = ...
    MIPSOL: int = ...
    MIPSOL_NODCNT: int = ...
    MIPSOL_OBJ: int = ...
    MIPSOL_OBJBND: int = ...
    MIPSOL_OBJBST: int = ...
    MIPSOL_OPENSCENARIOS: int = ...
    MIPSOL_PHASE: int = ...
    MIPSOL_SOL: int = ...
    MIPSOL_SOLCNT: int = ...
    MIP_CUTCNT: int = ...
    MIP_ITRCNT: int = ...
    MIP_NODCNT: int = ...
    MIP_NODLFT: int = ...
    MIP_OBJBND: int = ...
    MIP_OBJBST: int = ...
    MIP_OPENSCENARIOS: int = ...
    MIP_PHASE: int = ...
    MIP_SOLCNT: int = ...
    MSG_STRING: int = ...
    MULTIOBJ: int = ...
    MULTIOBJ_OBJCNT: int = ...
    MULTIOBJ_SOL: int = ...
    MULTIOBJ_SOLCNT: int = ...
    MULTIOBJ_ITRCNT: int = ...
    MULTIOBJ_OBJBST: int = ...
    MULTIOBJ_OBJBND: int = ...
    MULTIOBJ_STATUS: int = ...
    MULTIOBJ_MIPGAP: int = ...
    MULTIOBJ_NODCNT: int = ...
    MULTIOBJ_NODLFT: int = ...
    MULTIOBJ_RUNTIME: int = ...
    MULTIOBJ_WORK: int = ...
    POLLING: int = ...
    PRESOLVE: int = ...
    PRE_BNDCHG: int = ...
    PRE_COECHG: int = ...
    PRE_COLDEL: int = ...
    PRE_ROWDEL: int = ...
    PRE_SENCHG: int = ...
    RUNTIME: int = ...
    SIMPLEX: int = ...
    SPX_DUALINF: int = ...
    SPX_ISPERT: int = ...
    SPX_ITRCNT: int = ...
    SPX_OBJVAL: int = ...
    SPX_PRIMINF: int = ...
    WORK: int = ...

class Column:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, coeffs: float, constrs: Constr) -> None: ...
    @overload
    def __init__(
        self,
        coeffs: Sequence[float],
        constrs: Sequence[Constr]
    ) -> None: ...
    @overload
    def addTerms(self, coeffs: float, constrs: Constr) -> None: ...
    @overload
    def addTerms(
        self,
        coeffs: Sequence[float],
        constrs: Sequence[Constr]
    ) -> None: ...
    def clear(self) -> None: ...
    def copy(self) -> Column: ...
    def getCoeff(self, i: int) -> float: ...
    def getConstr(self, i: int) -> Constr: ...
    @overload
    def remove(self, which: int) -> None: ...
    @overload
    def remove(self, which: Constr) -> None: ...
    def size(self) -> int: ...

class Constr:
    BarPi: float = ...
    CBasis: int = ...
    CTag: str = ...
    ConstrName: str = ...
    DStart: float = ...
    FarkasDual: float = ...
    IISConstr: int = ...
    IISConstrForce: int = ...
    Lazy: int = ...
    Pi: float = ...
    RHS: float = ...
    SARHSLow: float = ...
    SARHSUp: float = ...
    ScenNRHS: float = ...
    Sense: str = ...
    Slack: float = ...
    def getAttr(self, attrname: str) -> Any: ...
    def sameAs(self, other: Constr) -> bool: ...
    @overload
    def setAttr(self, attrname: str, newval: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, newval: str) -> None: ...
    @property
    def index(self) -> int: ...

class Env:
    def __init__(
        self,
        logfilename: str = ...,
        empty: bool = False,
        params: Optional[Mapping[str, _Scalar]] = None
    ) -> None: ...
    def close(self) -> None: ...
    def dispose(self) -> None: ...
    def readParams(self, filename: str) -> None: ...
    def resetParams(self) -> None: ...
    @overload
    def setParam(self, paramname: str, newval: float) -> None: ...
    @overload
    def setParam(self, paramname: str, newval: str) -> None: ...
    def getParam(self, paramname: str) -> Union[float, str]: ...
    def start(self) -> Env: ...
    def writeParams(self, filename: str) -> None: ...
    def __enter__(self) -> Env: ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType]
    ) -> Optional[bool]: ...

class ErrorConstClass:
    CALLBACK: int = ...
    CLOUD: int = ...
    CSWORKER: int = ...
    DATA_NOT_AVAILABLE: int = ...
    DUPLICATES: int = ...
    EXCEED_2B_NONZEROS: int = ...
    FAILED_TO_CREATE_MODEL: int = ...
    FILE_READ: int = ...
    FILE_WRITE: int = ...
    IIS_NOT_INFEASIBLE: int = ...
    INDEX_OUT_OF_RANGE: int = ...
    INTERNAL: int = ...
    INVALID_ARGUMENT: int = ...
    INVALID_PIECEWISE_OBJ: int = ...
    JOB_REJECTED: int = ...
    MODEL_MODIFICATION: int = ...
    NETWORK: int = ...
    NODEFILE: int = ...
    NOT_FOR_MIP: int = ...
    NOT_IN_MODEL: int = ...
    NOT_SUPPORTED: int = ...
    NO_LICENSE: int = ...
    NULL_ARGUMENT: int = ...
    NUMERIC: int = ...
    OPTIMIZATION_IN_PROGRESS: int = ...
    OUT_OF_MEMORY: int = ...
    QCP_EQUALITY_CONSTRAINT: int = ...
    Q_NOT_PSD: int = ...
    SIZE_LIMIT_EXCEEDED: int = ...
    TUNE_MODEL_TYPES: int = ...
    UNKNOWN_ATTRIBUTE: int = ...
    UNKNOWN_PARAMETER: int = ...
    UPDATEMODE_CHANGE: int = ...
    VALUE_OUT_OF_RANGE: int = ...

class GRB:
    Attr: AttrConstClass = ...
    BASIC: int = ...
    BATCH_ABORTED: int = ...
    BATCH_COMPLETED: int = ...
    BATCH_CREATED: int = ...
    BATCH_FAILED: int = ...
    BATCH_SUBMITTED: int = ...
    BINARY: str = ...
    CONTINUOUS: str = ...
    CUTOFF: int = ...
    CUTS_AGGRESSIVE: int = ...
    CUTS_AUTO: int = ...
    CUTS_CONSERVATIVE: int = ...
    CUTS_OFF: int = ...
    CUTS_VERYAGGRESSIVE: int = ...
    Callback: CallbackClass = ...
    DEFAULT_CS_PORT: int = ...
    EQUAL: str = ...
    ERROR_CALLBACK: int = ...
    ERROR_CLOUD: int = ...
    ERROR_CSWORKER: int = ...
    ERROR_DATA_NOT_AVAILABLE: int = ...
    ERROR_DUPLICATES: int = ...
    ERROR_EXCEED_2B_NONZEROS: int = ...
    ERROR_FAILED_TO_CREATE_MODEL: int = ...
    ERROR_FILE_READ: int = ...
    ERROR_FILE_WRITE: int = ...
    ERROR_IIS_NOT_INFEASIBLE: int = ...
    ERROR_INDEX_OUT_OF_RANGE: int = ...
    ERROR_INTERNAL: int = ...
    ERROR_INVALID_ARGUMENT: int = ...
    ERROR_INVALID_PIECEWISE_OBJ: int = ...
    ERROR_JOB_REJECTED: int = ...
    ERROR_MODEL_MODIFICATION: int = ...
    ERROR_NETWORK: int = ...
    ERROR_NODEFILE: int = ...
    ERROR_NOT_FOR_MIP: int = ...
    ERROR_NOT_IN_MODEL: int = ...
    ERROR_NOT_SUPPORTED: int = ...
    ERROR_NO_LICENSE: int = ...
    ERROR_NULL_ARGUMENT: int = ...
    ERROR_NUMERIC: int = ...
    ERROR_OPTIMIZATION_IN_PROGRESS: int = ...
    ERROR_OUT_OF_MEMORY: int = ...
    ERROR_QCP_EQUALITY_CONSTRAINT: int = ...
    ERROR_Q_NOT_PSD: int = ...
    ERROR_SECURITY: int = ...
    ERROR_SIZE_LIMIT_EXCEEDED: int = ...
    ERROR_TUNE_MODEL_TYPES: int = ...
    ERROR_UNKNOWN_ATTRIBUTE: int = ...
    ERROR_UNKNOWN_PARAMETER: int = ...
    ERROR_UPDATEMODE_CHANGE: int = ...
    ERROR_VALUE_OUT_OF_RANGE: int = ...
    Error: ErrorConstClass = ...
    FEASRELAX_CARDINALITY: int = ...
    FEASRELAX_LINEAR: int = ...
    FEASRELAX_QUADRATIC: int = ...
    GENCONSTR_ABS: int = ...
    GENCONSTR_AND: int = ...
    GENCONSTR_COS: int = ...
    GENCONSTR_EXP: int = ...
    GENCONSTR_EXPA: int = ...
    GENCONSTR_INDICATOR: int = ...
    GENCONSTR_LOG: int = ...
    GENCONSTR_LOGA: int = ...
    GENCONSTR_LOGISTIC: int = ...
    GENCONSTR_MAX: int = ...
    GENCONSTR_MIN: int = ...
    GENCONSTR_NORM: int = ...
    GENCONSTR_OR: int = ...
    GENCONSTR_POLY: int = ...
    GENCONSTR_POW: int = ...
    GENCONSTR_PWL: int = ...
    GENCONSTR_SIN: int = ...
    GENCONSTR_TAN: int = ...
    GREATER_EQUAL: str = ...
    INFEASIBLE: int = ...
    INFINITY: float = ...
    INF_OR_UNBD: int = ...
    INPROGRESS: int = ...
    INTEGER: str = ...
    INTERRUPTED: int = ...
    ITERATION_LIMIT: int = ...
    LESS_EQUAL: str = ...
    LOADED: int = ...
    MAXIMIZE: int = ...
    MAXINT: int = ...
    MAX_CONCURRENT: int = ...
    MAX_NAMELEN: int = ...
    MAX_STRLEN: int = ...
    MAX_TAGLEN: int = ...
    MEM_LIMIT: int = ...
    METHOD_AUTO: int = ...
    METHOD_BARRIER: int = ...
    METHOD_CONCURRENT: int = ...
    METHOD_DETERMINISTIC_CONCURRENT: int = ...
    METHOD_DETERMINISTIC_CONCURRENT_SIMPLEX: int = ...
    METHOD_DUAL: int = ...
    METHOD_NONE: int = ...
    METHOD_PRIMAL: int = ...
    MINIMIZE: int = ...
    NODE_LIMIT: int = ...
    NONBASIC_LOWER: int = ...
    NONBASIC_UPPER: int = ...
    NUMERIC: int = ...
    OPTIMAL: int = ...
    PHASE_MIP_IMPROVE: int = ...
    PHASE_MIP_NOREL: int = ...
    PHASE_MIP_SEARCH: int = ...
    Param: ParamConstClass = ...
    SEMICONT: str = ...
    SEMIINT: str = ...
    SOLUTION_LIMIT: int = ...
    SOS_TYPE1: int = ...
    SOS_TYPE2: int = ...
    SUBOPTIMAL: int = ...
    SUPERBASIC: int = ...
    Status: StatusConstClass = ...
    TIME_LIMIT: int = ...
    UNBOUNDED: int = ...
    UNDEFINED: float = ...
    USER_OBJ_LIMIT: int = ...
    VERSION_MAJOR: int = ...
    VERSION_MINOR: int = ...
    VERSION_TECHNICAL: int = ...
    WORK_LIMIT: int = ...
    attr: AttrConstClass = ...
    callback: CallbackClass = ...
    error: ErrorConstClass = ...
    param: ParamConstClass = ...
    status: StatusConstClass = ...

class GenConstr:
    FuncNonlinear: int = ...
    FuncPieceError: float = ...
    FuncPieceLength: float = ...
    FuncPieceRatio: float = ...
    FuncPieces: int = ...
    GenConstrType: int = ...
    GenConstrName: str = ...
    IISGenConstr: int = ...
    IISGenConstrForce: int = ...
    def getAttr(self, attrname: str) -> Any: ...
    @overload
    def setAttr(self, attrname: str, newval: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, newval: str) -> None: ...

class GenExpr: ...

class GenExprAbs(GenExpr): ...

class GenExprAnd(GenExpr): ...

class GenExprMax(GenExpr): ...

class GenExprMin(GenExpr): ...

class GenExprNorm(GenExpr): ...

class GenExprOr(GenExpr): ...

class GurobiError(Exception):
    errno: int = ...
    message: str = ...

class LinExpr:
    @overload
    def __init__(
        self,
        arg1: float = 0.0,
        arg2: Optional[Var] = None
    ) -> None: ...
    @overload
    def __init__(self, arg1: Var) -> None: ...
    @overload
    def __init__(self, arg1: LinExpr) -> None: ...
    @overload
    def __init__(self, arg1: Sequence[float], arg2: Sequence[Var]) -> None: ...
    @overload
    def __init__(self, arg1: Sequence[Tuple[float, Var]]) -> None: ...
    @overload
    def add(self, arg1: float, mult: float = 1.0) -> None: ...
    @overload
    def add(self, arg1: Var, mult: float = 1.0) -> None: ...
    @overload
    def add(self, arg1: LinExpr, mult: float = 1.0) -> None: ...
    def addConstant(self, __constant: float) -> None: ...
    @overload
    def addTerms(self, newcoeffs: float, newvars: Var) -> None: ...
    @overload
    def addTerms(
        self,
        newcoeffs: Sequence[float],
        newvars: Sequence[Var]
    ) -> None: ...
    def clear(self) -> None: ...
    def copy(self) -> LinExpr: ...
    def getCoeff(self, __i: int) -> float: ...
    def getConstant(self) -> float: ...
    def getValue(self) -> float: ...
    def getVar(self, __i: int) -> Var: ...
    @overload
    def remove(self, __which: int) -> None: ...
    @overload
    def remove(self, __which: Var) -> None: ...
    def size(self) -> int: ...
    @overload
    def __add__(self, __expr: float) -> LinExpr: ...
    @overload
    def __add__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __add__(self, __expr: LinExpr) -> LinExpr: ...
    # used as constraint sense, not comparison
    @overload  # type: ignore[override]
    def __eq__(self, __rhs: float) -> TempLConstr: ...
    @overload
    def __eq__(self, __rhs: Var) -> TempLConstr: ...
    @overload
    def __eq__(self, __rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __eq__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __eq__(self, rhs: Sequence[float]) -> TempLConstr: ...
    @overload
    def __ge__(self, __rhs: float) -> TempLConstr: ...
    @overload
    def __ge__(self, __rhs: Var) -> TempLConstr: ...
    @overload
    def __ge__(self, __rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __ge__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __iadd__(self, __expr: float) -> LinExpr: ...
    @overload
    def __iadd__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __iadd__(self, __expr: LinExpr) -> LinExpr: ...
    @overload
    def __imul__(self, __expr: float) -> LinExpr: ...
    @overload
    def __imul__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __imul__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __imul__(self, __expr: QuadExpr) -> NLExpr: ...
    @overload
    def __isub__(self, __expr: float) -> LinExpr: ...
    @overload
    def __isub__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __isub__(self, __expr: LinExpr) -> LinExpr: ...
    @overload
    def __le__(self, __rhs: float) -> TempLConstr: ...
    @overload
    def __le__(self, __rhs: Var) -> TempLConstr: ...
    @overload
    def __le__(self, __rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __le__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __mul__(self, __expr: float) -> LinExpr: ...
    @overload
    def __mul__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __mul__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __mul__(self, expr: QuadExpr) -> NLExpr: ...
    def __neg__(self) -> LinExpr: ...
    @overload
    def __pow__(self, exponent: Literal[0]) -> float: ...
    @overload
    def __pow__(self, exponent: Literal[1]) -> LinExpr: ...
    @overload
    def __pow__(self, exponent: Literal[2]) -> QuadExpr: ...
    @overload
    def __pow__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rpow__(self, base: float) -> NLExpr: ...
    @overload
    def __radd__(self, __expr: float) -> LinExpr: ...
    @overload
    def __radd__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __radd__(self, __expr: LinExpr) -> LinExpr: ...
    @overload
    def __rmul__(self, __expr: float) -> LinExpr: ...
    @overload
    def __rmul__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __rmul__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __rsub__(self, __expr: float) -> LinExpr: ...
    @overload
    def __rsub__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __rsub__(self, __expr: LinExpr) -> LinExpr: ...
    @overload
    def __sub__(self, __expr: float) -> LinExpr: ...
    @overload
    def __sub__(self, __expr: Var) -> LinExpr: ...
    @overload
    def __sub__(self, __expr: LinExpr) -> LinExpr: ...
    @overload
    def __truediv__(self, expr: float) -> LinExpr: ...
    @overload
    def __truediv__(self, expr: Union[Var, LinExpr, QuadExpr]) -> NLExpr: ...
    def __rtruediv__(self, expr: float) -> NLExpr: ...

class MConstr:
    BarPi: float = ...
    CBasis: int = ...
    CTag: str = ...
    ConstrName: str = ...
    DStart: float = ...
    FarkasDual: float = ...
    IISConstr: int = ...
    IISConstrForce: int = ...
    Lazy: int = ...
    Pi: float = ...
    RHS: float = ...
    SARHSLow: float = ...
    SARHSUp: float = ...
    ScenNRHS: float = ...
    Sense: str = ...
    Slack: float = ...
    @classmethod
    def fromlist(cls, varlist: List[Constr]) -> MConstr: ...
    def getAttr(self, attrname: str) -> np.ndarray: ...
    @overload
    def setAttr(self, attrname: str, value: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: str) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: np.ndarray) -> None: ...
    def tolist(self) -> List[Constr]: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def size(self) -> int: ...

class MQConstr:
    QConstrName: str = ...
    QCRHS: float = ...
    QCSense: str = ...
    QCSlack: float = ...
    @classmethod
    def fromlist(cls, varlist: List[QConstr]) -> MQConstr: ...
    def getAttr(self, attrname: str) -> np.ndarray: ...
    @overload
    def setAttr(self, attrname: str, value: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: str) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: np.ndarray) -> None: ...
    def tolist(self) -> List[QConstr]: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def size(self) -> int: ...

class MGenConstr:
    GenConstrName: str = ...

class MLinExpr:
    @classmethod
    def zeros(self, shape: _ShapeLike) -> MLinExpr: ...
    def copy(self) -> MLinExpr: ...
    def getValue(self) -> np.ndarray: ...
    @overload
    def __add__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __add__(self, other: _LinearComponent) -> MLinExpr: ...
    # used as constraint sense, not comparison
    @overload  # type: ignore[override]
    def __eq__(self, other: _ConstComponent) -> TempMConstr: ...
    @overload
    def __eq__(self, other: _LinearComponent) -> TempMConstr: ...
    @overload
    def __ge__(self, other: Union[float, int]) -> TempMConstr: ...
    @overload
    def __ge__(self, other: _LinearComponent) -> TempMConstr: ...
    # unsafely overlaps with ndarray.__le__
    @overload
    def __ge__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMConstr: ...
    def __getitem__(self, obj: _IndexLike) -> MLinExpr: ...
    @overload
    def __iadd__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __iadd__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __imul__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __imul__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __isub__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __isub__(self, other: _LinearComponent) -> MLinExpr: ...
    # (Accurate) inconsistency with truediv
    def __itruediv__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __le__(self, other: Union[float, int]) -> TempMConstr: ...
    @overload
    def __le__(self, other: _LinearComponent) -> TempMConstr: ...
    # unsafely overlaps with ndarray.__ge__
    @overload
    def __le__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMConstr: ...
    @overload
    def __matmul__(self, other: MVar) -> MQuadExpr: ...
    @overload
    def __matmul__(self, other: MLinExpr) -> MQuadExpr: ...
    @overload
    def __matmul__(self, other: np.ndarray) -> MLinExpr: ...
    @overload
    def __mul__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __mul__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __pow__(self, exponent: Literal[2]) -> MQuadExpr: ...  # type: ignore[misc]
    @overload
    def __pow__(self, exponent: _ConstComponent) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _LinearComponent) -> MNLExpr: ...
    # unsafe overlap with numpy
    @overload
    def __rpow__(  # type: ignore[misc]
        self,
        base: _ConstComponent
    ) -> MNLExpr: ...
    @overload
    def __rpow__(self, base: _LinearComponent) -> MNLExpr: ...
    def __neg__(self) -> MLinExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __radd__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __radd__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __rmatmul__(self, other: MVar) -> MQuadExpr: ...
    @overload
    def __rmatmul__(self, other: MLinExpr) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmatmul__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmul__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __rmul__(self, other: _LinearComponent) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rsub__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __rsub__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __sub__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __sub__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __truediv__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __truediv__(self, other: _LinearComponent) -> MNLExpr: ...
    # unsafe overlap with numpy
    @overload
    def __rtruediv__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MNLExpr: ...
    @overload
    def __rtruediv__(self, other: _LinearComponent) -> MNLExpr: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def size(self) -> int: ...
    def clear(self) -> None: ...
    @overload
    def sum(self) -> MLinExpr: ...
    @overload
    def sum(self, axis: int) -> MLinExpr: ...
    def item(self) -> LinExpr: ...

class MQuadExpr:
    @classmethod
    def zeros(self, shape: _ShapeLike) -> MQuadExpr: ...
    def copy(self) -> MQuadExpr: ...
    def getValue(self) -> np.ndarray: ...
    @overload
    def __add__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __add__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __add__(self, other: _QuadComponent) -> MQuadExpr: ...
    # used as constraint sense, not comparison
    @overload  # type: ignore[override]
    def __eq__(self, other: _ConstComponent) -> TempMQConstr: ...
    @overload
    def __eq__(self, other: _LinearComponent) -> TempMQConstr: ...
    @overload
    def __eq__(self, other: _QuadComponent) -> TempMQConstr: ...
    @overload
    def __ge__(self, other: Union[float, int]) -> TempMQConstr: ...
    # unsafe overlap with ndarray.__le__
    @overload
    def __ge__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMQConstr: ...
    @overload
    def __ge__(self, other: _LinearComponent) -> TempMQConstr: ...
    @overload
    def __ge__(self, other: _QuadComponent) -> TempMQConstr: ...
    def __getitem__(self, obj: _IndexLike) -> MQuadExpr: ...
    @overload
    def __iadd__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __iadd__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __iadd__(self, other: _QuadComponent) -> MQuadExpr: ...
    # (Accurate) inconsistency with truediv
    def __imul__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MQuadExpr: ...
    @overload
    def __isub__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __isub__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __isub__(self, other: _QuadComponent) -> MQuadExpr: ...
    @overload
    def __le__(self, other: Union[float, int]) -> TempMQConstr: ...
    # unsafe overlap with ndarray.__le__
    @overload
    def __le__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMQConstr: ...
    @overload
    def __le__(self, other: _LinearComponent) -> TempMQConstr: ...
    @overload
    def __le__(self, other: _QuadComponent) -> TempMQConstr: ...
    @overload
    def __mul__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __mul__(self, expr: _LinearComponent) -> MNLExpr: ...
    @overload
    def __mul__(self, expr: _QuadComponent) -> MNLExpr: ...
    @overload
    def __truediv__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __truediv__(self, other: _LinearComponent) -> MNLExpr: ...
    @overload
    def __truediv__(self, other: _QuadComponent) -> MNLExpr: ...
    # unsafe overlap with numpy
    @overload
    def __rtruediv__(  # type: ignore[misc]
        self,
        other: _ConstComponent,
    ) -> MNLExpr: ...
    @overload
    def __rtruediv__(self, other: _LinearComponent) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _ConstComponent) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _LinearComponent) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _QuadComponent) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rpow__(  # type: ignore[misc]
        self,
        base: _ConstComponent
    ) -> MNLExpr: ...
    @overload
    def __rpow__(self, base: _LinearComponent) -> MNLExpr: ...
    def __neg__(self) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __radd__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MQuadExpr: ...
    @overload
    def __radd__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __radd__(self, other: _QuadComponent) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmul__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MQuadExpr: ...
    @overload
    def __rmul__(self, other: _LinearComponent) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rsub__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MQuadExpr: ...
    @overload
    def __rsub__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __rsub__(self, other: _QuadComponent) -> MQuadExpr: ...
    @overload
    def __sub__(self, other: _ConstComponent) -> MQuadExpr: ...
    @overload
    def __sub__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __sub__(self, other: _QuadComponent) -> MQuadExpr: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def size(self) -> int: ...
    def clear(self) -> None: ...
    @overload
    def sum(self) -> MQuadExpr: ...
    @overload
    def sum(self, axis: int) -> MQuadExpr: ...
    def item(self) -> QuadExpr: ...

class MNLExpr:

    @overload
    def __add__(self, exponent: _NLExprLike) -> MNLExpr: ...
    @overload
    def __add__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    @overload
    def __radd__(self, exponent: _NLExprLike) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __radd__(  # type: ignore[misc]
        self,
        exponent: _MQuadExprLike
    ) -> MNLExpr: ...

    @overload
    def __sub__(self, exponent: _NLExprLike) -> MNLExpr: ...
    @overload
    def __sub__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    @overload
    def __rsub__(self, exponent: _NLExprLike) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rsub__(  # type: ignore[misc]
        self,
        exponent: _MQuadExprLike
    ) -> MNLExpr: ...

    @overload
    def __mul__(self, exponent: _NLExprLike) -> MNLExpr: ...
    @overload
    def __mul__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    @overload
    def __rmul__(self, exponent: _NLExprLike) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmul__(  # type: ignore[misc]
        self,
        exponent: _MQuadExprLike
    ) -> MNLExpr: ...

    @overload
    def __pow__(self, exponent: _NLExprLike) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    @overload
    def __rpow__(self, exponent: _NLExprLike) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rpow__(  # type: ignore[misc]
        self,
        exponent: _MQuadExprLike
    ) -> MNLExpr: ...

    @overload
    def __truediv__(self, exponent: _NLExprLike) -> MNLExpr: ...
    @overload
    def __truediv__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    @overload
    def __rtruediv__(self, exponent: _NLExprLike) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rtruediv__(  # type: ignore[misc]
        self,
        exponent: _MQuadExprLike
    ) -> MNLExpr: ...

    def __neg__(self) -> MNLExpr: ...

class MVar:
    BarX: float = ...
    BranchPriority: int = ...
    IISLB: int = ...
    IISLBForce: int = ...
    IISUB: int = ...
    IISUBForce: int = ...
    LB: float = ...
    Obj: float = ...
    ObjN: float = ...
    PStart: float = ...
    PWLObjCvx: int = ...
    Partition: int = ...
    PoolIgnore: int = ...
    RC: float = ...
    SALBLow: float = ...
    SALBUp: float = ...
    SAObjLow: float = ...
    SAObjUp: float = ...
    SAUBLow: float = ...
    SAUBUp: float = ...
    ScenNLB: float = ...
    ScenNObj: float = ...
    ScenNUB: float = ...
    ScenNX: float = ...
    Start: float = ...
    UB: float = ...
    UnbdRay: float = ...
    VBasis: int = ...
    VTag: str = ...
    VType: str = ...
    VarHintPri: int = ...
    VarHintVal: float = ...
    VarName: str = ...
    X: float = ...
    Xn: float = ...
    @classmethod
    def fromvar(cls, var: Var) -> MVar: ...
    @classmethod
    def fromlist(cls, varlist: List[Var]) -> MVar: ...
    def copy(self) -> MVar: ...
    def getAttr(self, attrname: str) -> np.ndarray: ...
    @overload
    def setAttr(self, attrname: str, value: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: str) -> None: ...
    @overload
    def setAttr(self, attrname: str, value: np.ndarray) -> None: ...
    @overload
    def sum(self) -> MLinExpr: ...
    @overload
    def sum(self, axis: int) -> MLinExpr: ...
    def tolist(self) -> List[Var]: ...
    @overload
    def __add__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __add__(self, other: _LinearComponent) -> MLinExpr: ...
    # used as constraint sense, not comparison
    @overload   # type: ignore[override]
    def __eq__(self, other: _ConstComponent) -> TempMConstr: ...
    @overload
    def __eq__(self, other: _LinearComponent) -> TempMConstr: ...
    @overload
    def __eq__(self, other: MNLExpr) -> TempMGenConstr: ...
    @overload
    def __ge__(self, other: Union[float, int]) -> TempMConstr: ...
    @overload
    def __ge__(self, other: _LinearComponent) -> TempMConstr: ...
    # unsafely overlaps with ndarray.__le__
    @overload
    def __ge__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMConstr: ...
    def __getitem__(self, obj: _IndexLike) -> MVar: ...
    # (Accurate) inconsistency with truediv
    def __itruediv__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __le__(self, other: Union[float, int]) -> TempMConstr: ...
    @overload
    def __le__(self, other: _LinearComponent) -> TempMConstr: ...
    # unsafely overlaps with ndarray.__ge__
    @overload
    def __le__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> TempMConstr: ...
    @overload
    def __matmul__(self, other: MVar) -> MQuadExpr: ...
    @overload
    def __matmul__(self, other: MLinExpr) -> MQuadExpr: ...
    @overload
    def __matmul__(self, other: np.ndarray) -> MLinExpr: ...
    @overload
    def __mul__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __mul__(self, other: _LinearComponent) -> MQuadExpr: ...
    def __neg__(self) -> MLinExpr: ...
    def __pos__(self) -> MVar: ...
    @overload
    def __pow__(self, exponent: Literal[2]) -> MQuadExpr: ...
    @overload
    def __pow__(self, exponent: float) -> MNLExpr: ...
    @overload
    def __pow__(self, exponent: _MNLExprLike) -> MNLExpr: ...
    # (Accurate) inconsistency with truediv
    def __rpow__(  # type: ignore[misc]
        self,
        base: _ConstComponent
    ) -> MNLExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __radd__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __radd__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __rmatmul__(self, other: MLinExpr) -> MQuadExpr: ...
    @overload
    def __rmatmul__(self, other: MVar) -> MQuadExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmatmul__(  # type: ignore[misc]
        self,
        other: np.ndarray
    ) -> MLinExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rmul__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __rmul__(self, other: _LinearComponent) -> MQuadExpr: ...
    @overload
    def __rsub__(self, other: _LinearComponent) -> MLinExpr: ...
    # Unsafe overlap with numpy
    @overload
    def __rsub__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MLinExpr: ...
    @overload
    def __sub__(self, other: _LinearComponent) -> MLinExpr: ...
    @overload
    def __sub__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __truediv__(self, other: _ConstComponent) -> MLinExpr: ...
    @overload
    def __truediv__(self, other: _LinearComponent) -> MNLExpr: ...
    # Unsafe overlap with numpy
    def __rtruediv__(  # type: ignore[misc]
        self,
        other: _ConstComponent
    ) -> MNLExpr: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Tuple[int, ...]: ...
    @property
    def size(self) -> int: ...
    def transpose(self) -> MVar: ...
    @property
    def T(self) -> MVar: ...
    def reshape(self, shape: _ShapeLike) -> MVar: ...
    def item(self) -> Var: ...
    @overload
    def diagonal(self) -> MVar: ...
    @overload
    def diagonal(self, k: int) -> MVar: ...

class Model:
    BarIterCount: int = ...
    BoundSVio: float = ...
    BoundSVioIndex: int = ...
    BoundSVioSum: float = ...
    BoundVio: float = ...
    BoundVioIndex: int = ...
    BoundVioSum: float = ...
    ComplVio: float = ...
    ComplVioIndex: int = ...
    ComplVioSum: float = ...
    ConcurrentWinMethod: int = ...
    ConstrResidual: float = ...
    ConstrResidualIndex: int = ...
    ConstrResidualSum: float = ...
    ConstrSResidual: float = ...
    ConstrSResidualIndex: int = ...
    ConstrSResidualSum: float = ...
    ConstrSVio: float = ...
    ConstrSVioIndex: int = ...
    ConstrSVioSum: float = ...
    ConstrVio: float = ...
    ConstrVioIndex: int = ...
    ConstrVioSum: float = ...
    DNumNZs: float = ...
    DualResidual: float = ...
    DualResidualIndex: int = ...
    DualResidualSum: float = ...
    DualSResidual: float = ...
    DualSResidualIndex: int = ...
    DualSResidualSum: float = ...
    DualSVio: float = ...
    DualSVioIndex: int = ...
    DualSVioSum: float = ...
    DualVio: float = ...
    DualVioIndex: int = ...
    DualVioSum: float = ...
    FarkasProof: float = ...
    Fingerprint: int = ...
    IISMinimal: int = ...
    IntVio: float = ...
    IntVioIndex: int = ...
    IntVioSum: float = ...
    IsMIP: int = ...
    IsMultiObj: int = ...
    IsQCP: int = ...
    IsQP: int = ...
    IterCount: float = ...
    Kappa: float = ...
    KappaExact: float = ...
    LicenseExpiration: int = ...
    MIPGap: float = ...
    MaxBound: float = ...
    MaxCoeff: float = ...
    MaxMemUsed: float = ...
    MaxObjCoeff: float = ...
    MaxQCCoeff: float = ...
    MaxQCLCoeff: float = ...
    MaxQCRHS: float = ...
    MaxQObjCoeff: float = ...
    MaxRHS: float = ...
    MaxVio: float = ...
    MemUsed: float = ...
    MinBound: float = ...
    MinCoeff: float = ...
    MinObjCoeff: float = ...
    MinQCCoeff: float = ...
    MinQCLCoeff: float = ...
    MinQCRHS: float = ...
    MinQObjCoeff: float = ...
    MinRHS: float = ...
    ModelName: str = ...
    ModelSense: int = ...
    NodeCount: float = ...
    NumBinVars: int = ...
    NumConstrs: int = ...
    NumGenConstrs: int = ...
    NumIntVars: int = ...
    NumNZs: int = ...
    NumObj: int = ...
    NumPWLObjVars: int = ...
    NumQCNZs: int = ...
    NumQConstrs: int = ...
    NumQNZs: int = ...
    NumSOS: int = ...
    NumScenarios: int = ...
    NumStart: int = ...
    NumVars: int = ...
    ObjBound: float = ...
    ObjBoundC: float = ...
    ObjCon: float = ...
    ObjNAbsTol: float = ...
    ObjNCon: float = ...
    ObjNName: str = ...
    ObjNPriority: int = ...
    ObjNRelTol: float = ...
    ObjNVal: float = ...
    ObjNWeight: float = ...
    ObjVal: float = ...
    OpenNodeCount: float = ...
    Params: ParamClass = ...
    PoolObjBound: float = ...
    PoolObjVal: float = ...
    Runtime: float = ...
    Work: float = ...
    ScenNName: str = ...
    ScenNObjBound: float = ...
    ScenNObjVal: float = ...
    Server: str = ...
    SolCount: int = ...
    Status: int = ...
    TuneResultCount: int = ...
    params: ParamClass = ...
    def __init__(self, name: str = ..., env: Optional[Env] = None) -> None: ...
    @overload
    def addConstr(self, __tc: TempLConstr, name: str = ...) -> Constr: ...
    @overload
    def addConstr(self, __tc: TempQConstr, name: str = ...) -> QConstr: ...
    @overload
    def addConstr(self, __tc: TempMConstr, name: str = ...) -> MConstr: ...
    @overload
    def addConstr(self, __tc: TempMQConstr, name: str = ...) -> MQConstr: ...
    @overload
    def addConstr(self, __tc: TempGenConstr, name: str = ...) -> GenConstr: ...
    @overload
    def addConstr(self, __tc: TempMGenConstr, name: str = ...) -> MGenConstr: ...
    @overload
    def addConstrs(
        self,
        constrs: Generator[TempLConstr, None, None],
        name: str = ...
    ) -> tupledict[Any, Constr]: ...
    @overload
    def addConstrs(
        self,
        constrs: Generator[TempQConstr, None, None],
        name: str = ...
    ) -> tupledict[Any, QConstr]: ...
    @overload
    def addConstrs(
        self,
        constrs: Generator[TempMConstr, None, None],
        name: str = ...
    ) -> tupledict[Any, MConstr]: ...
    @overload
    def addConstrs(
        self,
        constrs: Generator[TempGenConstr, None, None],
        name: str = ...
    ) -> tupledict[Any, GenConstr]: ...
    def addGenConstrAbs(
        self,
        resvar: Var,
        argvar: Var,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrAnd(
        self,
        resvar: Var,
        vars: Sequence[Var],
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrAnd(
        self,
        resvar: Var,
        vars: tupledict[Any, Var],
        name: str = ...
    ) -> GenConstr: ...
    def addGenConstrCos(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrExp(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrExpA(
        self,
        xvar: Var,
        yvar: Var,
        a: float,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrIndicator(
        self,
        binvar: Var,
        binval: bool,
        lhs: _LinExprLike,
        sense: str,
        rhs: float,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrIndicator(
        self,
        binvar: MVar,
        binval: Union[bool, float, int, np.ndarray],
        lhs: Union[MVar, MLinExpr],
        sense: str,
        rhs: Union[float, int, np.ndarray],
        name: str = ...,
        options: str = ...
    ) -> MGenConstr: ...
    @overload
    def addGenConstrIndicator(
        self,
        binvar: Var,
        binval: bool,
        __tc: TempGenConstr,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrIndicator(
        self,
        binvar: MVar,
        binval: Union[bool, float, int, np.ndarray],
        __tc: TempMConstr,
        name: str = ...,
        options: str = ...
    ) -> MGenConstr: ...
    def addGenConstrLog(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrLogA(
        self,
        xvar: Var,
        yvar: Var,
        a: float,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrLogistic(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrMax(
        self,
        resvar: Var,
        vars: Sequence[Var],
        constant: Optional[float] = None,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrMax(
        self,
        resvar: Var,
        vars: tupledict[Any, Var],
        constant: Optional[float] = None,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrMin(
        self,
        resvar: Var,
        vars: Sequence[Var],
        constant: Optional[float] = None,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrMin(
        self,
        resvar: Var,
        vars: tupledict[Any, Var],
        constant: Optional[float] = None,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrNL(
        self,
        resvar: Var,
        expr: _NLExprLike,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrNL(
        self,
        resvar: MVar,
        expr: _MNLExprLike,
        name: str = ...
    ) -> MGenConstr: ...
    def addGenConstrNLAdv(
        self,
        resvar: Var,
        opcode: List[int],
        data: List[float],
        parent: List[int],
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrNorm(
        self,
        resvar: Var,
        vars: Sequence[Var],
        which: float,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrNorm(
        self,
        resvar: Var,
        vars: tupledict[Any, Var],
        which: float,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrNorm(
        self,
        resvar: Var,
        vars: MVar,
        which: float,
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrOr(
        self,
        resvar: Var,
        vars: Sequence[Var],
        name: str = ...
    ) -> GenConstr: ...
    @overload
    def addGenConstrOr(
        self,
        resvar: Var,
        vars: tupledict[Any, Var],
        name: str = ...
    ) -> GenConstr: ...
    def addGenConstrPWL(
        self,
        xvar: Var,
        yvar: Var,
        xpts: Sequence[float],
        ypts: Sequence[float],
        name: str = ...
    ) -> GenConstr: ...
    def addGenConstrPoly(
        self,
        xvar: Var,
        yvar: Var,
        p: Sequence[float],
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrPow(
        self,
        xvar: Var,
        yvar: Var,
        a: float,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    def addGenConstrSin(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...,
    ) -> GenConstr: ...
    def addGenConstrTan(
        self,
        xvar: Var,
        yvar: Var,
        name: str = ...,
        options: str = ...
    ) -> GenConstr: ...
    @overload
    def addLConstr(
        self,
        __tc: TempLConstr,
        name: str = ...
    ) -> Constr: ...
    @overload
    def addLConstr(
        self,
        lhs: _LinExprLike,
        sense: str,
        rhs: _LinExprLike,
        name: str = ...
    ) -> Constr: ...
    @overload
    def addMConstr(
        self,
        A: np.ndarray,
        x: Optional[MVar],
        sense: Union[np.ndarray, str],
        b: np.ndarray,
        name: str = ...
    ) -> MConstr: ...
    @overload
    def addMConstr(
        self,
        A: np.ndarray,
        x: Sequence[Var],
        sense: Union[np.ndarray, str],
        b: np.ndarray,
        name: str = ...
    ) -> MConstr: ...
    @overload
    def addMQConstr(
        self,
        Q: np.ndarray,
        c: Optional[np.ndarray],
        sense: str,
        xQ_L: Optional[MVar] = None,
        xQ_R: Optional[MVar] = None,
        xc: Optional[MVar] = None,
        name: str = ...
    ) -> None: ...
    @overload
    def addMQConstr(
        self,
        Q: np.ndarray,
        c: Optional[np.ndarray],
        sense: str,
        xQ_L: Optional[Sequence[Var]] = None,
        xQ_R: Optional[Sequence[Var]] = None,
        xc: Optional[Sequence[Var]] = None,
        name: str = ...
    ) -> None: ...
    @overload
    def addMVar(
        self,
        shape: Tuple[int, ...],
        lb: Optional[Union[float, np.ndarray]] = None,
        ub: Optional[Union[float, np.ndarray]] = None,
        obj: Optional[Union[float, np.ndarray]] = None,
        vtype: Optional[Union[str, np.ndarray]] = None,
        name: Optional[Union[str, Sequence[str]]] = None
    ) -> MVar: ...
    @overload
    def addMVar(
        self,
        shape: int,
        lb: Optional[Union[float, np.ndarray]] = None,
        ub: Optional[Union[float, np.ndarray]] = None,
        obj: Optional[Union[float, np.ndarray]] = None,
        vtype: Optional[Union[str, np.ndarray]] = None,
        name: Optional[Union[str, Sequence[str]]] = None
    ) -> MVar: ...
    @overload
    def addQConstr(
        self,
        __tc: TempQConstr,
        name: str = ...
    ) -> QConstr: ...
    @overload
    def addQConstr(
        self,
        lhs: _QuadExprLike,
        sense: str,
        rhs: _QuadExprLike,
        name: str = ...
    ) -> QConstr: ...
    @overload
    def addRange(
        self,
        expr: Var,
        lower: float,
        upper: float,
        name: str = ...
    ) -> Constr: ...
    @overload
    def addRange(
        self,
        expr: LinExpr,
        lower: float,
        upper: float,
        name: str = ...
    ) -> Constr: ...
    def addSOS(
        self,
        type: int,
        vars: Sequence[Var],
        wts: Optional[Sequence[float]] = None
    ) -> SOS: ...
    def addVar(
        self,
        lb: float = 0.0,
        ub: float = float('inf'),
        obj: float = 0.0,
        vtype: str = GRB.CONTINUOUS,
        name: str = ...,
        column: Optional[Column] = None
    ) -> Var: ...
    # single int arg + scalar kwargs
    @overload
    def addVars(
        self,
        __indices: int,
        *,
        lb: float = 0.0,
        ub: float = float('inf'),
        obj: float = 0.0,
        vtype: str = GRB.CONTINUOUS,
        name: str = ...
    ) -> tupledict[int, Var]: ...
    # multiple int args + scalar kwargs
    @overload
    def addVars(
        self,
        __indices1: int,
        __indices2: int,
        *indices: int,
        lb: float = 0.0,
        ub: float = float('inf'),
        obj: float = 0.0,
        vtype: str = GRB.CONTINUOUS,
        name: str = ...
    ) -> tupledict[Tuple[int, ...], Var]: ...
    # single scalar list arg + scalar/list kwargs
    @overload
    def addVars(
        self,
        __indices: Iterable[_Scalar],
        *,
        lb: Union[float, Iterable[float]] = 0.0,
        ub: Union[float, Iterable[float]] = float('inf'),
        obj: Union[float, Iterable[float]] = 0.0,
        vtype: Union[str, Iterable[str]] = GRB.CONTINUOUS,
        name: Union[str, Iterable[str]] = ...
    ) -> tupledict[Any, Var]: ...
    # single scalar list arg + scalar/dict kwargs
    @overload
    def addVars(
        self,
        __indices: Iterable[_Scalar],
        *,
        lb: Union[float, Mapping[Any, float]] = 0.0,
        ub: Union[float, Mapping[Any, float]] = float('inf'),
        obj: Union[float, Mapping[Any, float]] = 0.0,
        vtype: Union[str, Mapping[Any, str]] = GRB.CONTINUOUS,
        name: Union[str, Mapping[Any, str]] = ...
    ) -> tupledict[Any, Var]: ...
    # multiple scalar list args + scalar/dict kwargs
    @overload
    def addVars(
        self,
        __indices1: Iterable[_Scalar],
        __indices2: Iterable[_Scalar],
        *indices: Iterable[_Scalar],
        lb: Union[float, Mapping[Any, float]] = 0.0,
        ub: Union[float, Mapping[Any, float]] = float('inf'),
        obj: Union[float, Mapping[Any, float]] = 0.0,
        vtype: Union[str, Mapping[Any, str]] = GRB.CONTINUOUS,
        name: Union[str, Mapping[Any, str]] = ...
    ) -> tupledict[Tuple[Any, ...], Var]: ...
    # single list of tuples arg + scalar/list kwargs
    @overload
    def addVars(
        self,
        __indices: Iterable[Tuple[_Scalar, ...]],
        *,
        lb: Union[float, Iterable[float]] = 0.0,
        ub: Union[float, Iterable[float]] = float('inf'),
        obj: Union[float, Iterable[float]] = 0.0,
        vtype: Union[str, Iterable[str]] = GRB.CONTINUOUS,
        name: Union[str, Iterable[str]] = ...
    ) -> tupledict[Tuple[Any, ...], Var]: ...
    # multiple lists of tuples args + scalar/dict kwargs
    @overload
    def addVars(
        self,
        *indices: Union[Iterable[_Scalar], Iterable[Tuple[_Scalar, ...]]],
        lb: Union[float, Mapping[Any, float]] = 0.0,
        ub: Union[float, Mapping[Any, float]] = float('inf'),
        obj: Union[float, Mapping[Any, float]] = 0.0,
        vtype: Union[str, Mapping[Any, str]] = GRB.CONTINUOUS,
        name: Union[str, Mapping[Any, str]] = ...
    ) -> tupledict[Tuple[Any, ...], Var]: ...
    @overload
    def cbCut(self, __tc: Union[TempLConstr, TempMConstr]) -> None: ...
    @overload
    def cbCut(
        self,
        lhs: Union[_LinExprLike, _MLinExprLike],
        sense: str,
        rhs: Union[_LinExprLike, _MLinExprLike],
    ) -> None: ...
    def cbGet(self, what: int) -> Any: ...
    @overload
    def cbGetNodeRel(self, vars: Var) -> float: ...
    @overload
    def cbGetNodeRel(self, vars: Sequence[Var]) -> List[float]: ...
    @overload
    def cbGetNodeRel(self, vars: Mapping[_T, Var]) -> tupledict[_T, float]: ...
    @overload
    def cbGetNodeRel(self, vars: MVar) -> np.ndarray: ...
    @overload
    def cbGetNodeRel(self, vars: Sequence[MVar]) -> List[np.ndarray]: ...
    @overload
    def cbGetNodeRel(
        self,
        vars: Mapping[_T, MVar]
    ) -> tupledict[_T, np.ndarray]: ...
    @overload
    def cbGetSolution(self, vars: Var) -> float: ...
    @overload
    def cbGetSolution(self, vars: Sequence[Var]) -> List[float]: ...
    @overload
    def cbGetSolution(
        self,
        vars: Mapping[_T, Var]
    ) -> tupledict[_T, float]: ...
    @overload
    def cbGetSolution(self, vars: MVar) -> np.ndarray: ...
    @overload
    def cbGetSolution(self, vars: Sequence[MVar]) -> List[np.ndarray]: ...
    @overload
    def cbGetSolution(
        self,
        vars: Mapping[_T, MVar]
    ) -> tupledict[_T, np.ndarray]: ...
    @overload
    def cbLazy(self, __tc: Union[TempLConstr, TempMConstr]) -> None: ...
    @overload
    def cbLazy(
        self,
        lhs: Union[_LinExprLike, _MLinExprLike],
        sense: str,
        rhs: Union[_LinExprLike, _MLinExprLike],
    ) -> None: ...
    def cbProceed(self) -> None: ...
    @overload
    def cbSetSolution(self, vars: Var, solution: float) -> None: ...
    @overload
    def cbSetSolution(self, vars: MVar, solution: np.ndarray) -> None: ...
    @overload
    def cbSetSolution(
        self,
        vars: Sequence[Var],
        solution: Sequence[float]
    ) -> None: ...
    def cbStopOneMultiObj(self, objnum: int) -> None: ...
    def cbUseSolution(self) -> float: ...
    def chgCoeff(self, constr: Constr, var: Var, newvalue: float) -> None: ...
    def close(self) -> None: ...
    def computeIIS(
        self,
        callback: Optional[Callable[[Model, int], None]] = None
    ) -> None: ...
    def copy(self) -> Model: ...
    def discardConcurrentEnvs(self) -> None: ...
    def discardMultiobjEnvs(self) -> None: ...
    def dispose(self) -> None: ...
    def feasRelax(
        self,
        relaxobjtype: int,
        minrelax: bool,
        vars: Optional[Sequence[Var]],
        lbpen: Optional[Sequence[float]],
        ubpen: Optional[Sequence[float]],
        constrs: Optional[Sequence[Constr]],
        rhspen: Optional[Sequence[float]]
    ) -> float: ...
    def feasRelaxS(
        self,
        relaxobjtype: int,
        minrelax: bool,
        vrelax: bool,
        crelax: bool
    ) -> float: ...
    def fixed(self) -> Model: ...
    # no type hinting for scipy.sparse
    def getA(self) -> Any: ...
    @overload
    def getAttr(self, attrname: str) -> Any: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Sequence[Var]
    ) -> List[Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Sequence[Constr]
    ) -> List[Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Sequence[SOS]
    ) -> List[Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Sequence[QConstr]
    ) -> List[Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Sequence[GenConstr]
    ) -> List[Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Mapping[_T, Var]
    ) -> Dict[_T, Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Mapping[_T, Constr]
    ) -> Dict[_T, Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Mapping[_T, SOS]
    ) -> Dict[_T, Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Mapping[_T, QConstr]
    ) -> Dict[_T, Any]: ...
    @overload
    def getAttr(
        self,
        attrname: str,
        objs: Mapping[_T, GenConstr]
    ) -> Dict[_T, Any]: ...
    def getCoeff(self, constr: Constr, var: Var) -> float: ...
    def getCol(self, var: Var) -> Column: ...
    def getConcurrentEnv(self, num: int) -> Env: ...
    def getConstrByName(self, name: str) -> Optional[Constr]: ...
    def getConstrs(self) -> List[Constr]: ...
    def getGenConstrAbs(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrAnd(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[Var]]: ...
    def getGenConstrCos(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrExp(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrExpA(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var, float]: ...
    def getGenConstrIndicator(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, bool, LinExpr, str, float]: ...
    def getGenConstrLog(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrLogA(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var, float]: ...
    def getGenConstrLogistic(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var]: ...
    def getGenConstrMax(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[Var], float]: ...
    def getGenConstrMin(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[Var], float]: ...
    def getGenConstrNL(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, NLExpr]: ...
    def getGenConstrNLAdv(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[int], List[float], List[int]]: ...
    def getGenConstrNorm(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[Var], float]: ...
    def getGenConstrOr(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, List[Var]]: ...
    def getGenConstrPWL(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var, List[float], List[float]]: ...
    def getGenConstrPoly(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var, List[float]]: ...
    def getGenConstrPow(
        self,
        genconstr: GenConstr
    ) -> Tuple[Var, Var, float]: ...
    def getGenConstrSin(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrTan(self, genconstr: GenConstr) -> Tuple[Var, Var]: ...
    def getGenConstrs(self) -> List[GenConstr]: ...
    def getJSONSolution(self) -> str: ...
    def getMultiobjEnv(self, num: int) -> Env: ...
    def getObjective(
        self,
        index: Optional[int] = None
    ) -> Union[LinExpr, QuadExpr]: ...
    def getPWLObj(self, var: Var) -> List[Tuple[float, float]]: ...
    def getParamInfo(
        self,
        paramname: str
    ) -> Tuple[str, Type[Any], Any, Any, Any, Any]: ...
    def getQCRow(self, qc: QConstr) -> QuadExpr: ...
    def getQConstrs(self) -> List[QConstr]: ...
    def getRow(self, constr: Constr) -> LinExpr: ...
    def getSOS(self, sos: SOS) -> Tuple[int, List[Var], List[float]]: ...
    def getSOSs(self) -> List[SOS]: ...
    def getTuneResult(self, i: int) -> None: ...
    def getVarByName(self, name: str) -> Optional[Var]: ...
    def getVars(self) -> List[Var]: ...
    def message(self, msg: str) -> None: ...
    def optimize(
        self,
        callback: Optional[Callable[[Model, int], None]] = None
    ) -> None: ...
    def optimizeBatch(self) -> str: ...
    def presolve(self) -> Model: ...
    @overload
    def printAttr(self, attrname: str, filter: str = '*') -> None: ...
    @overload
    def printAttr(
        self,
        attrname: Sequence[str],
        filter: str = '*'
    ) -> None: ...
    def printQuality(self) -> None: ...
    def printStats(self) -> None: ...
    def read(self, filename: str) -> None: ...
    def relax(self) -> Model: ...
    @overload
    def remove(self, items: Var) -> None: ...
    @overload
    def remove(self, items: MVar) -> None: ...
    @overload
    def remove(self, items: Constr) -> None: ...
    @overload
    def remove(self, items: MConstr) -> None: ...
    @overload
    def remove(self, items: SOS) -> None: ...
    @overload
    def remove(self, items: QConstr) -> None: ...
    @overload
    def remove(self, items: GenConstr) -> None: ...
    @overload
    def remove(self, items: Sequence[_ModelComponent]) -> None: ...
    @overload
    def remove(self, items: Mapping[Any, _ModelComponent]) -> None: ...
    def reset(self, clearall: int = 0) -> None: ...
    def resetParams(self) -> None: ...
    @overload
    def setAttr(self, attrname: str, arg1: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, arg1: str) -> None: ...
    @overload
    def setAttr(
        self,
        attrname: str,
        arg1: Sequence[_ModelComponent],
        arg2: Sequence[_Scalar]
    ) -> None: ...
    @overload
    def setAttr(
        self,
        attrname: str,
        arg1: Sequence[_ModelComponent],
        arg2: float
    ) -> None: ...
    @overload
    def setAttr(
        self,
        attrname: str,
        arg1: Mapping[Any, _ModelComponent],
        arg2: Mapping[Any, _Scalar]
    ) -> None: ...
    @overload
    def setAttr(
        self,
        attrname: str,
        arg1: Mapping[Any, _ModelComponent],
        arg2: float
    ) -> None: ...
    @overload
    def setAttr(
        self,
        attrname: str,
        arg1: Mapping[Any, _ModelComponent],
        arg2: str
    ) -> None: ...
    @overload
    def setMObjective(
        self,
        Q: np.ndarray,
        c: Optional[np.ndarray],
        constant: float,
        xQ_L: Optional[MVar] = None,
        xQ_R: Optional[MVar] = None,
        xc: Optional[MVar] = None,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setMObjective(
        self,
        Q: np.ndarray,
        c: Optional[np.ndarray],
        constant: float,
        xQ_L: Optional[Sequence[Var]] = None,
        xQ_R: Optional[Sequence[Var]] = None,
        xc: Optional[Sequence[Var]] = None,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: float,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: Var,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: LinExpr,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: QuadExpr,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: MVar,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: MLinExpr,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjective(
        self,
        expr: MQuadExpr,
        sense: Optional[int] = None
    ) -> None: ...
    @overload
    def setObjectiveN(
        self,
        expr: float,
        index: int,
        priority: int = 0,
        weight: float = 1.0,
        abstol: float = 1e-6,
        reltol: float = 0.0,
        name: str = ...
    ) -> None: ...
    @overload
    def setObjectiveN(
        self,
        expr: Var,
        index: int,
        priority: int = 0,
        weight: float = 1.0,
        abstol: float = 1e-6,
        reltol: float = 0.0,
        name: str = ...
    ) -> None: ...
    @overload
    def setObjectiveN(
        self,
        expr: LinExpr,
        index: int,
        priority: int = 0,
        weight: float = 1.0,
        abstol: float = 1e-6,
        reltol: float = 0.0,
        name: str = ...
    ) -> None: ...
    @overload
    def setObjectiveN(
        self,
        expr: MVar,
        index: int,
        priority: int = 0,
        weight: float = 1.0,
        abstol: float = 1e-6,
        reltol: float = 0.0,
        name: str = ...
    ) -> None: ...
    @overload
    def setObjectiveN(
        self,
        expr: MLinExpr,
        index: int,
        priority: int = 0,
        weight: float = 1.0,
        abstol: float = 1e-6,
        reltol: float = 0.0,
        name: str = ...
    ) -> None: ...
    def setPWLObj(
        self,
        var: Var,
        x: Sequence[float],
        y: Sequence[float]
    ) -> None: ...
    @overload
    def setParam(self, paramname: str, newvalue: float) -> None: ...
    @overload
    def setParam(self, paramname: str, newvalue: str) -> None: ...
    def singleScenarioModel(self) -> Model: ...
    def terminate(self) -> None: ...
    def tune(self) -> None: ...
    def update(self) -> None: ...
    def write(self, filename: str) -> None: ...
    def __enter__(self) -> Model: ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType]
    ) -> Optional[bool]: ...
    def __getattr__(self, name: str) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...

class ParamClass:
    AggFill: int = ...
    Aggregate: int = ...
    BQPCuts: int = ...
    BarConvTol: float = ...
    BarCorrectors: int = ...
    BarHomogeneous: int = ...
    BarIterLimit: int = ...
    BarOrder: int = ...
    BarQCPConvTol: float = ...
    BestBdStop: float = ...
    BestObjStop: float = ...
    BranchDir: int = ...
    CSAPIAccessID: str = ...
    CSAPISecret: str = ...
    CSAppName: str = ...
    CSAuthToken: str = ...
    CSBatchMode: int = ...
    CSClientLog: int = ...
    CSGroup: str = ...
    CSIdleTimeout: int = ...
    CSManager: str = ...
    CSPriority: int = ...
    CSQueueTimeout: float = ...
    CSRouter: str = ...
    CSTLSInsecure: int = ...
    CliqueCuts: int = ...
    CloudAccessID: str = ...
    CloudHost: str = ...
    CloudPool: str = ...
    CloudSecretKey: str = ...
    ComputeServer: str = ...
    ConcurrentJobs: int = ...
    ConcurrentMIP: int = ...
    CoverCuts: int = ...
    Crossover: int = ...
    CrossoverBasis: int = ...
    CutAggPasses: int = ...
    CutPasses: int = ...
    Cutoff: float = ...
    Cuts: int = ...
    DegenMoves: int = ...
    Disconnected: int = ...
    DisplayInterval: int = ...
    DistributedMIPJobs: int = ...
    DualReductions: int = ...
    FeasRelaxBigM: float = ...
    FeasibilityTol: float = ...
    FlowCoverCuts: int = ...
    FlowPathCuts: int = ...
    FuncMaxVal: float = ...
    FuncNonlinear: int = ...
    FuncPieceError: float = ...
    FuncPieceLength: float = ...
    FuncPieceRatio: float = ...
    FuncPieces: int = ...
    GUBCoverCuts: int = ...
    GomoryPasses: int = ...
    Heuristics: float = ...
    IISMethod: int = ...
    IgnoreNames: int = ...
    ImpliedCuts: int = ...
    ImproveStartGap: float = ...
    ImproveStartNodes: float = ...
    ImproveStartTime: float = ...
    InfProofCuts: int = ...
    InfUnbdInfo: int = ...
    IntFeasTol: float = ...
    IntegralityFocus: int = ...
    IterationLimit: float = ...
    JSONSolDetail: int = ...
    JobID: str = ...
    LPWarmStart: int = ...
    LazyConstraints: int = ...
    LicenseID: int = ...
    LiftProjectCuts: int = ...
    LogFile: str = ...
    LogToConsole: int = ...
    MIPFocus: int = ...
    MIPGap: float = ...
    MIPGapAbs: float = ...
    MIPSepCuts: int = ...
    MIQCPMethod: int = ...
    MIRCuts: int = ...
    MarkowitzTol: float = ...
    MemLimit: float = ...
    Method: int = ...
    MinRelNodes: int = ...
    ModKCuts: int = ...
    MultiObjMethod: int = ...
    MultiObjPre: int = ...
    NLPHeur: int = ...
    NetworkAlg: int = ...
    NetworkCuts: int = ...
    NoRelHeurTime: float = ...
    NoRelHeurWork: float = ...
    NodeLimit: float = ...
    NodeMethod: int = ...
    NodefileDir: str = ...
    NodefileStart: float = ...
    NonConvex: int = ...
    NormAdjust: int = ...
    NumericFocus: int = ...
    OBBT: int = ...
    ObjNumber: int = ...
    ObjScale: float = ...
    OptimalityTol: float = ...
    OutputFlag: int = ...
    PSDCuts: int = ...
    PSDTol: float = ...
    PartitionPlace: int = ...
    PerturbValue: float = ...
    PoolGap: float = ...
    PoolGapAbs: float = ...
    PoolSearchMode: int = ...
    PoolSolutions: int = ...
    PreCrush: int = ...
    PreDepRow: int = ...
    PreDual: int = ...
    PreMIQCPForm: int = ...
    PrePasses: int = ...
    PreQLinearize: int = ...
    PreSOS1BigM: float = ...
    PreSOS1Encoding: int = ...
    PreSOS2BigM: float = ...
    PreSOS2Encoding: int = ...
    PreSparsify: int = ...
    Presolve: int = ...
    ProjImpliedCuts: int = ...
    PumpPasses: int = ...
    QCPDual: int = ...
    Quad: int = ...
    RINS: int = ...
    RLTCuts: int = ...
    Record: int = ...
    RelaxLiftCuts: int = ...
    ResultFile: str = ...
    ScaleFlag: int = ...
    ScenarioNumber: int = ...
    Seed: int = ...
    ServerPassword: str = ...
    ServerTimeout: int = ...
    SiftMethod: int = ...
    Sifting: int = ...
    SimplexPricing: int = ...
    SoftMemLimit: float = ...
    SolFiles: str = ...
    SolutionLimit: int = ...
    SolutionNumber: int = ...
    StartNodeLimit: int = ...
    StartNumber: int = ...
    StrongCGCuts: int = ...
    SubMIPCuts: int = ...
    SubMIPNodes: int = ...
    Symmetry: int = ...
    TSPort: int = ...
    ThreadLimit: int = ...
    Threads: int = ...
    TimeLimit: float = ...
    TokenServer: str = ...
    TuneCleanup: float = ...
    TuneCriterion: int = ...
    TuneDynamicJobs: int = ...
    TuneJobs: int = ...
    TuneMetric: int = ...
    TuneOutput: int = ...
    TuneResults: int = ...
    TuneTargetMIPGap: float = ...
    TuneTargetTime: float = ...
    TuneTimeLimit: float = ...
    TuneTrials: int = ...
    UpdateMode: int = ...
    UserName: str = ...
    VarBranch: int = ...
    WLSAccessID: str = ...
    WLSSecret: str = ...
    WLSToken: str = ...
    WLSTokenDuration: int = ...
    WLSTokenRefresh: float = ...
    WorkLimit: float = ...
    WorkerPassword: str = ...
    WorkerPool: str = ...
    ZeroHalfCuts: int = ...
    ZeroObjNodes: int = ...

class ParamConstClass:
    AggFill: str = ...
    Aggregate: str = ...
    BQPCuts: str = ...
    BarConvTol: str = ...
    BarCorrectors: str = ...
    BarHomogeneous: str = ...
    BarIterLimit: str = ...
    BarOrder: str = ...
    BarQCPConvTol: str = ...
    BestBdStop: str = ...
    BestObjStop: str = ...
    BranchDir: str = ...
    CSAPIAccessID: str = ...
    CSAPISecret: str = ...
    CSAppName: str = ...
    CSAuthToken: str = ...
    CSBatchMode: str = ...
    CSClientLog: str = ...
    CSGroup: str = ...
    CSIdleTimeout: str = ...
    CSManager: str = ...
    CSPriority: str = ...
    CSQueueTimeout: str = ...
    CSRouter: str = ...
    CSTLSInsecure: str = ...
    CliqueCuts: str = ...
    CloudAccessID: str = ...
    CloudHost: str = ...
    CloudPool: str = ...
    CloudSecretKey: str = ...
    ComputeServer: str = ...
    ConcurrentJobs: str = ...
    ConcurrentMIP: str = ...
    CoverCuts: str = ...
    Crossover: str = ...
    CrossoverBasis: str = ...
    CutAggPasses: str = ...
    CutPasses: str = ...
    Cutoff: str = ...
    Cuts: str = ...
    DegenMoves: str = ...
    Disconnected: str = ...
    DisplayInterval: str = ...
    DistributedMIPJobs: str = ...
    DualReductions: str = ...
    FeasRelaxBigM: str = ...
    FeasibilityTol: str = ...
    FlowCoverCuts: str = ...
    FlowPathCuts: str = ...
    FuncMaxVal: str = ...
    FuncNonlinear: int = ...
    FuncPieceError: str = ...
    FuncPieceLength: str = ...
    FuncPieceRatio: str = ...
    FuncPieces: str = ...
    GUBCoverCuts: str = ...
    GomoryPasses: str = ...
    Heuristics: str = ...
    IISMethod: str = ...
    IgnoreNames: str = ...
    ImpliedCuts: str = ...
    ImproveStartGap: str = ...
    ImproveStartNodes: str = ...
    ImproveStartTime: str = ...
    InfProofCuts: str = ...
    InfUnbdInfo: str = ...
    IntFeasTol: str = ...
    IntegralityFocus: str = ...
    IterationLimit: str = ...
    JSONSolDetail: str = ...
    JobID: str = ...
    LPWarmStart: str = ...
    LazyConstraints: str = ...
    LicenseID: str = ...
    LiftProjectCuts: str = ...
    LogFile: str = ...
    LogToConsole: str = ...
    MIPFocus: str = ...
    MIPGap: str = ...
    MIPGapAbs: str = ...
    MIPSepCuts: str = ...
    MIQCPMethod: str = ...
    MIRCuts: str = ...
    MarkowitzTol: str = ...
    MemLimit: str = ...
    Method: str = ...
    MinRelNodes: str = ...
    ModKCuts: str = ...
    MultiObjMethod: str = ...
    MultiObjPre: str = ...
    NLPHeur: str = ...
    NetworkAlg: str = ...
    NetworkCuts: str = ...
    NoRelHeurTime: str = ...
    NoRelHeurWork: str = ...
    NodeLimit: str = ...
    NodeMethod: str = ...
    NodefileDir: str = ...
    NodefileStart: str = ...
    NonConvex: str = ...
    NormAdjust: str = ...
    NumericFocus: str = ...
    OBBT: str = ...
    ObjNumber: str = ...
    ObjScale: str = ...
    OptimalityTol: str = ...
    OutputFlag: str = ...
    PSDCuts: str = ...
    PSDTol: str = ...
    PartitionPlace: str = ...
    PerturbValue: str = ...
    PoolGap: str = ...
    PoolGapAbs: str = ...
    PoolSearchMode: str = ...
    PoolSolutions: str = ...
    PreCrush: str = ...
    PreDepRow: str = ...
    PreDual: str = ...
    PreMIQCPForm: str = ...
    PrePasses: str = ...
    PreQLinearize: str = ...
    PreSOS1BigM: str = ...
    PreSOS1Encoding: str = ...
    PreSOS2BigM: str = ...
    PreSOS2Encoding: str = ...
    PreSparsify: str = ...
    Presolve: str = ...
    ProjImpliedCuts: str = ...
    PumpPasses: str = ...
    QCPDual: str = ...
    Quad: str = ...
    RINS: str = ...
    RLTCuts: str = ...
    Record: str = ...
    RelaxLiftCuts: str = ...
    ResultFile: str = ...
    ScaleFlag: str = ...
    ScenarioNumber: str = ...
    Seed: str = ...
    ServerPassword: str = ...
    ServerTimeout: str = ...
    SiftMethod: str = ...
    Sifting: str = ...
    SimplexPricing: str = ...
    SoftMemLimit: str = ...
    SolFiles: str = ...
    SolutionLimit: str = ...
    SolutionNumber: str = ...
    StartNodeLimit: str = ...
    StartNumber: str = ...
    StrongCGCuts: str = ...
    SubMIPCuts: str = ...
    SubMIPNodes: str = ...
    Symmetry: str = ...
    TSPort: str = ...
    ThreadLimit: str = ...
    Threads: str = ...
    TimeLimit: str = ...
    TokenServer: str = ...
    TuneCleanup: str = ...
    TuneCriterion: str = ...
    TuneDynamicJobs: str = ...
    TuneJobs: str = ...
    TuneMetric: str = ...
    TuneOutput: str = ...
    TuneResults: str = ...
    TuneTargetMIPGap: str = ...
    TuneTargetTime: str = ...
    TuneTimeLimit: str = ...
    TuneTrials: str = ...
    UpdateMode: str = ...
    UserName: str = ...
    VarBranch: str = ...
    WLSAccessID: str = ...
    WLSSecret: str = ...
    WLSToken: str = ...
    WLSTokenDuration: str = ...
    WLSTokenRefresh: str = ...
    WorkLimit: str = ...
    WorkerPassword: str = ...
    WorkerPool: str = ...
    ZeroHalfCuts: str = ...
    ZeroObjNodes: str = ...

class QConstr:
    IISQConstr: int = ...
    IISQConstrForce: int = ...
    QCName: str = ...
    QCPi: float = ...
    QCRHS: float = ...
    QCSense: str = ...
    QCSlack: float = ...
    QCTag: str = ...
    def getAttr(self, attrname: str) -> Any: ...
    @overload
    def setAttr(self, attrname: str, newval: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, newval: str) -> None: ...

class QuadExpr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, expr: float) -> None: ...
    @overload
    def __init__(self, expr: Var) -> None: ...
    @overload
    def __init__(self, expr: LinExpr) -> None: ...
    @overload
    def __init__(self, expr: QuadExpr) -> None: ...
    @overload
    def add(self, expr: float, mult: float = 1.0) -> None: ...
    @overload
    def add(self, expr: Var, mult: float = 1.0) -> None: ...
    @overload
    def add(self, expr: LinExpr, mult: float = 1.0) -> None: ...
    @overload
    def add(self, expr: QuadExpr, mult: float = 1.0) -> None: ...
    def addConstant(self, __constant: float) -> None: ...
    @overload
    def addTerms(
        self,
        coeffs: float,
        vars: Var,
        vars2: Optional[Var] = None
    ) -> None: ...
    @overload
    def addTerms(
        self,
        coeffs: Sequence[float],
        vars: Sequence[Var],
        vars2: Optional[Sequence[Var]] = None
    ) -> None: ...
    def clear(self) -> None: ...
    def copy(self) -> QuadExpr: ...
    def getCoeff(self, __i: int) -> float: ...
    def getLinExpr(self) -> LinExpr: ...
    def getValue(self) -> float: ...
    def getVar1(self, __i: int) -> Var: ...
    def getVar2(self, __i: int) -> Var: ...
    @overload
    def remove(self, __which: int) -> None: ...
    @overload
    def remove(self, __which: Var) -> None: ...
    def size(self) -> int: ...
    @overload
    def __add__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __add__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __add__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __add__(self, __expr: QuadExpr) -> QuadExpr: ...
    # used as constraint sense, not comparison
    @overload  # type: ignore[override]
    def __eq__(self, __rhs: float) -> TempQConstr: ...
    @overload
    def __eq__(self, __rhs: Var) -> TempQConstr: ...
    @overload
    def __eq__(self, __rhs: LinExpr) -> TempQConstr: ...
    @overload
    def __eq__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __ge__(self, __rhs: float) -> TempQConstr: ...
    @overload
    def __ge__(self, __rhs: Var) -> TempQConstr: ...
    @overload
    def __ge__(self, __rhs: LinExpr) -> TempQConstr: ...
    @overload
    def __ge__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __iadd__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __iadd__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __iadd__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __iadd__(self, __expr: QuadExpr) -> QuadExpr: ...
    @overload
    def __imul__(self, __constant: float) -> QuadExpr: ...
    @overload
    def __imul__(self, __constant: Union[Var, LinExpr, QuadExpr]) -> NLExpr: ...
    @overload
    def __isub__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __isub__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __isub__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __isub__(self, __expr: QuadExpr) -> QuadExpr: ...
    @overload
    def __le__(self, __rhs: float) -> TempQConstr: ...
    @overload
    def __le__(self, __rhs: Var) -> TempQConstr: ...
    @overload
    def __le__(self, __rhs: LinExpr) -> TempQConstr: ...
    @overload
    def __le__(self, __rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __mul__(self, expr: float) -> QuadExpr: ...
    @overload
    def __mul__(self, expr: Union[Var, LinExpr, QuadExpr]) -> NLExpr: ...
    def __neg__(self) -> QuadExpr: ...
    @overload
    def __pow__(self, exponent: Literal[0]) -> float: ...
    @overload
    def __pow__(self, exponent: Literal[1]) -> QuadExpr: ...
    @overload
    def __pow__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rpow__(self, base: float) -> NLExpr: ...
    @overload
    def __radd__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __radd__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __radd__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __radd__(self, __expr: QuadExpr) -> QuadExpr: ...
    def __rmul__(self, __constant: float) -> QuadExpr: ...
    @overload
    def __rsub__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __rsub__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __rsub__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __rsub__(self, __expr: QuadExpr) -> QuadExpr: ...
    @overload
    def __sub__(self, __expr: float) -> QuadExpr: ...
    @overload
    def __sub__(self, __expr: Var) -> QuadExpr: ...
    @overload
    def __sub__(self, __expr: LinExpr) -> QuadExpr: ...
    @overload
    def __sub__(self, __expr: QuadExpr) -> QuadExpr: ...
    @overload
    def __truediv__(self, expr: float) -> QuadExpr: ...
    @overload
    def __truediv__(self, expr: Union[Var, LinExpr, QuadExpr]) -> NLExpr: ...
    def __rtruediv__(self, expr: float) -> NLExpr: ...

class NLExpr(GenExpr):
    def __add__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __radd__(self, exponent: _QuadExprLike) -> NLExpr: ...
    def __sub__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rsub__(self, exponent: _QuadExprLike) -> NLExpr: ...
    def __neg__(self) -> NLExpr: ...
    def __mul__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rmul__(self, exponent: _QuadExprLike) -> NLExpr: ...
    def __pow__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rpow__(self, base: float) -> NLExpr: ...
    def __truediv__(self, expr: _NLExprLike) -> NLExpr: ...
    def __rtruediv__(self, expr: _NLExprLike) -> NLExpr: ...

class SOS:
    IISSOS: int = ...
    IISSOSForce: int = ...
    def getAttr(self, attrname: str) -> int: ...
    def setAttr(self, attrname: str, newval: float) -> None: ...
    @property
    def index(self) -> int: ...

class StatusConstClass:
    CUTOFF: int = ...
    INFEASIBLE: int = ...
    INF_OR_UNBD: int = ...
    INPROGRESS: int = ...
    INTERRUPTED: int = ...
    ITERATION_LIMIT: int = ...
    LOADED: int = ...
    MEM_LIMIT: int = ...
    NODE_LIMIT: int = ...
    NUMERIC: int = ...
    OPTIMAL: int = ...
    SOLUTION_LIMIT: int = ...
    SUBOPTIMAL: int = ...
    TIME_LIMIT: int = ...
    UNBOUNDED: int = ...
    USER_OBJ_LIMIT: int = ...
    WORK_LIMIT: int = ...

class TempConstr: ...

# the following six classes are helper classes specifically for type hinting
# they are not part of gurobipy

class TempGenConstr(TempConstr): ...

class TempMGenConstr(TempConstr): ...

class TempLConstr(TempConstr):
    def __rshift__(self, other: TempLConstr) -> TempGenConstr: ...

class TempMConstr(TempConstr): ...

class TempMQConstr(TempConstr): ...

class TempQConstr(TempConstr): ...

class Var:
    BarX: float = ...
    BranchPriority: int = ...
    IISLB: int = ...
    IISLBForce: int = ...
    IISUB: int = ...
    IISUBForce: int = ...
    LB: float = ...
    Obj: float = ...
    ObjN: float = ...
    PStart: float = ...
    PWLObjCvx: int = ...
    Partition: int = ...
    PoolIgnore: int = ...
    RC: float = ...
    SALBLow: float = ...
    SALBUp: float = ...
    SAObjLow: float = ...
    SAObjUp: float = ...
    SAUBLow: float = ...
    SAUBUp: float = ...
    ScenNLB: float = ...
    ScenNObj: float = ...
    ScenNUB: float = ...
    ScenNX: float = ...
    Start: float = ...
    UB: float = ...
    UnbdRay: float = ...
    VBasis: int = ...
    VTag: str = ...
    VType: str = ...
    VarHintPri: int = ...
    VarHintVal: float = ...
    VarName: str = ...
    X: float = ...
    Xn: float = ...
    def getAttr(self, attrname: str) -> Any: ...
    def sameAs(self, other: Var) -> bool: ...
    @overload
    def setAttr(self, attrname: str, newval: float) -> None: ...
    @overload
    def setAttr(self, attrname: str, newval: str) -> None: ...
    @overload
    def __add__(self, expr: float) -> LinExpr: ...
    @overload
    def __add__(self, expr: Var) -> LinExpr: ...
    @overload
    def __add__(self, expr: LinExpr) -> LinExpr: ...
    def __div__(self, constant: float) -> LinExpr: ...
    # used as constraint sense, not comparison
    @overload  # type: ignore[override]
    def __eq__(self, rhs: float) -> TempLConstr: ...
    @overload
    def __eq__(self, rhs: Var) -> TempLConstr: ...
    @overload
    def __eq__(self, rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __eq__(self, rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __eq__(self, rhs: GenExpr) -> TempGenConstr: ...
    @overload
    def __eq__(self, rhs: Sequence[float]) -> TempLConstr: ...
    @overload
    def __ge__(self, rhs: float) -> TempLConstr: ...
    @overload
    def __ge__(self, rhs: Var) -> TempLConstr: ...
    @overload
    def __ge__(self, rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __ge__(self, rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __iadd__(self, expr: float) -> LinExpr: ...
    @overload
    def __iadd__(self, expr: Var) -> LinExpr: ...
    @overload
    def __iadd__(self, expr: LinExpr) -> LinExpr: ...
    @overload
    def __imul__(self, expr: float) -> LinExpr: ...
    @overload
    def __imul__(self, expr: Var) -> QuadExpr: ...
    @overload
    def __imul__(self, expr: LinExpr) -> QuadExpr: ...
    @overload
    def __imul__(self, expr: QuadExpr) -> NLExpr: ...
    @overload
    def __isub__(self, expr: float) -> LinExpr: ...
    @overload
    def __isub__(self, expr: Var) -> LinExpr: ...
    @overload
    def __isub__(self, expr: LinExpr) -> LinExpr: ...
    @overload
    def __le__(self, rhs: float) -> TempLConstr: ...
    @overload
    def __le__(self, rhs: Var) -> TempLConstr: ...
    @overload
    def __le__(self, rhs: LinExpr) -> TempLConstr: ...
    @overload
    def __le__(self, rhs: QuadExpr) -> TempQConstr: ...
    @overload
    def __mul__(self, expr: float) -> LinExpr: ...
    @overload
    def __mul__(self, expr: Var) -> QuadExpr: ...
    @overload
    def __mul__(self, expr: LinExpr) -> QuadExpr: ...
    @overload
    def __mul__(self, expr: QuadExpr) -> NLExpr: ...
    def __neg__(self) -> LinExpr: ...
    @overload
    def __pow__(self, exponent: Literal[0]) -> float: ...
    @overload
    def __pow__(self, exponent: Literal[1]) -> LinExpr: ...
    @overload
    def __pow__(self, exponent: Literal[2]) -> QuadExpr: ...
    @overload
    def __pow__(self, exponent: _NLExprLike) -> NLExpr: ...
    def __rpow__(self, base: float) -> NLExpr: ...
    @overload
    def __radd__(self, expr: float) -> LinExpr: ...
    @overload
    def __radd__(self, expr: Var) -> LinExpr: ...
    @overload
    def __radd__(self, expr: LinExpr) -> LinExpr: ...
    @overload
    def __rmul__(self, expr: float) -> LinExpr: ...
    @overload
    def __rmul__(self, expr: Var) -> QuadExpr: ...
    @overload
    def __rmul__(self, expr: LinExpr) -> QuadExpr: ...
    @overload
    def __rsub__(self, expr: float) -> LinExpr: ...
    @overload
    def __rsub__(self, expr: Var) -> LinExpr: ...
    @overload
    def __rsub__(self, expr: LinExpr) -> LinExpr: ...
    @overload
    def __sub__(self, expr: float) -> LinExpr: ...
    @overload
    def __sub__(self, expr: Var) -> LinExpr: ...
    @overload
    def __sub__(self, expr: LinExpr) -> LinExpr: ...
    @overload
    def __truediv__(self, expr: float) -> LinExpr: ...
    @overload
    def __truediv__(self, expr: Union[Var, LinExpr, QuadExpr]) -> NLExpr: ...
    def __rtruediv__(self, expr: float) -> NLExpr: ...
    @property
    def index(self) -> int: ...

class gurobi:
    @classmethod
    def platform(cls) -> str: ...
    @classmethod
    def version(cls) -> Tuple[int, int, int]: ...

class tupledict(Dict[_T, _U]):
    def clean(self) -> None: ...
    # expects KeysView
    def keys(self) -> tuplelist[_T]: ...  # type: ignore[override]
    def prod(
        self,
        __d: Mapping[Any, float],
        *args: _Scalar
    ) -> LinExpr: ...
    def select(self, *args: Union[_Scalar, Sequence[_Scalar]]) -> List[_U]: ...
    def sum(self, *args: Union[_Scalar, Sequence[_Scalar]]) -> LinExpr: ...
    # expects ValuesView
    def values(self) -> List[_U]: ...  # type: ignore[override]

class tuplelist(List[_T]):
    def clean(self) -> None: ...
    def select(self, *args: Union[_Scalar, Sequence[_Scalar]]) -> List[_T]: ...
    def __add__(self, other: Iterable[_U]) -> tuplelist[Union[_T, _U]]: ...
    def __iadd__(self, other: Iterable[_U]) -> tuplelist[Union[_T, _U]]: ...
