def test_hook(func):
    """Decorator that just prints the name of a test hook to ensure that it's
    being run.
    """

    def wrapper(*args, **kwargs):
        print(func.__name__)
        return func(*args, **kwargs)

    return wrapper


@test_hook
def prereleaser_before(self):
    pass


@test_hook
def prereleaser_middle(self):
    pass


@test_hook
def prereleaser_after(self):
    pass


@test_hook
def releaser_before(self):
    pass


@test_hook
def releaser_middle(self):
    pass


@test_hook
def releaser_after_checkout(self):
    pass


@test_hook
def releaser_before_upload(self):
    pass


@test_hook
def releaser_after(self):
    pass


@test_hook
def postreleaser_before(self):
    pass


@test_hook
def postreleaser_middle(self):
    pass


@test_hook
def postreleaser_after(self):
    pass
