/*
 * Decompiled with CFR 0.152.
 */
package hd.pdf2jpg;

import hd.pdf2jpg.PDF2JPGConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.json.JSONObject;

public class App {
    public static void main(String[] args) throws InvalidPasswordException, IOException {
        JSONObject jsonString = new JSONObject();
        try {
            Options options = new Options();
            Option bulk = new Option("b", "bulk", false, "Mode of execution is this is selected directory of pdf will be processed instead of single PDF");
            bulk.setRequired(false);
            options.addOption(bulk);
            Option input = new Option("i", "input", true, "input path(pdf location), for mode(BULK) enter dirpath");
            input.setRequired(true);
            options.addOption(input);
            Option output = new Option("o", "output", true, "output directory");
            output.setRequired(true);
            options.addOption(output);
            Option pages = new Option("p", "pages", true, "Pages to convert. Comma seprated page list Eg. 1,2,3,4,8 or ALL to convert all pages");
            pages.setRequired(true);
            options.addOption(pages);
            Option dpi = new Option("d", "dpi", true, "dpi for outputpage default 300");
            dpi.setRequired(false);
            options.addOption(dpi);
            Option threads = new Option("t", "threads", true, "Default 2 [optional BULK mode only] number of threads to use");
            threads.setRequired(false);
            options.addOption(threads);
            DefaultParser parser = new DefaultParser();
            HelpFormatter formatter = new HelpFormatter();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                formatter.printHelp("utility-name", options);
                System.exit(1);
            }
            String bulk_ = cmd.getOptionValue("bulk");
            String inputPath = cmd.getOptionValue("input");
            String outputPath = cmd.getOptionValue("output");
            String pages_ = cmd.getOptionValue("pages");
            int dpi_ = 300;
            String dpi_t = cmd.getOptionValue("dpi");
            if (dpi_t != null && !dpi_t.isEmpty()) {
                dpi_ = Integer.parseInt(dpi_t);
            }
            System.out.println("DPI =>" + dpi_);
            String threads_ = cmd.getOptionValue("threads");
            File directory = new File(outputPath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (bulk_ != null) {
                System.out.println("BULK Mode using Java native implementation | Under implementation");
            } else {
                String pdfOutputPath = Paths.get(outputPath, String.valueOf(new File(inputPath).getName()) + "_dir").toString();
                System.out.println(pdfOutputPath);
                jsonString.put(inputPath, pdfOutputPath);
                directory = new File(pdfOutputPath);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                PDF2JPGConverter converter = new PDF2JPGConverter();
                if (pages_.equals("ALL")) {
                    converter.convertAll(inputPath, pdfOutputPath, dpi_);
                } else {
                    converter.convertMulti(inputPath, pdfOutputPath, dpi_, pages_);
                }
            }
        }
        catch (Exception err) {
            System.out.println("ERROR:" + err.toString());
            App.help();
        }
        System.out.println("#################################");
        System.out.println(jsonString.toString());
    }

    public static void help() {
        System.out.println("==============================================================");
        System.out.println("ERROR: Invalid Arguments, call the jar as below");
        System.out.println("java -jar jarPath -i path_to_pdf  -o output_directory  -p 2");
        System.out.println("java -jar jarPath -i path_to_pdf  -o output_directory  -p ALL");
        System.out.println("java -jar jarPath -i path_to_pdf  -o output_directory  -p 2,3,4");
        System.out.println("==============================================================");
    }
}

