/*
 * Decompiled with CFR 0.152.
 */
package hd.pdf2jpg;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Paths;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;

public class PDF2JPGConverter {
    public void convertAll(String pdfPath, String outPath, int dpi) {
        try {
            PDDocument document = PDDocument.load(new File(pdfPath));
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            int page = 0;
            while (page < document.getNumberOfPages()) {
                try {
                    String filePath = Paths.get(outPath, String.valueOf(page) + "_" + new File(pdfPath).getName() + ".jpg").toString();
                    BufferedImage bim = pdfRenderer.renderImageWithDPI(page, dpi, ImageType.RGB);
                    System.out.println("Dumping page " + page + " " + filePath);
                    ImageIOUtil.writeImage(bim, filePath, dpi);
                }
                catch (Exception e) {
                    System.out.print(e);
                }
                ++page;
            }
            document.close();
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }

    public void convertSingle(String pdfPath, String outPath, int dpi, int pageNo) {
        try {
            PDDocument document = PDDocument.load(new File(pdfPath));
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            int page = 0;
            while (page < document.getNumberOfPages()) {
                if (page == pageNo) {
                    String filePath = Paths.get(outPath, String.valueOf(page) + "_" + new File(pdfPath).getName() + ".jpg").toString();
                    try {
                        BufferedImage bim = pdfRenderer.renderImageWithDPI(page, dpi, ImageType.RGB);
                        System.out.println("Dumping page " + pageNo + " " + filePath);
                        ImageIOUtil.writeImage(bim, filePath, dpi);
                    }
                    catch (Exception e) {
                        System.out.print(e);
                    }
                }
                ++page;
            }
            document.close();
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }

    public void convertMulti(String pdfPath, String outPath, int dpi, String pageNos) {
        try {
            PDDocument document = PDDocument.load(new File(pdfPath));
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            String[] stringArray = pageNos.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String page = stringArray[n2];
                try {
                    int pageNo = Integer.parseInt(page);
                    String filePath = Paths.get(outPath, String.valueOf(page) + "_" + new File(pdfPath).getName() + ".jpg").toString();
                    BufferedImage bim = pdfRenderer.renderImageWithDPI(pageNo, dpi, ImageType.RGB);
                    System.out.println("Dumping page " + pageNo + " " + filePath);
                    ImageIOUtil.writeImage(bim, filePath, dpi);
                }
                catch (Exception e) {
                    System.out.print(e);
                }
                ++n2;
            }
            document.close();
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }
}

