/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2Globals;
import org.apache.pdfbox.jbig2.JBIG2Page;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

class JBIG2Document {
    private static final Logger log = LoggerFactory.getLogger(JBIG2Document.class);
    private int[] FILE_HEADER_ID = new int[]{151, 74, 66, 50, 13, 10, 26, 10};
    private final Map<Integer, JBIG2Page> pages = new TreeMap<Integer, JBIG2Page>();
    private short fileHeaderLength = (short)9;
    private short organisationType = 1;
    public static final int RANDOM = 0;
    public static final int SEQUENTIAL = 1;
    private boolean amountOfPagesUnknown = true;
    private int amountOfPages;
    private boolean gbUseExtTemplate;
    private final SubInputStream subInputStream;
    private JBIG2Globals globalSegments;

    protected JBIG2Document(ImageInputStream input) throws IOException {
        this(input, null);
    }

    protected JBIG2Document(ImageInputStream input, JBIG2Globals globals) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("imageInputStream must not be null");
        }
        this.subInputStream = new SubInputStream(input, 0L, Long.MAX_VALUE);
        this.globalSegments = globals;
        this.mapStream();
    }

    SegmentHeader getGlobalSegment(int segmentNr) {
        if (this.globalSegments != null) {
            return this.globalSegments.getSegment(segmentNr);
        }
        if (log.isErrorEnabled()) {
            log.error("Segment not found. Returning null.");
        }
        return null;
    }

    protected JBIG2Page getPage(int pageNumber) {
        return this.pages.get(pageNumber);
    }

    protected int getAmountOfPages() throws IOException {
        if (this.amountOfPagesUnknown || this.amountOfPages == 0) {
            if (this.pages.size() == 0) {
                this.mapStream();
            }
            return this.pages.size();
        }
        return this.amountOfPages;
    }

    private void mapStream() throws IOException {
        LinkedList<SegmentHeader> segments = new LinkedList<SegmentHeader>();
        long offset = 0L;
        int segmentType = 0;
        if (this.isFileHeaderPresent()) {
            this.parseFileHeader();
            offset += (long)this.fileHeaderLength;
        }
        if (this.globalSegments == null) {
            this.globalSegments = new JBIG2Globals();
        }
        JBIG2Page page = null;
        while (segmentType != 51 && !this.reachedEndOfStream(offset)) {
            SegmentHeader segment = new SegmentHeader(this, this.subInputStream, offset, this.organisationType);
            int associatedPage = segment.getPageAssociation();
            segmentType = segment.getSegmentType();
            if (associatedPage != 0) {
                page = this.getPage(associatedPage);
                if (page == null) {
                    page = new JBIG2Page(this, associatedPage);
                    this.pages.put(associatedPage, page);
                }
                page.add(segment);
            } else {
                this.globalSegments.addSegment(segment.getSegmentNr(), segment);
            }
            segments.add(segment);
            offset = this.subInputStream.getStreamPosition();
            if (this.organisationType != 1) continue;
            offset += segment.getSegmentDataLength();
        }
        this.determineRandomDataOffsets(segments, offset);
    }

    private boolean isFileHeaderPresent() throws IOException {
        SubInputStream input = this.subInputStream;
        input.mark();
        int[] nArray = this.FILE_HEADER_ID;
        int n = this.FILE_HEADER_ID.length;
        int n2 = 0;
        while (n2 < n) {
            int magicByte = nArray[n2];
            if (magicByte != input.read()) {
                input.reset();
                return false;
            }
            ++n2;
        }
        input.reset();
        return true;
    }

    private void determineRandomDataOffsets(List<SegmentHeader> segments, long offset) {
        if (this.organisationType == 0) {
            for (SegmentHeader s : segments) {
                s.setSegmentDataStartOffset(offset);
                offset += s.getSegmentDataLength();
            }
        }
    }

    private void parseFileHeader() throws IOException {
        this.subInputStream.seek(0L);
        this.subInputStream.skipBytes(8);
        this.subInputStream.readBits(5);
        if (this.subInputStream.readBit() == 1) {
            this.gbUseExtTemplate = true;
        }
        if (this.subInputStream.readBit() != 1) {
            this.amountOfPagesUnknown = false;
        }
        this.organisationType = (short)this.subInputStream.readBit();
        if (!this.amountOfPagesUnknown) {
            this.amountOfPages = (int)this.subInputStream.readUnsignedInt();
            this.fileHeaderLength = (short)13;
        }
    }

    private boolean reachedEndOfStream(long offset) throws IOException {
        try {
            this.subInputStream.seek(offset);
            this.subInputStream.readBits(32);
            return false;
        }
        catch (EOFException e) {
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
    }

    protected JBIG2Globals getGlobalSegments() {
        return this.globalSegments;
    }

    protected boolean isAmountOfPagesUnknown() {
        return this.amountOfPagesUnknown;
    }

    boolean isGbUseExtTemplate() {
        return this.gbUseExtTemplate;
    }
}

