/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.JBIG2Document;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentData;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.err.JBIG2Exception;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.segments.EndOfStripe;
import org.apache.pdfbox.jbig2.segments.PageInformation;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.util.CombinationOperator;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

class JBIG2Page {
    private static final Logger log = LoggerFactory.getLogger(JBIG2Page.class);
    private final Map<Integer, SegmentHeader> segments = new TreeMap<Integer, SegmentHeader>();
    private final int pageNumber;
    private Bitmap pageBitmap;
    private int finalHeight;
    private int finalWidth;
    private int resolutionX;
    private int resolutionY;
    private final JBIG2Document document;

    protected JBIG2Page(JBIG2Document document, int pageNumber) {
        this.document = document;
        this.pageNumber = pageNumber;
    }

    public SegmentHeader getSegment(int number) {
        SegmentHeader s = this.segments.get(number);
        if (s != null) {
            return s;
        }
        if (this.document != null) {
            return this.document.getGlobalSegment(number);
        }
        log.info("Segment not found, returning null.");
        return null;
    }

    protected SegmentHeader getPageInformationSegment() {
        for (SegmentHeader s : this.segments.values()) {
            if (s.getSegmentType() != 48) continue;
            return s;
        }
        log.info("Page information segment not found.");
        return null;
    }

    protected Bitmap getBitmap() throws JBIG2Exception, IOException {
        if (this.pageBitmap == null) {
            this.composePageBitmap();
        }
        return this.pageBitmap;
    }

    private void composePageBitmap() throws IOException, JBIG2Exception {
        if (this.pageNumber > 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.createPage(pageInformation);
            this.clearSegmentData();
        }
    }

    private void createPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (!pageInformation.isStriped() || pageInformation.getHeight() != -1) {
            this.createNormalPage(pageInformation);
        } else {
            this.createStripedPage(pageInformation);
        }
    }

    private void createNormalPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        this.pageBitmap = new Bitmap(pageInformation.getWidth(), pageInformation.getHeight());
        if (pageInformation.getDefaultPixelValue() != 0) {
            Arrays.fill(this.pageBitmap.getByteArray(), (byte)-1);
        }
        for (SegmentHeader s : this.segments.values()) {
            switch (s.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    Region r = (Region)s.getSegmentData();
                    Bitmap regionBitmap = r.getRegionBitmap();
                    if (this.fitsPage(pageInformation, regionBitmap)) {
                        this.pageBitmap = regionBitmap;
                        break;
                    }
                    RegionSegmentInformation regionInfo = r.getRegionInfo();
                    CombinationOperator op = this.getCombinationOperator(pageInformation, regionInfo.getCombinationOperator());
                    Bitmaps.blit(regionBitmap, this.pageBitmap, regionInfo.getXLocation(), regionInfo.getYLocation(), op);
                }
            }
        }
    }

    private boolean fitsPage(PageInformation pageInformation, Bitmap regionBitmap) {
        return this.countRegions() == 1 && pageInformation.getDefaultPixelValue() == 0 && pageInformation.getWidth() == regionBitmap.getWidth() && pageInformation.getHeight() == regionBitmap.getHeight();
    }

    private void createStripedPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        ArrayList<SegmentData> pageStripes = this.collectPageStripes();
        this.pageBitmap = new Bitmap(pageInformation.getWidth(), this.finalHeight);
        int startLine = 0;
        for (SegmentData sd : pageStripes) {
            if (sd instanceof EndOfStripe) {
                startLine = ((EndOfStripe)sd).getLineNumber() + 1;
                continue;
            }
            Region r = (Region)sd;
            RegionSegmentInformation regionInfo = r.getRegionInfo();
            CombinationOperator op = this.getCombinationOperator(pageInformation, regionInfo.getCombinationOperator());
            Bitmaps.blit(r.getRegionBitmap(), this.pageBitmap, regionInfo.getXLocation(), startLine, op);
        }
    }

    private ArrayList<SegmentData> collectPageStripes() {
        ArrayList<SegmentData> pageStripes = new ArrayList<SegmentData>();
        for (SegmentHeader s : this.segments.values()) {
            switch (s.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    Region r = (Region)s.getSegmentData();
                    pageStripes.add(r);
                    break;
                }
                case 50: {
                    EndOfStripe eos = (EndOfStripe)s.getSegmentData();
                    pageStripes.add(eos);
                    this.finalHeight = eos.getLineNumber() + 1;
                }
            }
        }
        return pageStripes;
    }

    private int countRegions() {
        int regionCount = 0;
        for (SegmentHeader s : this.segments.values()) {
            switch (s.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    ++regionCount;
                }
            }
        }
        return regionCount;
    }

    private CombinationOperator getCombinationOperator(PageInformation pi, CombinationOperator newOperator) {
        if (pi.isCombinationOperatorOverrideAllowed()) {
            return newOperator;
        }
        return pi.getCombinationOperator();
    }

    protected void add(SegmentHeader segment) {
        this.segments.put(segment.getSegmentNr(), segment);
    }

    private void clearSegmentData() {
        Set<Integer> keySet = this.segments.keySet();
        for (Integer key : keySet) {
            this.segments.get(key).cleanSegmentData();
        }
    }

    protected void clearPageData() {
        this.pageBitmap = null;
    }

    protected int getHeight() throws IOException, JBIG2Exception {
        if (this.finalHeight == 0) {
            PageInformation pi = (PageInformation)this.getPageInformationSegment().getSegmentData();
            if (pi.getHeight() == -1) {
                this.getBitmap();
            } else {
                this.finalHeight = pi.getHeight();
            }
        }
        return this.finalHeight;
    }

    protected int getWidth() {
        if (this.finalWidth == 0) {
            PageInformation pi = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.finalWidth = pi.getWidth();
        }
        return this.finalWidth;
    }

    protected int getResolutionX() {
        if (this.resolutionX == 0) {
            PageInformation pi = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.resolutionX = pi.getResolutionX();
        }
        return this.resolutionX;
    }

    protected int getResolutionY() {
        if (this.resolutionY == 0) {
            PageInformation pi = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.resolutionY = pi.getResolutionY();
        }
        return this.resolutionY;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (Page number: " + this.pageNumber + ")";
    }
}

