/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2Document;
import org.apache.pdfbox.jbig2.JBIG2Page;
import org.apache.pdfbox.jbig2.SegmentData;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.EndOfStripe;
import org.apache.pdfbox.jbig2.segments.GenericRefinementRegion;
import org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.apache.pdfbox.jbig2.segments.HalftoneRegion;
import org.apache.pdfbox.jbig2.segments.PageInformation;
import org.apache.pdfbox.jbig2.segments.PatternDictionary;
import org.apache.pdfbox.jbig2.segments.Profiles;
import org.apache.pdfbox.jbig2.segments.SymbolDictionary;
import org.apache.pdfbox.jbig2.segments.Table;
import org.apache.pdfbox.jbig2.segments.TextRegion;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class SegmentHeader {
    private static final Logger log = LoggerFactory.getLogger(SegmentHeader.class);
    private static final Map<Integer, Class<? extends SegmentData>> SEGMENT_TYPE_MAP = new HashMap<Integer, Class<? extends SegmentData>>();
    private int segmentNr;
    private int segmentType;
    private byte retainFlag;
    private int pageAssociation;
    private byte pageAssociationFieldSize;
    private SegmentHeader[] rtSegments;
    private long segmentHeaderLength;
    private long segmentDataLength;
    private long segmentDataStartOffset;
    private final SubInputStream subInputStream;
    private Reference<SegmentData> segmentData;

    static {
        Object[][] SEGMENT_TYPES = new Object[][]{{0, SymbolDictionary.class}, {4, TextRegion.class}, {6, TextRegion.class}, {7, TextRegion.class}, {16, PatternDictionary.class}, {20, HalftoneRegion.class}, {22, HalftoneRegion.class}, {23, HalftoneRegion.class}, {36, GenericRegion.class}, {38, GenericRegion.class}, {39, GenericRegion.class}, {40, GenericRefinementRegion.class}, {42, GenericRefinementRegion.class}, {43, GenericRefinementRegion.class}, {48, PageInformation.class}, {50, EndOfStripe.class}, {52, Profiles.class}, {53, Table.class}};
        int i = 0;
        while (i < SEGMENT_TYPES.length) {
            Object[] objects = SEGMENT_TYPES[i];
            SEGMENT_TYPE_MAP.put((Integer)objects[0], (Class)objects[1]);
            ++i;
        }
    }

    public SegmentHeader(JBIG2Document document, SubInputStream sis, long offset, int organisationType) throws IOException {
        this.subInputStream = sis;
        this.parse(document, sis, offset, organisationType);
    }

    private void parse(JBIG2Document document, ImageInputStream subInputStream, long offset, int organisationType) throws IOException {
        this.printDebugMessage("\n########################");
        this.printDebugMessage("Segment parsing started.");
        subInputStream.seek(offset);
        this.printDebugMessage("|-Seeked to offset: " + offset);
        this.readSegmentNumber(subInputStream);
        this.readSegmentHeaderFlag(subInputStream);
        int countOfRTS = this.readAmountOfReferredToSegments(subInputStream);
        int[] rtsNumbers = this.readReferredToSegmentsNumbers(subInputStream, countOfRTS);
        this.readSegmentPageAssociation(document, subInputStream, countOfRTS, rtsNumbers);
        this.readSegmentDataLength(subInputStream);
        this.readDataStartOffset(subInputStream, organisationType);
        this.readSegmentHeaderLength(subInputStream, offset);
        this.printDebugMessage("########################\n");
    }

    private void readSegmentNumber(ImageInputStream subInputStream) throws IOException {
        this.segmentNr = (int)(subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.printDebugMessage("|-Segment Nr: " + this.segmentNr);
    }

    private void readSegmentHeaderFlag(ImageInputStream subInputStream) throws IOException {
        this.retainFlag = (byte)subInputStream.readBit();
        this.printDebugMessage("|-Retain flag: " + this.retainFlag);
        this.pageAssociationFieldSize = (byte)subInputStream.readBit();
        this.printDebugMessage("|-Page association field size=" + this.pageAssociationFieldSize);
        this.segmentType = (int)(subInputStream.readBits(6) & 0xFFL);
        this.printDebugMessage("|-Segment type=" + this.segmentType);
    }

    private int readAmountOfReferredToSegments(ImageInputStream subInputStream) throws IOException {
        int countOfRTS = (int)(subInputStream.readBits(3) & 0xFL);
        this.printDebugMessage("|-RTS count: " + countOfRTS);
        this.printDebugMessage("  |-Stream position before RTS: " + subInputStream.getStreamPosition());
        if (countOfRTS <= 4) {
            byte[] retainBit = new byte[5];
            int i = 0;
            while (i <= 4) {
                retainBit[i] = (byte)subInputStream.readBit();
                ++i;
            }
        } else {
            countOfRTS = (int)(subInputStream.readBits(29) & 0xFFFFFFFFFFFFFFFFL);
            int arrayLength = countOfRTS + 8 >> 3;
            byte[] retainBit = new byte[arrayLength <<= 3];
            int i = 0;
            while (i < arrayLength) {
                retainBit[i] = (byte)subInputStream.readBit();
                ++i;
            }
        }
        this.printDebugMessage("  |-Stream position after RTS: " + subInputStream.getStreamPosition());
        return countOfRTS;
    }

    private int[] readReferredToSegmentsNumbers(ImageInputStream subInputStream, int countOfRTS) throws IOException {
        int[] rtsNumbers = new int[countOfRTS];
        if (countOfRTS > 0) {
            int rtsSize = 1;
            if (this.segmentNr > 256) {
                rtsSize = 2;
                if (this.segmentNr > 65536) {
                    rtsSize = 4;
                }
            }
            this.rtSegments = new SegmentHeader[countOfRTS];
            this.printDebugMessage("|-Length of RT segments list: " + this.rtSegments.length);
            int i = 0;
            while (i < countOfRTS) {
                rtsNumbers[i] = (int)(subInputStream.readBits(rtsSize << 3) & 0xFFFFFFFFFFFFFFFFL);
                ++i;
            }
        }
        return rtsNumbers;
    }

    private void readSegmentPageAssociation(JBIG2Document document, ImageInputStream subInputStream, int countOfRTS, int[] rtsNumbers) throws IOException {
        this.pageAssociation = this.pageAssociationFieldSize == 0 ? (int)((short)(subInputStream.readBits(8) & 0xFFL)) : (int)(subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        if (countOfRTS > 0) {
            JBIG2Page page = document.getPage(this.pageAssociation);
            int i = 0;
            while (i < countOfRTS) {
                this.rtSegments[i] = page != null ? page.getSegment(rtsNumbers[i]) : document.getGlobalSegment(rtsNumbers[i]);
                ++i;
            }
        }
    }

    private void readSegmentDataLength(ImageInputStream subInputStream) throws IOException {
        this.segmentDataLength = subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL;
        this.printDebugMessage("|-Data length: " + this.segmentDataLength);
    }

    private void readDataStartOffset(ImageInputStream subInputStream, int organisationType) throws IOException {
        if (organisationType == 1) {
            this.printDebugMessage("|-Organization is sequential.");
            this.segmentDataStartOffset = subInputStream.getStreamPosition();
        }
    }

    private void readSegmentHeaderLength(ImageInputStream subInputStream, long offset) throws IOException {
        this.segmentHeaderLength = subInputStream.getStreamPosition() - offset;
        this.printDebugMessage("|-Segment header length: " + this.segmentHeaderLength);
    }

    private void printDebugMessage(String message) {
        log.debug(message);
    }

    public int getSegmentNr() {
        return this.segmentNr;
    }

    public int getSegmentType() {
        return this.segmentType;
    }

    public long getSegmentHeaderLength() {
        return this.segmentHeaderLength;
    }

    public long getSegmentDataLength() {
        return this.segmentDataLength;
    }

    public long getSegmentDataStartOffset() {
        return this.segmentDataStartOffset;
    }

    public void setSegmentDataStartOffset(long segmentDataStartOffset) {
        this.segmentDataStartOffset = segmentDataStartOffset;
    }

    public SegmentHeader[] getRtSegments() {
        return this.rtSegments;
    }

    public int getPageAssociation() {
        return this.pageAssociation;
    }

    public short getRetainFlag() {
        return this.retainFlag;
    }

    public SubInputStream getDataInputStream() {
        return new SubInputStream(this.subInputStream, this.segmentDataStartOffset, this.segmentDataLength);
    }

    public SegmentData getSegmentData() {
        SegmentData segmentDataPart = null;
        if (this.segmentData != null) {
            segmentDataPart = this.segmentData.get();
        }
        if (segmentDataPart == null) {
            try {
                Class<? extends SegmentData> segmentClass = SEGMENT_TYPE_MAP.get(this.segmentType);
                if (segmentClass == null) {
                    throw new IllegalArgumentException("No segment class for type " + this.segmentType);
                }
                segmentDataPart = segmentClass.newInstance();
                segmentDataPart.init(this, this.getDataInputStream());
                this.segmentData = new SoftReference<SegmentData>(segmentDataPart);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't instantiate segment class", e);
            }
        }
        return segmentDataPart;
    }

    public void cleanSegmentData() {
        if (this.segmentData != null) {
            this.segmentData = null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.rtSegments != null) {
            SegmentHeader[] segmentHeaderArray = this.rtSegments;
            int n = this.rtSegments.length;
            int n2 = 0;
            while (n2 < n) {
                SegmentHeader s = segmentHeaderArray[n2];
                stringBuilder.append(String.valueOf(s.segmentNr) + " ");
                ++n2;
            }
        } else {
            stringBuilder.append("none");
        }
        return "\n#SegmentNr: " + this.segmentNr + "\n SegmentType: " + this.segmentType + "\n PageAssociation: " + this.pageAssociation + "\n Referred-to segments: " + stringBuilder.toString() + "\n";
    }
}

