/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.decoder.huffman.InternalNode;
import org.apache.pdfbox.jbig2.decoder.huffman.ValueNode;

public abstract class HuffmanTable {
    private InternalNode rootNode = new InternalNode();

    public void initTree(List<Code> codeTable) {
        this.preprocessCodes(codeTable);
        for (Code c : codeTable) {
            this.rootNode.append(c);
        }
    }

    public long decode(ImageInputStream iis) throws IOException {
        return this.rootNode.decode(iis);
    }

    public String toString() {
        return this.rootNode + "\n";
    }

    public static String codeTableToString(List<Code> codeTable) {
        StringBuilder sb = new StringBuilder();
        for (Code c : codeTable) {
            sb.append(c.toString()).append("\n");
        }
        return sb.toString();
    }

    private void preprocessCodes(List<Code> codeTable) {
        int maxPrefixLength = 0;
        for (Code c : codeTable) {
            maxPrefixLength = Math.max(maxPrefixLength, c.prefixLength);
        }
        int[] lenCount = new int[maxPrefixLength + 1];
        for (Code c : codeTable) {
            int n = c.prefixLength;
            lenCount[n] = lenCount[n] + 1;
        }
        int[] firstCode = new int[lenCount.length + 1];
        lenCount[0] = 0;
        int curLen = 1;
        while (curLen <= lenCount.length) {
            firstCode[curLen] = firstCode[curLen - 1] + lenCount[curLen - 1] << 1;
            int curCode = firstCode[curLen];
            for (Code code : codeTable) {
                if (code.prefixLength != curLen) continue;
                code.code = curCode++;
            }
            ++curLen;
        }
    }

    public static class Code {
        final int prefixLength;
        final int rangeLength;
        final int rangeLow;
        final boolean isLowerRange;
        int code = -1;

        public Code(int prefixLength, int rangeLength, int rangeLow, boolean isLowerRange) {
            this.prefixLength = prefixLength;
            this.rangeLength = rangeLength;
            this.rangeLow = rangeLow;
            this.isLowerRange = isLowerRange;
        }

        public String toString() {
            return String.valueOf(this.code != -1 ? ValueNode.bitPattern(this.code, this.prefixLength) : "?") + "/" + this.prefixLength + "/" + this.rangeLength + "/" + this.rangeLow;
        }
    }
}

