/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.Node;
import org.apache.pdfbox.jbig2.decoder.huffman.OutOfBandNode;
import org.apache.pdfbox.jbig2.decoder.huffman.ValueNode;

class InternalNode
extends Node {
    private final int depth;
    private Node zero;
    private Node one;

    protected InternalNode() {
        this.depth = 0;
    }

    protected InternalNode(int depth) {
        this.depth = depth;
    }

    protected void append(HuffmanTable.Code c) {
        if (c.prefixLength == 0) {
            return;
        }
        int shift = c.prefixLength - 1 - this.depth;
        if (shift < 0) {
            throw new IllegalArgumentException("Negative shifting is not possible.");
        }
        int bit = c.code >> shift & 1;
        if (shift == 0) {
            if (c.rangeLength == -1) {
                if (bit == 1) {
                    if (this.one != null) {
                        throw new IllegalStateException("already have a OOB for " + c);
                    }
                    this.one = new OutOfBandNode(c);
                } else {
                    if (this.zero != null) {
                        throw new IllegalStateException("already have a OOB for " + c);
                    }
                    this.zero = new OutOfBandNode(c);
                }
            } else if (bit == 1) {
                if (this.one != null) {
                    throw new IllegalStateException("already have a ValueNode for " + c);
                }
                this.one = new ValueNode(c);
            } else {
                if (this.zero != null) {
                    throw new IllegalStateException("already have a ValueNode for " + c);
                }
                this.zero = new ValueNode(c);
            }
        } else if (bit == 1) {
            if (this.one == null) {
                this.one = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.one).append(c);
        } else {
            if (this.zero == null) {
                this.zero = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.zero).append(c);
        }
    }

    @Override
    protected long decode(ImageInputStream iis) throws IOException {
        int b = iis.readBit();
        Node n = b == 0 ? this.zero : this.one;
        return n.decode(iis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        this.pad(sb);
        sb.append("0: ").append(this.zero).append("\n");
        this.pad(sb);
        sb.append("1: ").append(this.one).append("\n");
        return sb.toString();
    }

    private void pad(StringBuilder sb) {
        int i = 0;
        while (i < this.depth) {
            sb.append("   ");
            ++i;
        }
    }
}

