/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.Node;

class ValueNode
extends Node {
    private int rangeLen;
    private int rangeLow;
    private boolean isLowerRange;

    protected ValueNode(HuffmanTable.Code c) {
        this.rangeLen = c.rangeLength;
        this.rangeLow = c.rangeLow;
        this.isLowerRange = c.isLowerRange;
    }

    @Override
    protected long decode(ImageInputStream iis) throws IOException {
        if (this.isLowerRange) {
            return (long)this.rangeLow - iis.readBits(this.rangeLen);
        }
        return (long)this.rangeLow + iis.readBits(this.rangeLen);
    }

    static String bitPattern(int v, int len) {
        char[] result = new char[len];
        int i = 1;
        while (i <= len) {
            result[i - 1] = (v >> len - i & 1) != 0 ? 49 : 48;
            ++i;
        }
        return new String(result);
    }
}

