/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SubInputStream
extends ImageInputStreamImpl {
    protected final ImageInputStream wrappedStream;
    protected final long offset;
    protected final long length;
    private final byte[] buffer = new byte[4096];
    long bufferBase;
    long bufferTop;

    public SubInputStream(ImageInputStream iis, long offset, long length) {
        assert (iis != null);
        assert (length >= 0L);
        assert (offset >= 0L);
        this.wrappedStream = iis;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        if (!(this.streamPos < this.bufferTop && this.streamPos >= this.bufferBase || this.fillBuffer())) {
            return -1;
        }
        int read = 0xFF & this.buffer[(int)(this.streamPos - this.bufferBase)];
        ++this.streamPos;
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        ImageInputStream imageInputStream = this.wrappedStream;
        synchronized (imageInputStream) {
            if (this.wrappedStream.getStreamPosition() != this.streamPos + this.offset) {
                this.wrappedStream.seek(this.streamPos + this.offset);
            }
            int toRead = (int)Math.min((long)len, this.length - this.streamPos);
            int read = this.wrappedStream.read(b, off, toRead);
            this.streamPos += (long)read;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillBuffer() throws IOException {
        ImageInputStream imageInputStream = this.wrappedStream;
        synchronized (imageInputStream) {
            if (this.wrappedStream.getStreamPosition() != this.streamPos + this.offset) {
                this.wrappedStream.seek(this.streamPos + this.offset);
            }
            this.bufferBase = this.streamPos;
            int toRead = (int)Math.min((long)this.buffer.length, this.length - this.streamPos);
            int read = this.wrappedStream.read(this.buffer, 0, toRead);
            this.bufferTop = this.bufferBase + (long)read;
            return read > 0;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    public void skipBits() {
        if (this.bitOffset != 0) {
            this.bitOffset = 0;
            ++this.streamPos;
        }
    }
}

