/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Utils {
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static Rectangle enlargeRectToGrid(Rectangle2D r) {
        int x0 = Utils.floor(r.getMinX());
        int y0 = Utils.floor(r.getMinY());
        int x1 = Utils.ceil(r.getMaxX());
        int y1 = Utils.ceil(r.getMaxY());
        return new Rectangle(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rectangle2D dilateRect(Rectangle2D r, double marginX, double marginY) {
        return new Rectangle2D.Double(r.getX() - marginX, r.getY() - marginY, r.getWidth() + 2.0 * marginX, r.getHeight() + 2.0 * marginY);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(max, Math.max(value, min));
    }

    public static int floor(double x) {
        return (int)(x + 16384.0) - 16384;
    }

    public static int round(double x) {
        return (int)(x + 16384.5) - 16384;
    }

    public static int ceil(double x) {
        return 16384 - (int)(16384.0 - x);
    }
}

