/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.lang.reflect.Method;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.SplitAndTrimTokenizer;
import org.aeonbits.owner.Tokenizer;
import org.aeonbits.owner.Util;

final class TokenizerResolver {
    private static final Tokenizer DEFAULT_TOKENIZER = new SplitAndTrimTokenizer(",");

    private TokenizerResolver() {
    }

    static Tokenizer resolveTokenizer(Method targetMethod) {
        Tokenizer methodLevelTokenizer = TokenizerResolver.resolveTokenizerOnMethodLevel(targetMethod);
        if (methodLevelTokenizer != null) {
            return methodLevelTokenizer;
        }
        Tokenizer classLevelTokenizer = TokenizerResolver.resolveTokenizerOnClassLevel(targetMethod.getDeclaringClass());
        if (classLevelTokenizer != null) {
            return classLevelTokenizer;
        }
        return DEFAULT_TOKENIZER;
    }

    private static Tokenizer resolveTokenizerOnClassLevel(Class<?> declaringClass) {
        Config.Separator separatorAnnotationOnClassLevel = declaringClass.getAnnotation(Config.Separator.class);
        Config.TokenizerClass tokenizerClassAnnotationOnClassLevel = declaringClass.getAnnotation(Config.TokenizerClass.class);
        if (separatorAnnotationOnClassLevel != null && tokenizerClassAnnotationOnClassLevel != null) {
            throw Util.unsupported("You cannot specify @Separator and @TokenizerClass both together on class level for '%s'", declaringClass.getCanonicalName());
        }
        if (separatorAnnotationOnClassLevel != null) {
            return new SplitAndTrimTokenizer(separatorAnnotationOnClassLevel.value());
        }
        if (tokenizerClassAnnotationOnClassLevel != null) {
            return Util.newInstance(tokenizerClassAnnotationOnClassLevel.value());
        }
        return null;
    }

    private static Tokenizer resolveTokenizerOnMethodLevel(Method targetMethod) {
        Config.Separator separatorAnnotationOnMethodLevel = targetMethod.getAnnotation(Config.Separator.class);
        Config.TokenizerClass tokenizerClassAnnotationOnMethodLevel = targetMethod.getAnnotation(Config.TokenizerClass.class);
        if (separatorAnnotationOnMethodLevel != null && tokenizerClassAnnotationOnMethodLevel != null) {
            throw Util.unsupported("You cannot specify @Separator and @TokenizerClass both together on method level for '%s'", targetMethod);
        }
        if (separatorAnnotationOnMethodLevel != null) {
            return new SplitAndTrimTokenizer(separatorAnnotationOnMethodLevel.value());
        }
        if (tokenizerClassAnnotationOnMethodLevel != null) {
            return Util.newInstance(tokenizerClassAnnotationOnMethodLevel.value());
        }
        return null;
    }
}

