/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.operator;

import java.util.List;
import org.ray.streaming.api.collector.Collector;
import org.ray.streaming.api.context.RuntimeContext;
import org.ray.streaming.api.function.Function;
import org.ray.streaming.message.KeyRecord;
import org.ray.streaming.message.Record;
import org.ray.streaming.operator.Operator;

public abstract class StreamOperator<F extends Function>
implements Operator {
    protected String name = this.getClass().getSimpleName();
    protected F function;
    protected List<Collector> collectorList;
    protected RuntimeContext runtimeContext;

    public StreamOperator(F function) {
        this.function = function;
    }

    @Override
    public void open(List<Collector> collectorList, RuntimeContext runtimeContext) {
        this.collectorList = collectorList;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public void finish() {
    }

    @Override
    public void close() {
    }

    protected void collect(Record record) {
        for (Collector collector : this.collectorList) {
            collector.collect(record);
        }
    }

    protected void collect(KeyRecord keyRecord) {
        for (Collector collector : this.collectorList) {
            collector.collect(keyRecord);
        }
    }

    public String getName() {
        return this.name;
    }
}

