/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.processor;

import org.ray.streaming.message.Record;
import org.ray.streaming.operator.TwoInputOperator;
import org.ray.streaming.runtime.core.processor.StreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoInputProcessor<T, O>
extends StreamProcessor<Record, TwoInputOperator<T, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoInputProcessor.class);
    private String leftStream;
    private String rightStream;

    public TwoInputProcessor(TwoInputOperator<T, O> operator) {
        super(operator);
    }

    @Override
    public void process(Record record) {
        try {
            if (record.getStream().equals(this.leftStream)) {
                ((TwoInputOperator)this.operator).processElement(record, null);
            } else {
                ((TwoInputOperator)this.operator).processElement(null, record);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        ((TwoInputOperator)this.operator).close();
    }

    public String getLeftStream() {
        return this.leftStream;
    }

    public void setLeftStream(String leftStream) {
        this.leftStream = leftStream;
    }

    public String getRightStream() {
        return this.rightStream;
    }

    public void setRightStream(String rightStream) {
        this.rightStream = rightStream;
    }
}

