/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.transfer;

import java.util.Map;
import org.ray.streaming.runtime.generated.Streaming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelUtils.class);

    static byte[] toNativeConf(Map<String, String> conf) {
        Streaming.StreamingConfig.Builder builder = Streaming.StreamingConfig.newBuilder();
        if (conf.containsKey("streaming.job.name")) {
            builder.setJobName(conf.get("streaming.job.name"));
        }
        if (conf.containsKey("streaming.task_job_id")) {
            builder.setTaskJobId(conf.get("streaming.task_job_id"));
        }
        if (conf.containsKey("streaming.worker_name")) {
            builder.setWorkerName(conf.get("streaming.worker_name"));
        }
        if (conf.containsKey("streaming.op_name")) {
            builder.setOpName(conf.get("streaming.op_name"));
        }
        if (conf.containsKey("streaming.ring_buffer_capacity")) {
            builder.setRingBufferCapacity(Integer.parseInt(conf.get("streaming.ring_buffer_capacity")));
        }
        if (conf.containsKey("streaming.empty_message_interval")) {
            builder.setEmptyMessageInterval(Integer.parseInt(conf.get("streaming.empty_message_interval")));
        }
        Streaming.StreamingConfig streamingConf = builder.build();
        LOGGER.info("Streaming native conf {}", (Object)streamingConf.toString());
        return streamingConf.toByteArray();
    }
}

