/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.transfer;

import com.google.common.base.Preconditions;
import org.ray.runtime.RayNativeRuntime;
import org.ray.runtime.functionmanager.FunctionDescriptor;
import org.ray.runtime.functionmanager.JavaFunctionDescriptor;
import org.ray.runtime.util.JniUtils;

public class TransferHandler {
    private long writerClientNative;
    private long readerClientNative;

    public TransferHandler(long coreWorkerNative, JavaFunctionDescriptor writerAsyncFunc, JavaFunctionDescriptor writerSyncFunc, JavaFunctionDescriptor readerAsyncFunc, JavaFunctionDescriptor readerSyncFunc) {
        Preconditions.checkArgument(coreWorkerNative != 0L);
        this.writerClientNative = this.createWriterClientNative(coreWorkerNative, writerAsyncFunc, writerSyncFunc);
        this.readerClientNative = this.createReaderClientNative(coreWorkerNative, readerAsyncFunc, readerSyncFunc);
    }

    public void onWriterMessage(byte[] buffer) {
        this.handleWriterMessageNative(this.writerClientNative, buffer);
    }

    public byte[] onWriterMessageSync(byte[] buffer) {
        return this.handleWriterMessageSyncNative(this.writerClientNative, buffer);
    }

    public void onReaderMessage(byte[] buffer) {
        this.handleReaderMessageNative(this.readerClientNative, buffer);
    }

    public byte[] onReaderMessageSync(byte[] buffer) {
        return this.handleReaderMessageSyncNative(this.readerClientNative, buffer);
    }

    private native long createWriterClientNative(long var1, FunctionDescriptor var3, FunctionDescriptor var4);

    private native long createReaderClientNative(long var1, FunctionDescriptor var3, FunctionDescriptor var4);

    private native void handleWriterMessageNative(long var1, byte[] var3);

    private native byte[] handleWriterMessageSyncNative(long var1, byte[] var3);

    private native void handleReaderMessageNative(long var1, byte[] var3);

    private native byte[] handleReaderMessageSyncNative(long var1, byte[] var3);

    static {
        try {
            Class.forName(RayNativeRuntime.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        JniUtils.loadLibrary("streaming_java");
    }
}

