/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class Platform {
    public static final Unsafe UNSAFE;
    private static final Constructor<?> DBB_CONSTRUCTOR;
    private static final long BUFFER_ADDRESS_FIELD_OFFSET;
    private static final long BUFFER_CAPACITY_FIELD_OFFSET;
    private static final ThreadLocal<ByteBuffer> localEmptyBuffer;

    public static ByteBuffer wrapDirectBuffer(long address, int size) {
        ByteBuffer buffer = localEmptyBuffer.get().duplicate();
        UNSAFE.putLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET, address);
        UNSAFE.putInt(buffer, BUFFER_CAPACITY_FIELD_OFFSET, size);
        buffer.clear();
        return buffer;
    }

    public static void wrapDirectBuffer(ByteBuffer buffer, long address, int size) {
        UNSAFE.putLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET, address);
        UNSAFE.putInt(buffer, BUFFER_CAPACITY_FIELD_OFFSET, size);
        buffer.clear();
    }

    public static long getAddress(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    static {
        Unsafe unsafe;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable cause) {
            throw new UnsupportedOperationException("Unsafe is not supported in this platform.");
        }
        UNSAFE = unsafe;
        try {
            Class<?> cls = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> constructor = cls.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            DBB_CONSTRUCTOR = constructor;
            Field addressField = Buffer.class.getDeclaredField("address");
            BUFFER_ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(addressField);
            Preconditions.checkArgument(BUFFER_ADDRESS_FIELD_OFFSET != 0L);
            Field capacityField = Buffer.class.getDeclaredField("capacity");
            BUFFER_CAPACITY_FIELD_OFFSET = UNSAFE.objectFieldOffset(capacityField);
            Preconditions.checkArgument(BUFFER_CAPACITY_FIELD_OFFSET != 0L);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        localEmptyBuffer = ThreadLocal.withInitial(() -> {
            try {
                return (ByteBuffer)DBB_CONSTRUCTOR.newInstance(0, 0);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                UNSAFE.throwException(e);
                throw new IllegalStateException("unreachable");
            }
        });
    }
}

