# coding: utf-8

"""
    Visier Analytic Model APIs

    Visier APIs for retrieving and configuring your analytic model in Visier.

    The version of the OpenAPI document: 22222222.99201.1876
    Contact: alpine@visier.com

    Please note that this SDK is currently in beta.
    Functionality and behavior may change in future releases.
    We encourage you to provide feedback and report any issues encountered during your use.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from visier_api_analytic_model.models.dataservices_datamodel_aggregation_type_parameter_dto import DataservicesDatamodelAggregationTypeParameterDTO
from visier_api_analytic_model.models.dataservices_datamodel_member_parameter_definition_dto import DataservicesDatamodelMemberParameterDefinitionDTO
from visier_api_analytic_model.models.dataservices_datamodel_numeric_parameter_definition_dto import DataservicesDatamodelNumericParameterDefinitionDTO
from visier_api_analytic_model.models.dataservices_datamodel_plan_parameter_definition_dto import DataservicesDatamodelPlanParameterDefinitionDTO
from typing import Optional, Set
from typing_extensions import Self

class DataservicesDatamodelParameterDefinitionDTO(BaseModel):
    """
    Parameters generalize object definitions so that end users can provide values at query run time.
    """ # noqa: E501
    member_parameter: Optional[DataservicesDatamodelMemberParameterDefinitionDTO] = Field(default=None, description="A filter parameter that can be set with dimension members for the end user to select.", alias="memberParameter")
    numeric_parameter: Optional[DataservicesDatamodelNumericParameterDefinitionDTO] = Field(default=None, description="A parameter with a numeric data type. A numeric parameter can be set with an optional default value and value range.", alias="numericParameter")
    plan_parameter: Optional[DataservicesDatamodelPlanParameterDefinitionDTO] = Field(default=None, description="A parameter on a planning metric. Plan parameters resolve planning model metrics to a specific plan and scenario or snapshot.", alias="planParameter")
    aggregation_type_parameter: Optional[DataservicesDatamodelAggregationTypeParameterDTO] = Field(default=None, description="An aggregation parameter. Such parameters enable control over how applicable metrics aggregate their results.", alias="aggregationTypeParameter")
    __properties: ClassVar[List[str]] = ["memberParameter", "numericParameter", "planParameter", "aggregationTypeParameter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataservicesDatamodelParameterDefinitionDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of member_parameter
        if self.member_parameter:
            _dict['memberParameter'] = self.member_parameter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of numeric_parameter
        if self.numeric_parameter:
            _dict['numericParameter'] = self.numeric_parameter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_parameter
        if self.plan_parameter:
            _dict['planParameter'] = self.plan_parameter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aggregation_type_parameter
        if self.aggregation_type_parameter:
            _dict['aggregationTypeParameter'] = self.aggregation_type_parameter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataservicesDatamodelParameterDefinitionDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "memberParameter": DataservicesDatamodelMemberParameterDefinitionDTO.from_dict(obj["memberParameter"]) if obj.get("memberParameter") is not None else None,
            "numericParameter": DataservicesDatamodelNumericParameterDefinitionDTO.from_dict(obj["numericParameter"]) if obj.get("numericParameter") is not None else None,
            "planParameter": DataservicesDatamodelPlanParameterDefinitionDTO.from_dict(obj["planParameter"]) if obj.get("planParameter") is not None else None,
            "aggregationTypeParameter": DataservicesDatamodelAggregationTypeParameterDTO.from_dict(obj["aggregationTypeParameter"]) if obj.get("aggregationTypeParameter") is not None else None
        })
        return _obj


