# coding: utf-8

"""
    Visier Analytic Model APIs

    Visier APIs for retrieving and configuring your analytic model in Visier.

    The version of the OpenAPI document: 22222222.99201.1876
    Contact: alpine@visier.com

    Please note that this SDK is currently in beta.
    Functionality and behavior may change in future releases.
    We encourage you to provide feedback and report any issues encountered during your use.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ServicingVeeQuestionDeleteDefinitionsByTenantDTO(BaseModel):
    """
    ServicingVeeQuestionDeleteDefinitionsByTenantDTO
    """ # noqa: E501
    tenant_code: Optional[StrictStr] = Field(default=None, description="The code of the tenant to delete sample questions from. Default is the current tenant.", alias="tenantCode")
    project_id: Optional[StrictStr] = Field(default=None, description="The project in which to delete sample questions. If omitted and the ProjectID request header is not defined, the change is published to production immediately.", alias="projectId")
    question_ids: Optional[List[StrictStr]] = Field(default=None, description="The IDs of the sample questions to delete for a specific tenant.", alias="questionIds")
    __properties: ClassVar[List[str]] = ["tenantCode", "projectId", "questionIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServicingVeeQuestionDeleteDefinitionsByTenantDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServicingVeeQuestionDeleteDefinitionsByTenantDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tenantCode": obj.get("tenantCode"),
            "projectId": obj.get("projectId"),
            "questionIds": obj.get("questionIds")
        })
        return _obj


