# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2018 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

import json

from .folder import Folder
from .report import Report
from .sheet import Sheet
from .template import Template
from .sight import Sight
from .workspace import Workspace
from ..types import TypedList
from ..util import serialize
from ..util import deserialize


class Home(object):

    """Smartsheet Home data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the Home model."""
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self._folders = TypedList(Folder)
        self._reports = TypedList(Report)
        self._sheets = TypedList(Sheet)
        self._sights = TypedList(Sight)
        self._templates = TypedList(Template)
        self._workspaces = TypedList(Workspace)

        if props:
            deserialize(self, props)

        # requests package Response object
        self.request_response = None

    @property
    def folders(self):
        return self._folders

    @folders.setter
    def folders(self, value):
        self._folders.load(value)

    @property
    def reports(self):
        return self._reports

    @reports.setter
    def reports(self, value):
        self._reports.load(value)

    @property
    def sheets(self):
        return self._sheets

    @sheets.setter
    def sheets(self, value):
        self._sheets.load(value)

    @property
    def sights(self):
        return self._sights

    @sights.setter
    def sights(self, value):
        self._sights.load(value)

    @property
    def templates(self):
        return self._templates

    @templates.setter
    def templates(self, value):
        self._templates.load(value)

    @property
    def workspaces(self):
        return self._workspaces

    @workspaces.setter
    def workspaces(self, value):
        self._workspaces.load(value)

    def to_dict(self):
        return serialize(self)

    def to_json(self):
        return json.dumps(self.to_dict())

    def __str__(self):
        return self.to_json()
