/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeClusterVmGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group#compute_cluster_id ComputeClusterVmGroup#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group#id ComputeClusterVmGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The unique name of the virtual machine group in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group#name ComputeClusterVmGroup#name}
    */
    readonly name: string;
    /**
    * The UUIDs of the virtual machines in this group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group#virtual_machine_ids ComputeClusterVmGroup#virtual_machine_ids}
    */
    readonly virtualMachineIds?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group vsphere_compute_cluster_vm_group}
*/
export declare class ComputeClusterVmGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_compute_cluster_vm_group";
    /**
    * Generates CDKTF code for importing a ComputeClusterVmGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeClusterVmGroup to import
    * @param importFromId The id of the existing ComputeClusterVmGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeClusterVmGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_group vsphere_compute_cluster_vm_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterVmGroupConfig
    */
    constructor(scope: Construct, id: string, config: ComputeClusterVmGroupConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualMachineIds?;
    get virtualMachineIds(): string[];
    set virtualMachineIds(value: string[]);
    resetVirtualMachineIds(): void;
    get virtualMachineIdsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
