/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeClusterVmHostRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * When this field is used, virtual machines defined in vm_group_name will be run on the hosts defined in this host group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#affinity_host_group_name ComputeClusterVmHostRule#affinity_host_group_name}
    */
    readonly affinityHostGroupName?: string;
    /**
    * When this field is used, virtual machines defined in vm_group_name will not be run on the hosts defined in this host group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#anti_affinity_host_group_name ComputeClusterVmHostRule#anti_affinity_host_group_name}
    */
    readonly antiAffinityHostGroupName?: string;
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#compute_cluster_id ComputeClusterVmHostRule#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * Enable this rule in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#enabled ComputeClusterVmHostRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#id ComputeClusterVmHostRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When true, prevents any virtual machine operations that may violate this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#mandatory ComputeClusterVmHostRule#mandatory}
    */
    readonly mandatory?: boolean | cdktf.IResolvable;
    /**
    * The unique name of the virtual machine group in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#name ComputeClusterVmHostRule#name}
    */
    readonly name: string;
    /**
    * The name of the virtual machine group to use with this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#vm_group_name ComputeClusterVmHostRule#vm_group_name}
    */
    readonly vmGroupName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule vsphere_compute_cluster_vm_host_rule}
*/
export declare class ComputeClusterVmHostRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_compute_cluster_vm_host_rule";
    /**
    * Generates CDKTF code for importing a ComputeClusterVmHostRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeClusterVmHostRule to import
    * @param importFromId The id of the existing ComputeClusterVmHostRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeClusterVmHostRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster_vm_host_rule vsphere_compute_cluster_vm_host_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterVmHostRuleConfig
    */
    constructor(scope: Construct, id: string, config: ComputeClusterVmHostRuleConfig);
    private _affinityHostGroupName?;
    get affinityHostGroupName(): string;
    set affinityHostGroupName(value: string);
    resetAffinityHostGroupName(): void;
    get affinityHostGroupNameInput(): string | undefined;
    private _antiAffinityHostGroupName?;
    get antiAffinityHostGroupName(): string;
    set antiAffinityHostGroupName(value: string);
    resetAntiAffinityHostGroupName(): void;
    get antiAffinityHostGroupNameInput(): string | undefined;
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mandatory?;
    get mandatory(): boolean | cdktf.IResolvable;
    set mandatory(value: boolean | cdktf.IResolvable);
    resetMandatory(): void;
    get mandatoryInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vmGroupName?;
    get vmGroupName(): string;
    set vmGroupName(value: string);
    get vmGroupNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
