"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeCluster = exports.ComputeClusterVsanStretchedClusterOutputReference = exports.computeClusterVsanStretchedClusterToHclTerraform = exports.computeClusterVsanStretchedClusterToTerraform = exports.ComputeClusterVsanFaultDomainsList = exports.ComputeClusterVsanFaultDomainsOutputReference = exports.computeClusterVsanFaultDomainsToHclTerraform = exports.computeClusterVsanFaultDomainsToTerraform = exports.ComputeClusterVsanFaultDomainsFaultDomainList = exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = exports.computeClusterVsanFaultDomainsFaultDomainToHclTerraform = exports.computeClusterVsanFaultDomainsFaultDomainToTerraform = exports.ComputeClusterVsanDiskGroupList = exports.ComputeClusterVsanDiskGroupOutputReference = exports.computeClusterVsanDiskGroupToHclTerraform = exports.computeClusterVsanDiskGroupToTerraform = exports.ComputeClusterHostImageOutputReference = exports.computeClusterHostImageToHclTerraform = exports.computeClusterHostImageToTerraform = exports.ComputeClusterHostImageComponentList = exports.ComputeClusterHostImageComponentOutputReference = exports.computeClusterHostImageComponentToHclTerraform = exports.computeClusterHostImageComponentToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeClusterHostImageComponentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        version: cdktf.stringToTerraform(struct.version),
    };
}
exports.computeClusterHostImageComponentToTerraform = computeClusterHostImageComponentToTerraform;
function computeClusterHostImageComponentToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        key: {
            value: cdktf.stringToHclTerraform(struct.key),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        version: {
            value: cdktf.stringToHclTerraform(struct.version),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterHostImageComponentToHclTerraform = computeClusterHostImageComponentToHclTerraform;
class ComputeClusterHostImageComponentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._key !== undefined) {
            hasAnyValues = true;
            internalValueResult.key = this._key;
        }
        if (this._version !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._key = undefined;
            this._version = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._key = value.key;
            this._version = value.version;
        }
    }
    get key() {
        return this.getStringAttribute('key');
    }
    set key(value) {
        this._key = value;
    }
    resetKey() {
        this._key = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyInput() {
        return this._key;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
}
exports.ComputeClusterHostImageComponentOutputReference = ComputeClusterHostImageComponentOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentOutputReference", version: "9.4.0" };
class ComputeClusterHostImageComponentList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterHostImageComponentOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterHostImageComponentList = ComputeClusterHostImageComponentList;
_b = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentList[_b] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentList", version: "9.4.0" };
function computeClusterHostImageToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        esx_version: cdktf.stringToTerraform(struct.esxVersion),
        component: cdktf.listMapper(computeClusterHostImageComponentToTerraform, true)(struct.component),
    };
}
exports.computeClusterHostImageToTerraform = computeClusterHostImageToTerraform;
function computeClusterHostImageToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        esx_version: {
            value: cdktf.stringToHclTerraform(struct.esxVersion),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        component: {
            value: cdktf.listMapperHcl(computeClusterHostImageComponentToHclTerraform, true)(struct.component),
            isBlock: true,
            type: "list",
            storageClassType: "ComputeClusterHostImageComponentList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterHostImageToHclTerraform = computeClusterHostImageToHclTerraform;
class ComputeClusterHostImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // component - computed: false, optional: true, required: false
        this._component = new ComputeClusterHostImageComponentList(this, "component", false);
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._esxVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.esxVersion = this._esxVersion;
        }
        if (this._component?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.component = this._component?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._esxVersion = undefined;
            this._component.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._esxVersion = value.esxVersion;
            this._component.internalValue = value.component;
        }
    }
    get esxVersion() {
        return this.getStringAttribute('esx_version');
    }
    set esxVersion(value) {
        this._esxVersion = value;
    }
    resetEsxVersion() {
        this._esxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get esxVersionInput() {
        return this._esxVersion;
    }
    get component() {
        return this._component;
    }
    putComponent(value) {
        this._component.internalValue = value;
    }
    resetComponent() {
        this._component.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get componentInput() {
        return this._component.internalValue;
    }
}
exports.ComputeClusterHostImageOutputReference = ComputeClusterHostImageOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageOutputReference", version: "9.4.0" };
function computeClusterVsanDiskGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache: cdktf.stringToTerraform(struct.cache),
        storage: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.storage),
    };
}
exports.computeClusterVsanDiskGroupToTerraform = computeClusterVsanDiskGroupToTerraform;
function computeClusterVsanDiskGroupToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        cache: {
            value: cdktf.stringToHclTerraform(struct.cache),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        storage: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.storage),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanDiskGroupToHclTerraform = computeClusterVsanDiskGroupToHclTerraform;
class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cache !== undefined) {
            hasAnyValues = true;
            internalValueResult.cache = this._cache;
        }
        if (this._storage !== undefined) {
            hasAnyValues = true;
            internalValueResult.storage = this._storage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._cache = undefined;
            this._storage = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._cache = value.cache;
            this._storage = value.storage;
        }
    }
    get cache() {
        return this.getStringAttribute('cache');
    }
    set cache(value) {
        this._cache = value;
    }
    resetCache() {
        this._cache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInput() {
        return this._cache;
    }
    get storage() {
        return cdktf.Fn.tolist(this.getListAttribute('storage'));
    }
    set storage(value) {
        this._storage = value;
    }
    resetStorage() {
        this._storage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageInput() {
        return this._storage;
    }
}
exports.ComputeClusterVsanDiskGroupOutputReference = ComputeClusterVsanDiskGroupOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupOutputReference[_d] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupOutputReference", version: "9.4.0" };
class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanDiskGroupOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanDiskGroupList = ComputeClusterVsanDiskGroupList;
_e = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupList[_e] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupList", version: "9.4.0" };
function computeClusterVsanFaultDomainsFaultDomainToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.hostIds),
        name: cdktf.stringToTerraform(struct.name),
    };
}
exports.computeClusterVsanFaultDomainsFaultDomainToTerraform = computeClusterVsanFaultDomainsFaultDomainToTerraform;
function computeClusterVsanFaultDomainsFaultDomainToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.hostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        name: {
            value: cdktf.stringToHclTerraform(struct.name),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanFaultDomainsFaultDomainToHclTerraform = computeClusterVsanFaultDomainsFaultDomainToHclTerraform;
class ComputeClusterVsanFaultDomainsFaultDomainOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._hostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostIds = this._hostIds;
        }
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._hostIds = undefined;
            this._name = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._hostIds = value.hostIds;
            this._name = value.name;
        }
    }
    get hostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_ids'));
    }
    set hostIds(value) {
        this._hostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostIdsInput() {
        return this._hostIds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = ComputeClusterVsanFaultDomainsFaultDomainOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainOutputReference[_f] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainOutputReference", version: "9.4.0" };
class ComputeClusterVsanFaultDomainsFaultDomainList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsFaultDomainOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainList = ComputeClusterVsanFaultDomainsFaultDomainList;
_g = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainList[_g] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainList", version: "9.4.0" };
function computeClusterVsanFaultDomainsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fault_domain: cdktf.listMapper(computeClusterVsanFaultDomainsFaultDomainToTerraform, true)(struct.faultDomain),
    };
}
exports.computeClusterVsanFaultDomainsToTerraform = computeClusterVsanFaultDomainsToTerraform;
function computeClusterVsanFaultDomainsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        fault_domain: {
            value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsFaultDomainToHclTerraform, true)(struct.faultDomain),
            isBlock: true,
            type: "set",
            storageClassType: "ComputeClusterVsanFaultDomainsFaultDomainList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanFaultDomainsToHclTerraform = computeClusterVsanFaultDomainsToHclTerraform;
class ComputeClusterVsanFaultDomainsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
        // fault_domain - computed: false, optional: true, required: false
        this._faultDomain = new ComputeClusterVsanFaultDomainsFaultDomainList(this, "fault_domain", true);
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._faultDomain?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.faultDomain = this._faultDomain?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = value.faultDomain;
        }
    }
    get faultDomain() {
        return this._faultDomain;
    }
    putFaultDomain(value) {
        this._faultDomain.internalValue = value;
    }
    resetFaultDomain() {
        this._faultDomain.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faultDomainInput() {
        return this._faultDomain.internalValue;
    }
}
exports.ComputeClusterVsanFaultDomainsOutputReference = ComputeClusterVsanFaultDomainsOutputReference;
_h = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsOutputReference[_h] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsOutputReference", version: "9.4.0" };
class ComputeClusterVsanFaultDomainsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsList = ComputeClusterVsanFaultDomainsList;
_j = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsList[_j] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsList", version: "9.4.0" };
function computeClusterVsanStretchedClusterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        preferred_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.preferredFaultDomainHostIds),
        preferred_fault_domain_name: cdktf.stringToTerraform(struct.preferredFaultDomainName),
        secondary_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.secondaryFaultDomainHostIds),
        secondary_fault_domain_name: cdktf.stringToTerraform(struct.secondaryFaultDomainName),
        witness_node: cdktf.stringToTerraform(struct.witnessNode),
    };
}
exports.computeClusterVsanStretchedClusterToTerraform = computeClusterVsanStretchedClusterToTerraform;
function computeClusterVsanStretchedClusterToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        preferred_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.preferredFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        preferred_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.preferredFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        secondary_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.secondaryFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        secondary_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.secondaryFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        witness_node: {
            value: cdktf.stringToHclTerraform(struct.witnessNode),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanStretchedClusterToHclTerraform = computeClusterVsanStretchedClusterToHclTerraform;
class ComputeClusterVsanStretchedClusterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._preferredFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainHostIds = this._preferredFaultDomainHostIds;
        }
        if (this._preferredFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainName = this._preferredFaultDomainName;
        }
        if (this._secondaryFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainHostIds = this._secondaryFaultDomainHostIds;
        }
        if (this._secondaryFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainName = this._secondaryFaultDomainName;
        }
        if (this._witnessNode !== undefined) {
            hasAnyValues = true;
            internalValueResult.witnessNode = this._witnessNode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._preferredFaultDomainHostIds = undefined;
            this._preferredFaultDomainName = undefined;
            this._secondaryFaultDomainHostIds = undefined;
            this._secondaryFaultDomainName = undefined;
            this._witnessNode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._preferredFaultDomainHostIds = value.preferredFaultDomainHostIds;
            this._preferredFaultDomainName = value.preferredFaultDomainName;
            this._secondaryFaultDomainHostIds = value.secondaryFaultDomainHostIds;
            this._secondaryFaultDomainName = value.secondaryFaultDomainName;
            this._witnessNode = value.witnessNode;
        }
    }
    get preferredFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('preferred_fault_domain_host_ids'));
    }
    set preferredFaultDomainHostIds(value) {
        this._preferredFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainHostIdsInput() {
        return this._preferredFaultDomainHostIds;
    }
    get preferredFaultDomainName() {
        return this.getStringAttribute('preferred_fault_domain_name');
    }
    set preferredFaultDomainName(value) {
        this._preferredFaultDomainName = value;
    }
    resetPreferredFaultDomainName() {
        this._preferredFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainNameInput() {
        return this._preferredFaultDomainName;
    }
    get secondaryFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('secondary_fault_domain_host_ids'));
    }
    set secondaryFaultDomainHostIds(value) {
        this._secondaryFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainHostIdsInput() {
        return this._secondaryFaultDomainHostIds;
    }
    get secondaryFaultDomainName() {
        return this.getStringAttribute('secondary_fault_domain_name');
    }
    set secondaryFaultDomainName(value) {
        this._secondaryFaultDomainName = value;
    }
    resetSecondaryFaultDomainName() {
        this._secondaryFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainNameInput() {
        return this._secondaryFaultDomainName;
    }
    get witnessNode() {
        return this.getStringAttribute('witness_node');
    }
    set witnessNode(value) {
        this._witnessNode = value;
    }
    // Temporarily expose input value. Use with caution.
    get witnessNodeInput() {
        return this._witnessNode;
    }
}
exports.ComputeClusterVsanStretchedClusterOutputReference = ComputeClusterVsanStretchedClusterOutputReference;
_k = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanStretchedClusterOutputReference[_k] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanStretchedClusterOutputReference", version: "9.4.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster vsphere_compute_cluster}
*/
class ComputeCluster extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ComputeCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeCluster to import
    * @param importFromId The id of the existing ComputeCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_compute_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_compute_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.10.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // host_image - computed: false, optional: true, required: false
        this._hostImage = new ComputeClusterHostImageOutputReference(this, "host_image");
        // vsan_disk_group - computed: false, optional: true, required: false
        this._vsanDiskGroup = new ComputeClusterVsanDiskGroupList(this, "vsan_disk_group", false);
        // vsan_fault_domains - computed: false, optional: true, required: false
        this._vsanFaultDomains = new ComputeClusterVsanFaultDomainsList(this, "vsan_fault_domains", true);
        // vsan_stretched_cluster - computed: false, optional: true, required: false
        this._vsanStretchedCluster = new ComputeClusterVsanStretchedClusterOutputReference(this, "vsan_stretched_cluster");
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._dpmAutomationLevel = config.dpmAutomationLevel;
        this._dpmEnabled = config.dpmEnabled;
        this._dpmThreshold = config.dpmThreshold;
        this._drsAdvancedOptions = config.drsAdvancedOptions;
        this._drsAutomationLevel = config.drsAutomationLevel;
        this._drsEnablePredictiveDrs = config.drsEnablePredictiveDrs;
        this._drsEnableVmOverrides = config.drsEnableVmOverrides;
        this._drsEnabled = config.drsEnabled;
        this._drsMigrationThreshold = config.drsMigrationThreshold;
        this._drsScaleDescendantsShares = config.drsScaleDescendantsShares;
        this._folder = config.folder;
        this._forceEvacuateOnDestroy = config.forceEvacuateOnDestroy;
        this._haAdmissionControlFailoverHostSystemIds = config.haAdmissionControlFailoverHostSystemIds;
        this._haAdmissionControlHostFailureTolerance = config.haAdmissionControlHostFailureTolerance;
        this._haAdmissionControlPerformanceTolerance = config.haAdmissionControlPerformanceTolerance;
        this._haAdmissionControlPolicy = config.haAdmissionControlPolicy;
        this._haAdmissionControlResourcePercentageAutoCompute = config.haAdmissionControlResourcePercentageAutoCompute;
        this._haAdmissionControlResourcePercentageCpu = config.haAdmissionControlResourcePercentageCpu;
        this._haAdmissionControlResourcePercentageMemory = config.haAdmissionControlResourcePercentageMemory;
        this._haAdmissionControlSlotPolicyExplicitCpu = config.haAdmissionControlSlotPolicyExplicitCpu;
        this._haAdmissionControlSlotPolicyExplicitMemory = config.haAdmissionControlSlotPolicyExplicitMemory;
        this._haAdmissionControlSlotPolicyUseExplicitSize = config.haAdmissionControlSlotPolicyUseExplicitSize;
        this._haAdvancedOptions = config.haAdvancedOptions;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haEnabled = config.haEnabled;
        this._haHeartbeatDatastoreIds = config.haHeartbeatDatastoreIds;
        this._haHeartbeatDatastorePolicy = config.haHeartbeatDatastorePolicy;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haHostMonitoring = config.haHostMonitoring;
        this._haVmComponentProtection = config.haVmComponentProtection;
        this._haVmDependencyRestartCondition = config.haVmDependencyRestartCondition;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmRestartAdditionalDelay = config.haVmRestartAdditionalDelay;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._hostClusterExitTimeout = config.hostClusterExitTimeout;
        this._hostManaged = config.hostManaged;
        this._hostSystemIds = config.hostSystemIds;
        this._id = config.id;
        this._name = config.name;
        this._proactiveHaAutomationLevel = config.proactiveHaAutomationLevel;
        this._proactiveHaEnabled = config.proactiveHaEnabled;
        this._proactiveHaModerateRemediation = config.proactiveHaModerateRemediation;
        this._proactiveHaProviderIds = config.proactiveHaProviderIds;
        this._proactiveHaSevereRemediation = config.proactiveHaSevereRemediation;
        this._tags = config.tags;
        this._vsanCompressionEnabled = config.vsanCompressionEnabled;
        this._vsanDedupEnabled = config.vsanDedupEnabled;
        this._vsanDitEncryptionEnabled = config.vsanDitEncryptionEnabled;
        this._vsanDitRekeyInterval = config.vsanDitRekeyInterval;
        this._vsanEnabled = config.vsanEnabled;
        this._vsanEsaEnabled = config.vsanEsaEnabled;
        this._vsanNetworkDiagnosticModeEnabled = config.vsanNetworkDiagnosticModeEnabled;
        this._vsanPerformanceEnabled = config.vsanPerformanceEnabled;
        this._vsanRemoteDatastoreIds = config.vsanRemoteDatastoreIds;
        this._vsanUnmapEnabled = config.vsanUnmapEnabled;
        this._vsanVerboseModeEnabled = config.vsanVerboseModeEnabled;
        this._hostImage.internalValue = config.hostImage;
        this._vsanDiskGroup.internalValue = config.vsanDiskGroup;
        this._vsanFaultDomains.internalValue = config.vsanFaultDomains;
        this._vsanStretchedCluster.internalValue = config.vsanStretchedCluster;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get dpmAutomationLevel() {
        return this.getStringAttribute('dpm_automation_level');
    }
    set dpmAutomationLevel(value) {
        this._dpmAutomationLevel = value;
    }
    resetDpmAutomationLevel() {
        this._dpmAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmAutomationLevelInput() {
        return this._dpmAutomationLevel;
    }
    get dpmEnabled() {
        return this.getBooleanAttribute('dpm_enabled');
    }
    set dpmEnabled(value) {
        this._dpmEnabled = value;
    }
    resetDpmEnabled() {
        this._dpmEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmEnabledInput() {
        return this._dpmEnabled;
    }
    get dpmThreshold() {
        return this.getNumberAttribute('dpm_threshold');
    }
    set dpmThreshold(value) {
        this._dpmThreshold = value;
    }
    resetDpmThreshold() {
        this._dpmThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmThresholdInput() {
        return this._dpmThreshold;
    }
    get drsAdvancedOptions() {
        return this.getStringMapAttribute('drs_advanced_options');
    }
    set drsAdvancedOptions(value) {
        this._drsAdvancedOptions = value;
    }
    resetDrsAdvancedOptions() {
        this._drsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAdvancedOptionsInput() {
        return this._drsAdvancedOptions;
    }
    get drsAutomationLevel() {
        return this.getStringAttribute('drs_automation_level');
    }
    set drsAutomationLevel(value) {
        this._drsAutomationLevel = value;
    }
    resetDrsAutomationLevel() {
        this._drsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAutomationLevelInput() {
        return this._drsAutomationLevel;
    }
    get drsEnablePredictiveDrs() {
        return this.getBooleanAttribute('drs_enable_predictive_drs');
    }
    set drsEnablePredictiveDrs(value) {
        this._drsEnablePredictiveDrs = value;
    }
    resetDrsEnablePredictiveDrs() {
        this._drsEnablePredictiveDrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnablePredictiveDrsInput() {
        return this._drsEnablePredictiveDrs;
    }
    get drsEnableVmOverrides() {
        return this.getBooleanAttribute('drs_enable_vm_overrides');
    }
    set drsEnableVmOverrides(value) {
        this._drsEnableVmOverrides = value;
    }
    resetDrsEnableVmOverrides() {
        this._drsEnableVmOverrides = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnableVmOverridesInput() {
        return this._drsEnableVmOverrides;
    }
    get drsEnabled() {
        return this.getBooleanAttribute('drs_enabled');
    }
    set drsEnabled(value) {
        this._drsEnabled = value;
    }
    resetDrsEnabled() {
        this._drsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnabledInput() {
        return this._drsEnabled;
    }
    get drsMigrationThreshold() {
        return this.getNumberAttribute('drs_migration_threshold');
    }
    set drsMigrationThreshold(value) {
        this._drsMigrationThreshold = value;
    }
    resetDrsMigrationThreshold() {
        this._drsMigrationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsMigrationThresholdInput() {
        return this._drsMigrationThreshold;
    }
    get drsScaleDescendantsShares() {
        return this.getStringAttribute('drs_scale_descendants_shares');
    }
    set drsScaleDescendantsShares(value) {
        this._drsScaleDescendantsShares = value;
    }
    resetDrsScaleDescendantsShares() {
        this._drsScaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsScaleDescendantsSharesInput() {
        return this._drsScaleDescendantsShares;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get forceEvacuateOnDestroy() {
        return this.getBooleanAttribute('force_evacuate_on_destroy');
    }
    set forceEvacuateOnDestroy(value) {
        this._forceEvacuateOnDestroy = value;
    }
    resetForceEvacuateOnDestroy() {
        this._forceEvacuateOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceEvacuateOnDestroyInput() {
        return this._forceEvacuateOnDestroy;
    }
    get haAdmissionControlFailoverHostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_admission_control_failover_host_system_ids'));
    }
    set haAdmissionControlFailoverHostSystemIds(value) {
        this._haAdmissionControlFailoverHostSystemIds = value;
    }
    resetHaAdmissionControlFailoverHostSystemIds() {
        this._haAdmissionControlFailoverHostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlFailoverHostSystemIdsInput() {
        return this._haAdmissionControlFailoverHostSystemIds;
    }
    get haAdmissionControlHostFailureTolerance() {
        return this.getNumberAttribute('ha_admission_control_host_failure_tolerance');
    }
    set haAdmissionControlHostFailureTolerance(value) {
        this._haAdmissionControlHostFailureTolerance = value;
    }
    resetHaAdmissionControlHostFailureTolerance() {
        this._haAdmissionControlHostFailureTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlHostFailureToleranceInput() {
        return this._haAdmissionControlHostFailureTolerance;
    }
    get haAdmissionControlPerformanceTolerance() {
        return this.getNumberAttribute('ha_admission_control_performance_tolerance');
    }
    set haAdmissionControlPerformanceTolerance(value) {
        this._haAdmissionControlPerformanceTolerance = value;
    }
    resetHaAdmissionControlPerformanceTolerance() {
        this._haAdmissionControlPerformanceTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPerformanceToleranceInput() {
        return this._haAdmissionControlPerformanceTolerance;
    }
    get haAdmissionControlPolicy() {
        return this.getStringAttribute('ha_admission_control_policy');
    }
    set haAdmissionControlPolicy(value) {
        this._haAdmissionControlPolicy = value;
    }
    resetHaAdmissionControlPolicy() {
        this._haAdmissionControlPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPolicyInput() {
        return this._haAdmissionControlPolicy;
    }
    get haAdmissionControlResourcePercentageAutoCompute() {
        return this.getBooleanAttribute('ha_admission_control_resource_percentage_auto_compute');
    }
    set haAdmissionControlResourcePercentageAutoCompute(value) {
        this._haAdmissionControlResourcePercentageAutoCompute = value;
    }
    resetHaAdmissionControlResourcePercentageAutoCompute() {
        this._haAdmissionControlResourcePercentageAutoCompute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageAutoComputeInput() {
        return this._haAdmissionControlResourcePercentageAutoCompute;
    }
    get haAdmissionControlResourcePercentageCpu() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_cpu');
    }
    set haAdmissionControlResourcePercentageCpu(value) {
        this._haAdmissionControlResourcePercentageCpu = value;
    }
    resetHaAdmissionControlResourcePercentageCpu() {
        this._haAdmissionControlResourcePercentageCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageCpuInput() {
        return this._haAdmissionControlResourcePercentageCpu;
    }
    get haAdmissionControlResourcePercentageMemory() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_memory');
    }
    set haAdmissionControlResourcePercentageMemory(value) {
        this._haAdmissionControlResourcePercentageMemory = value;
    }
    resetHaAdmissionControlResourcePercentageMemory() {
        this._haAdmissionControlResourcePercentageMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageMemoryInput() {
        return this._haAdmissionControlResourcePercentageMemory;
    }
    get haAdmissionControlSlotPolicyExplicitCpu() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_cpu');
    }
    set haAdmissionControlSlotPolicyExplicitCpu(value) {
        this._haAdmissionControlSlotPolicyExplicitCpu = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitCpu() {
        this._haAdmissionControlSlotPolicyExplicitCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitCpuInput() {
        return this._haAdmissionControlSlotPolicyExplicitCpu;
    }
    get haAdmissionControlSlotPolicyExplicitMemory() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_memory');
    }
    set haAdmissionControlSlotPolicyExplicitMemory(value) {
        this._haAdmissionControlSlotPolicyExplicitMemory = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitMemory() {
        this._haAdmissionControlSlotPolicyExplicitMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitMemoryInput() {
        return this._haAdmissionControlSlotPolicyExplicitMemory;
    }
    get haAdmissionControlSlotPolicyUseExplicitSize() {
        return this.getBooleanAttribute('ha_admission_control_slot_policy_use_explicit_size');
    }
    set haAdmissionControlSlotPolicyUseExplicitSize(value) {
        this._haAdmissionControlSlotPolicyUseExplicitSize = value;
    }
    resetHaAdmissionControlSlotPolicyUseExplicitSize() {
        this._haAdmissionControlSlotPolicyUseExplicitSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyUseExplicitSizeInput() {
        return this._haAdmissionControlSlotPolicyUseExplicitSize;
    }
    get haAdvancedOptions() {
        return this.getStringMapAttribute('ha_advanced_options');
    }
    set haAdvancedOptions(value) {
        this._haAdvancedOptions = value;
    }
    resetHaAdvancedOptions() {
        this._haAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdvancedOptionsInput() {
        return this._haAdvancedOptions;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haEnabled() {
        return this.getBooleanAttribute('ha_enabled');
    }
    set haEnabled(value) {
        this._haEnabled = value;
    }
    resetHaEnabled() {
        this._haEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haEnabledInput() {
        return this._haEnabled;
    }
    get haHeartbeatDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_heartbeat_datastore_ids'));
    }
    set haHeartbeatDatastoreIds(value) {
        this._haHeartbeatDatastoreIds = value;
    }
    resetHaHeartbeatDatastoreIds() {
        this._haHeartbeatDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastoreIdsInput() {
        return this._haHeartbeatDatastoreIds;
    }
    get haHeartbeatDatastorePolicy() {
        return this.getStringAttribute('ha_heartbeat_datastore_policy');
    }
    set haHeartbeatDatastorePolicy(value) {
        this._haHeartbeatDatastorePolicy = value;
    }
    resetHaHeartbeatDatastorePolicy() {
        this._haHeartbeatDatastorePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastorePolicyInput() {
        return this._haHeartbeatDatastorePolicy;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haHostMonitoring() {
        return this.getStringAttribute('ha_host_monitoring');
    }
    set haHostMonitoring(value) {
        this._haHostMonitoring = value;
    }
    resetHaHostMonitoring() {
        this._haHostMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostMonitoringInput() {
        return this._haHostMonitoring;
    }
    get haVmComponentProtection() {
        return this.getStringAttribute('ha_vm_component_protection');
    }
    set haVmComponentProtection(value) {
        this._haVmComponentProtection = value;
    }
    resetHaVmComponentProtection() {
        this._haVmComponentProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmComponentProtectionInput() {
        return this._haVmComponentProtection;
    }
    get haVmDependencyRestartCondition() {
        return this.getStringAttribute('ha_vm_dependency_restart_condition');
    }
    set haVmDependencyRestartCondition(value) {
        this._haVmDependencyRestartCondition = value;
    }
    resetHaVmDependencyRestartCondition() {
        this._haVmDependencyRestartCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmDependencyRestartConditionInput() {
        return this._haVmDependencyRestartCondition;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmRestartAdditionalDelay() {
        return this.getNumberAttribute('ha_vm_restart_additional_delay');
    }
    set haVmRestartAdditionalDelay(value) {
        this._haVmRestartAdditionalDelay = value;
    }
    resetHaVmRestartAdditionalDelay() {
        this._haVmRestartAdditionalDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartAdditionalDelayInput() {
        return this._haVmRestartAdditionalDelay;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get hostClusterExitTimeout() {
        return this.getNumberAttribute('host_cluster_exit_timeout');
    }
    set hostClusterExitTimeout(value) {
        this._hostClusterExitTimeout = value;
    }
    resetHostClusterExitTimeout() {
        this._hostClusterExitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostClusterExitTimeoutInput() {
        return this._hostClusterExitTimeout;
    }
    get hostManaged() {
        return this.getBooleanAttribute('host_managed');
    }
    set hostManaged(value) {
        this._hostManaged = value;
    }
    resetHostManaged() {
        this._hostManaged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostManagedInput() {
        return this._hostManaged;
    }
    get hostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_system_ids'));
    }
    set hostSystemIds(value) {
        this._hostSystemIds = value;
    }
    resetHostSystemIds() {
        this._hostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdsInput() {
        return this._hostSystemIds;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get proactiveHaAutomationLevel() {
        return this.getStringAttribute('proactive_ha_automation_level');
    }
    set proactiveHaAutomationLevel(value) {
        this._proactiveHaAutomationLevel = value;
    }
    resetProactiveHaAutomationLevel() {
        this._proactiveHaAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaAutomationLevelInput() {
        return this._proactiveHaAutomationLevel;
    }
    get proactiveHaEnabled() {
        return this.getBooleanAttribute('proactive_ha_enabled');
    }
    set proactiveHaEnabled(value) {
        this._proactiveHaEnabled = value;
    }
    resetProactiveHaEnabled() {
        this._proactiveHaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaEnabledInput() {
        return this._proactiveHaEnabled;
    }
    get proactiveHaModerateRemediation() {
        return this.getStringAttribute('proactive_ha_moderate_remediation');
    }
    set proactiveHaModerateRemediation(value) {
        this._proactiveHaModerateRemediation = value;
    }
    resetProactiveHaModerateRemediation() {
        this._proactiveHaModerateRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaModerateRemediationInput() {
        return this._proactiveHaModerateRemediation;
    }
    get proactiveHaProviderIds() {
        return cdktf.Fn.tolist(this.getListAttribute('proactive_ha_provider_ids'));
    }
    set proactiveHaProviderIds(value) {
        this._proactiveHaProviderIds = value;
    }
    resetProactiveHaProviderIds() {
        this._proactiveHaProviderIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaProviderIdsInput() {
        return this._proactiveHaProviderIds;
    }
    get proactiveHaSevereRemediation() {
        return this.getStringAttribute('proactive_ha_severe_remediation');
    }
    set proactiveHaSevereRemediation(value) {
        this._proactiveHaSevereRemediation = value;
    }
    resetProactiveHaSevereRemediation() {
        this._proactiveHaSevereRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaSevereRemediationInput() {
        return this._proactiveHaSevereRemediation;
    }
    // resource_pool_id - computed: true, optional: false, required: false
    get resourcePoolId() {
        return this.getStringAttribute('resource_pool_id');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get vsanCompressionEnabled() {
        return this.getBooleanAttribute('vsan_compression_enabled');
    }
    set vsanCompressionEnabled(value) {
        this._vsanCompressionEnabled = value;
    }
    resetVsanCompressionEnabled() {
        this._vsanCompressionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanCompressionEnabledInput() {
        return this._vsanCompressionEnabled;
    }
    get vsanDedupEnabled() {
        return this.getBooleanAttribute('vsan_dedup_enabled');
    }
    set vsanDedupEnabled(value) {
        this._vsanDedupEnabled = value;
    }
    resetVsanDedupEnabled() {
        this._vsanDedupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDedupEnabledInput() {
        return this._vsanDedupEnabled;
    }
    get vsanDitEncryptionEnabled() {
        return this.getBooleanAttribute('vsan_dit_encryption_enabled');
    }
    set vsanDitEncryptionEnabled(value) {
        this._vsanDitEncryptionEnabled = value;
    }
    resetVsanDitEncryptionEnabled() {
        this._vsanDitEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitEncryptionEnabledInput() {
        return this._vsanDitEncryptionEnabled;
    }
    get vsanDitRekeyInterval() {
        return this.getNumberAttribute('vsan_dit_rekey_interval');
    }
    set vsanDitRekeyInterval(value) {
        this._vsanDitRekeyInterval = value;
    }
    resetVsanDitRekeyInterval() {
        this._vsanDitRekeyInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitRekeyIntervalInput() {
        return this._vsanDitRekeyInterval;
    }
    get vsanEnabled() {
        return this.getBooleanAttribute('vsan_enabled');
    }
    set vsanEnabled(value) {
        this._vsanEnabled = value;
    }
    resetVsanEnabled() {
        this._vsanEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEnabledInput() {
        return this._vsanEnabled;
    }
    get vsanEsaEnabled() {
        return this.getBooleanAttribute('vsan_esa_enabled');
    }
    set vsanEsaEnabled(value) {
        this._vsanEsaEnabled = value;
    }
    resetVsanEsaEnabled() {
        this._vsanEsaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEsaEnabledInput() {
        return this._vsanEsaEnabled;
    }
    get vsanNetworkDiagnosticModeEnabled() {
        return this.getBooleanAttribute('vsan_network_diagnostic_mode_enabled');
    }
    set vsanNetworkDiagnosticModeEnabled(value) {
        this._vsanNetworkDiagnosticModeEnabled = value;
    }
    resetVsanNetworkDiagnosticModeEnabled() {
        this._vsanNetworkDiagnosticModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanNetworkDiagnosticModeEnabledInput() {
        return this._vsanNetworkDiagnosticModeEnabled;
    }
    get vsanPerformanceEnabled() {
        return this.getBooleanAttribute('vsan_performance_enabled');
    }
    set vsanPerformanceEnabled(value) {
        this._vsanPerformanceEnabled = value;
    }
    resetVsanPerformanceEnabled() {
        this._vsanPerformanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanPerformanceEnabledInput() {
        return this._vsanPerformanceEnabled;
    }
    get vsanRemoteDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('vsan_remote_datastore_ids'));
    }
    set vsanRemoteDatastoreIds(value) {
        this._vsanRemoteDatastoreIds = value;
    }
    resetVsanRemoteDatastoreIds() {
        this._vsanRemoteDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanRemoteDatastoreIdsInput() {
        return this._vsanRemoteDatastoreIds;
    }
    get vsanUnmapEnabled() {
        return this.getBooleanAttribute('vsan_unmap_enabled');
    }
    set vsanUnmapEnabled(value) {
        this._vsanUnmapEnabled = value;
    }
    resetVsanUnmapEnabled() {
        this._vsanUnmapEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanUnmapEnabledInput() {
        return this._vsanUnmapEnabled;
    }
    get vsanVerboseModeEnabled() {
        return this.getBooleanAttribute('vsan_verbose_mode_enabled');
    }
    set vsanVerboseModeEnabled(value) {
        this._vsanVerboseModeEnabled = value;
    }
    resetVsanVerboseModeEnabled() {
        this._vsanVerboseModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanVerboseModeEnabledInput() {
        return this._vsanVerboseModeEnabled;
    }
    get hostImage() {
        return this._hostImage;
    }
    putHostImage(value) {
        this._hostImage.internalValue = value;
    }
    resetHostImage() {
        this._hostImage.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostImageInput() {
        return this._hostImage.internalValue;
    }
    get vsanDiskGroup() {
        return this._vsanDiskGroup;
    }
    putVsanDiskGroup(value) {
        this._vsanDiskGroup.internalValue = value;
    }
    resetVsanDiskGroup() {
        this._vsanDiskGroup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDiskGroupInput() {
        return this._vsanDiskGroup.internalValue;
    }
    get vsanFaultDomains() {
        return this._vsanFaultDomains;
    }
    putVsanFaultDomains(value) {
        this._vsanFaultDomains.internalValue = value;
    }
    resetVsanFaultDomains() {
        this._vsanFaultDomains.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanFaultDomainsInput() {
        return this._vsanFaultDomains.internalValue;
    }
    get vsanStretchedCluster() {
        return this._vsanStretchedCluster;
    }
    putVsanStretchedCluster(value) {
        this._vsanStretchedCluster.internalValue = value;
    }
    resetVsanStretchedCluster() {
        this._vsanStretchedCluster.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanStretchedClusterInput() {
        return this._vsanStretchedCluster.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            dpm_automation_level: cdktf.stringToTerraform(this._dpmAutomationLevel),
            dpm_enabled: cdktf.booleanToTerraform(this._dpmEnabled),
            dpm_threshold: cdktf.numberToTerraform(this._dpmThreshold),
            drs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._drsAdvancedOptions),
            drs_automation_level: cdktf.stringToTerraform(this._drsAutomationLevel),
            drs_enable_predictive_drs: cdktf.booleanToTerraform(this._drsEnablePredictiveDrs),
            drs_enable_vm_overrides: cdktf.booleanToTerraform(this._drsEnableVmOverrides),
            drs_enabled: cdktf.booleanToTerraform(this._drsEnabled),
            drs_migration_threshold: cdktf.numberToTerraform(this._drsMigrationThreshold),
            drs_scale_descendants_shares: cdktf.stringToTerraform(this._drsScaleDescendantsShares),
            folder: cdktf.stringToTerraform(this._folder),
            force_evacuate_on_destroy: cdktf.booleanToTerraform(this._forceEvacuateOnDestroy),
            ha_admission_control_failover_host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
            ha_admission_control_host_failure_tolerance: cdktf.numberToTerraform(this._haAdmissionControlHostFailureTolerance),
            ha_admission_control_performance_tolerance: cdktf.numberToTerraform(this._haAdmissionControlPerformanceTolerance),
            ha_admission_control_policy: cdktf.stringToTerraform(this._haAdmissionControlPolicy),
            ha_admission_control_resource_percentage_auto_compute: cdktf.booleanToTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
            ha_admission_control_resource_percentage_cpu: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageCpu),
            ha_admission_control_resource_percentage_memory: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageMemory),
            ha_admission_control_slot_policy_explicit_cpu: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
            ha_admission_control_slot_policy_explicit_memory: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
            ha_admission_control_slot_policy_use_explicit_size: cdktf.booleanToTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
            ha_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._haAdvancedOptions),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_enabled: cdktf.booleanToTerraform(this._haEnabled),
            ha_heartbeat_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haHeartbeatDatastoreIds),
            ha_heartbeat_datastore_policy: cdktf.stringToTerraform(this._haHeartbeatDatastorePolicy),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_host_monitoring: cdktf.stringToTerraform(this._haHostMonitoring),
            ha_vm_component_protection: cdktf.stringToTerraform(this._haVmComponentProtection),
            ha_vm_dependency_restart_condition: cdktf.stringToTerraform(this._haVmDependencyRestartCondition),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_restart_additional_delay: cdktf.numberToTerraform(this._haVmRestartAdditionalDelay),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            host_cluster_exit_timeout: cdktf.numberToTerraform(this._hostClusterExitTimeout),
            host_managed: cdktf.booleanToTerraform(this._hostManaged),
            host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._hostSystemIds),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            proactive_ha_automation_level: cdktf.stringToTerraform(this._proactiveHaAutomationLevel),
            proactive_ha_enabled: cdktf.booleanToTerraform(this._proactiveHaEnabled),
            proactive_ha_moderate_remediation: cdktf.stringToTerraform(this._proactiveHaModerateRemediation),
            proactive_ha_provider_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._proactiveHaProviderIds),
            proactive_ha_severe_remediation: cdktf.stringToTerraform(this._proactiveHaSevereRemediation),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            vsan_compression_enabled: cdktf.booleanToTerraform(this._vsanCompressionEnabled),
            vsan_dedup_enabled: cdktf.booleanToTerraform(this._vsanDedupEnabled),
            vsan_dit_encryption_enabled: cdktf.booleanToTerraform(this._vsanDitEncryptionEnabled),
            vsan_dit_rekey_interval: cdktf.numberToTerraform(this._vsanDitRekeyInterval),
            vsan_enabled: cdktf.booleanToTerraform(this._vsanEnabled),
            vsan_esa_enabled: cdktf.booleanToTerraform(this._vsanEsaEnabled),
            vsan_network_diagnostic_mode_enabled: cdktf.booleanToTerraform(this._vsanNetworkDiagnosticModeEnabled),
            vsan_performance_enabled: cdktf.booleanToTerraform(this._vsanPerformanceEnabled),
            vsan_remote_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._vsanRemoteDatastoreIds),
            vsan_unmap_enabled: cdktf.booleanToTerraform(this._vsanUnmapEnabled),
            vsan_verbose_mode_enabled: cdktf.booleanToTerraform(this._vsanVerboseModeEnabled),
            host_image: computeClusterHostImageToTerraform(this._hostImage.internalValue),
            vsan_disk_group: cdktf.listMapper(computeClusterVsanDiskGroupToTerraform, true)(this._vsanDiskGroup.internalValue),
            vsan_fault_domains: cdktf.listMapper(computeClusterVsanFaultDomainsToTerraform, true)(this._vsanFaultDomains.internalValue),
            vsan_stretched_cluster: computeClusterVsanStretchedClusterToTerraform(this._vsanStretchedCluster.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_automation_level: {
                value: cdktf.stringToHclTerraform(this._dpmAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_enabled: {
                value: cdktf.booleanToHclTerraform(this._dpmEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            dpm_threshold: {
                value: cdktf.numberToHclTerraform(this._dpmThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._drsAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            drs_automation_level: {
                value: cdktf.stringToHclTerraform(this._drsAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            drs_enable_predictive_drs: {
                value: cdktf.booleanToHclTerraform(this._drsEnablePredictiveDrs),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enable_vm_overrides: {
                value: cdktf.booleanToHclTerraform(this._drsEnableVmOverrides),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enabled: {
                value: cdktf.booleanToHclTerraform(this._drsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_migration_threshold: {
                value: cdktf.numberToHclTerraform(this._drsMigrationThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_scale_descendants_shares: {
                value: cdktf.stringToHclTerraform(this._drsScaleDescendantsShares),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            force_evacuate_on_destroy: {
                value: cdktf.booleanToHclTerraform(this._forceEvacuateOnDestroy),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_failover_host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_admission_control_host_failure_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlHostFailureTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_performance_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlPerformanceTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_policy: {
                value: cdktf.stringToHclTerraform(this._haAdmissionControlPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_admission_control_resource_percentage_auto_compute: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_resource_percentage_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_resource_percentage_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_use_explicit_size: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._haAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            ha_datastore_apd_recovery_action: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdRecoveryAction),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response_delay: {
                value: cdktf.numberToHclTerraform(this._haDatastoreApdResponseDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_datastore_pdl_response: {
                value: cdktf.stringToHclTerraform(this._haDatastorePdlResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._haEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_heartbeat_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haHeartbeatDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_heartbeat_datastore_policy: {
                value: cdktf.stringToHclTerraform(this._haHeartbeatDatastorePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_isolation_response: {
                value: cdktf.stringToHclTerraform(this._haHostIsolationResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_monitoring: {
                value: cdktf.stringToHclTerraform(this._haHostMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_component_protection: {
                value: cdktf.stringToHclTerraform(this._haVmComponentProtection),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_dependency_restart_condition: {
                value: cdktf.stringToHclTerraform(this._haVmDependencyRestartCondition),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_failure_interval: {
                value: cdktf.numberToHclTerraform(this._haVmFailureInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_failure_window: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumFailureWindow),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_resets: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumResets),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_minimum_uptime: {
                value: cdktf.numberToHclTerraform(this._haVmMinimumUptime),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_monitoring: {
                value: cdktf.stringToHclTerraform(this._haVmMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_additional_delay: {
                value: cdktf.numberToHclTerraform(this._haVmRestartAdditionalDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_restart_priority: {
                value: cdktf.stringToHclTerraform(this._haVmRestartPriority),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_timeout: {
                value: cdktf.numberToHclTerraform(this._haVmRestartTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_cluster_exit_timeout: {
                value: cdktf.numberToHclTerraform(this._hostClusterExitTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_managed: {
                value: cdktf.booleanToHclTerraform(this._hostManaged),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._hostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_automation_level: {
                value: cdktf.stringToHclTerraform(this._proactiveHaAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._proactiveHaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            proactive_ha_moderate_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaModerateRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_provider_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._proactiveHaProviderIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            proactive_ha_severe_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaSevereRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_compression_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanCompressionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dedup_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDedupEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_encryption_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDitEncryptionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_rekey_interval: {
                value: cdktf.numberToHclTerraform(this._vsanDitRekeyInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            vsan_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_esa_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEsaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_network_diagnostic_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanNetworkDiagnosticModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_performance_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanPerformanceEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_remote_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._vsanRemoteDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_unmap_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanUnmapEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_verbose_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanVerboseModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_image: {
                value: computeClusterHostImageToHclTerraform(this._hostImage.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterHostImageList",
            },
            vsan_disk_group: {
                value: cdktf.listMapperHcl(computeClusterVsanDiskGroupToHclTerraform, true)(this._vsanDiskGroup.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanDiskGroupList",
            },
            vsan_fault_domains: {
                value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsToHclTerraform, true)(this._vsanFaultDomains.internalValue),
                isBlock: true,
                type: "set",
                storageClassType: "ComputeClusterVsanFaultDomainsList",
            },
            vsan_stretched_cluster: {
                value: computeClusterVsanStretchedClusterToHclTerraform(this._vsanStretchedCluster.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanStretchedClusterList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ComputeCluster = ComputeCluster;
_l = JSII_RTTI_SYMBOL_1;
ComputeCluster[_l] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeCluster", version: "9.4.0" };
// =================
// STATIC PROPERTIES
// =================
ComputeCluster.tfResourceType = "vsphere_compute_cluster";
//# sourceMappingURL=data:application/json;base64,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