/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereComputeClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the datacenter the cluster is located in. Not required if using an absolute path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster#datacenter_id DataVsphereComputeCluster#datacenter_id}
    */
    readonly datacenterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster#id DataVsphereComputeCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or absolute path to the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster#name DataVsphereComputeCluster#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster vsphere_compute_cluster}
*/
export declare class DataVsphereComputeCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_compute_cluster";
    /**
    * Generates CDKTF code for importing a DataVsphereComputeCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereComputeCluster to import
    * @param importFromId The id of the existing DataVsphereComputeCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereComputeCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/compute_cluster vsphere_compute_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereComputeClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereComputeClusterConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    resetDatacenterId(): void;
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourcePoolId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
