"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVsphereVirtualMachine = exports.DataVsphereVirtualMachineVappOutputReference = exports.dataVsphereVirtualMachineVappToHclTerraform = exports.dataVsphereVirtualMachineVappToTerraform = exports.DataVsphereVirtualMachineNetworkInterfacesList = exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = exports.dataVsphereVirtualMachineNetworkInterfacesToHclTerraform = exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = exports.DataVsphereVirtualMachineDisksList = exports.DataVsphereVirtualMachineDisksOutputReference = exports.dataVsphereVirtualMachineDisksToHclTerraform = exports.dataVsphereVirtualMachineDisksToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dataVsphereVirtualMachineDisksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineDisksToTerraform = dataVsphereVirtualMachineDisksToTerraform;
function dataVsphereVirtualMachineDisksToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
exports.dataVsphereVirtualMachineDisksToHclTerraform = dataVsphereVirtualMachineDisksToHclTerraform;
class DataVsphereVirtualMachineDisksOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // eagerly_scrub - computed: true, optional: false, required: false
    get eagerlyScrub() {
        return this.getBooleanAttribute('eagerly_scrub');
    }
    // label - computed: true, optional: false, required: false
    get label() {
        return this.getStringAttribute('label');
    }
    // size - computed: true, optional: false, required: false
    get size() {
        return this.getNumberAttribute('size');
    }
    // thin_provisioned - computed: true, optional: false, required: false
    get thinProvisioned() {
        return this.getBooleanAttribute('thin_provisioned');
    }
    // unit_number - computed: true, optional: false, required: false
    get unitNumber() {
        return this.getNumberAttribute('unit_number');
    }
}
exports.DataVsphereVirtualMachineDisksOutputReference = DataVsphereVirtualMachineDisksOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksOutputReference", version: "9.4.0" };
class DataVsphereVirtualMachineDisksList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineDisksOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineDisksList = DataVsphereVirtualMachineDisksList;
_b = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksList[_b] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksList", version: "9.4.0" };
function dataVsphereVirtualMachineNetworkInterfacesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = dataVsphereVirtualMachineNetworkInterfacesToTerraform;
function dataVsphereVirtualMachineNetworkInterfacesToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
exports.dataVsphereVirtualMachineNetworkInterfacesToHclTerraform = dataVsphereVirtualMachineNetworkInterfacesToHclTerraform;
class DataVsphereVirtualMachineNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // adapter_type - computed: true, optional: false, required: false
    get adapterType() {
        return this.getStringAttribute('adapter_type');
    }
    // bandwidth_limit - computed: true, optional: false, required: false
    get bandwidthLimit() {
        return this.getNumberAttribute('bandwidth_limit');
    }
    // bandwidth_reservation - computed: true, optional: false, required: false
    get bandwidthReservation() {
        return this.getNumberAttribute('bandwidth_reservation');
    }
    // bandwidth_share_count - computed: true, optional: false, required: false
    get bandwidthShareCount() {
        return this.getNumberAttribute('bandwidth_share_count');
    }
    // bandwidth_share_level - computed: true, optional: false, required: false
    get bandwidthShareLevel() {
        return this.getStringAttribute('bandwidth_share_level');
    }
    // mac_address - computed: true, optional: false, required: false
    get macAddress() {
        return this.getStringAttribute('mac_address');
    }
    // network_id - computed: true, optional: false, required: false
    get networkId() {
        return this.getStringAttribute('network_id');
    }
    // physical_function - computed: true, optional: false, required: false
    get physicalFunction() {
        return this.getStringAttribute('physical_function');
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = DataVsphereVirtualMachineNetworkInterfacesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesOutputReference", version: "9.4.0" };
class DataVsphereVirtualMachineNetworkInterfacesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineNetworkInterfacesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesList = DataVsphereVirtualMachineNetworkInterfacesList;
_d = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesList[_d] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesList", version: "9.4.0" };
function dataVsphereVirtualMachineVappToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        properties: cdktf.hashMapper(cdktf.stringToTerraform)(struct.properties),
    };
}
exports.dataVsphereVirtualMachineVappToTerraform = dataVsphereVirtualMachineVappToTerraform;
function dataVsphereVirtualMachineVappToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        properties: {
            value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(struct.properties),
            isBlock: false,
            type: "map",
            storageClassType: "stringMap",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.dataVsphereVirtualMachineVappToHclTerraform = dataVsphereVirtualMachineVappToHclTerraform;
class DataVsphereVirtualMachineVappOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._properties !== undefined) {
            hasAnyValues = true;
            internalValueResult.properties = this._properties;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._properties = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._properties = value.properties;
        }
    }
    get properties() {
        return this.getStringMapAttribute('properties');
    }
    set properties(value) {
        this._properties = value;
    }
    resetProperties() {
        this._properties = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties;
    }
}
exports.DataVsphereVirtualMachineVappOutputReference = DataVsphereVirtualMachineVappOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineVappOutputReference[_e] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineVappOutputReference", version: "9.4.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/virtual_machine vsphere_virtual_machine}
*/
class DataVsphereVirtualMachine extends cdktf.TerraformDataSource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DataVsphereVirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereVirtualMachine to import
    * @param importFromId The id of the existing DataVsphereVirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereVirtualMachine to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_virtual_machine", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/data-sources/virtual_machine vsphere_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVirtualMachineConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vsphere_virtual_machine',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.10.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // disks - computed: true, optional: false, required: false
        this._disks = new DataVsphereVirtualMachineDisksList(this, "disks", false);
        // network_interfaces - computed: true, optional: false, required: false
        this._networkInterfaces = new DataVsphereVirtualMachineNetworkInterfacesList(this, "network_interfaces", false);
        // vapp - computed: false, optional: true, required: false
        this._vapp = new DataVsphereVirtualMachineVappOutputReference(this, "vapp");
        this._alternateGuestName = config.alternateGuestName;
        this._annotation = config.annotation;
        this._bootDelay = config.bootDelay;
        this._bootRetryDelay = config.bootRetryDelay;
        this._bootRetryEnabled = config.bootRetryEnabled;
        this._cpuHotAddEnabled = config.cpuHotAddEnabled;
        this._cpuHotRemoveEnabled = config.cpuHotRemoveEnabled;
        this._cpuLimit = config.cpuLimit;
        this._cpuPerformanceCountersEnabled = config.cpuPerformanceCountersEnabled;
        this._cpuReservation = config.cpuReservation;
        this._cpuShareCount = config.cpuShareCount;
        this._cpuShareLevel = config.cpuShareLevel;
        this._datacenterId = config.datacenterId;
        this._efiSecureBootEnabled = config.efiSecureBootEnabled;
        this._enableDiskUuid = config.enableDiskUuid;
        this._enableLogging = config.enableLogging;
        this._eptRviMode = config.eptRviMode;
        this._extraConfig = config.extraConfig;
        this._extraConfigRebootRequired = config.extraConfigRebootRequired;
        this._firmware = config.firmware;
        this._folder = config.folder;
        this._guestId = config.guestId;
        this._hardwareVersion = config.hardwareVersion;
        this._hvMode = config.hvMode;
        this._id = config.id;
        this._ideControllerScanCount = config.ideControllerScanCount;
        this._latencySensitivity = config.latencySensitivity;
        this._memory = config.memory;
        this._memoryHotAddEnabled = config.memoryHotAddEnabled;
        this._memoryLimit = config.memoryLimit;
        this._memoryReservation = config.memoryReservation;
        this._memoryReservationLockedToMax = config.memoryReservationLockedToMax;
        this._memoryShareCount = config.memoryShareCount;
        this._memoryShareLevel = config.memoryShareLevel;
        this._moid = config.moid;
        this._name = config.name;
        this._nestedHvEnabled = config.nestedHvEnabled;
        this._numCoresPerSocket = config.numCoresPerSocket;
        this._numCpus = config.numCpus;
        this._replaceTrigger = config.replaceTrigger;
        this._runToolsScriptsAfterPowerOn = config.runToolsScriptsAfterPowerOn;
        this._runToolsScriptsAfterResume = config.runToolsScriptsAfterResume;
        this._runToolsScriptsBeforeGuestReboot = config.runToolsScriptsBeforeGuestReboot;
        this._runToolsScriptsBeforeGuestShutdown = config.runToolsScriptsBeforeGuestShutdown;
        this._runToolsScriptsBeforeGuestStandby = config.runToolsScriptsBeforeGuestStandby;
        this._sataControllerScanCount = config.sataControllerScanCount;
        this._scsiControllerScanCount = config.scsiControllerScanCount;
        this._storagePolicyId = config.storagePolicyId;
        this._swapPlacementPolicy = config.swapPlacementPolicy;
        this._syncTimeWithHost = config.syncTimeWithHost;
        this._syncTimeWithHostPeriodically = config.syncTimeWithHostPeriodically;
        this._toolsUpgradePolicy = config.toolsUpgradePolicy;
        this._uuid = config.uuid;
        this._vbsEnabled = config.vbsEnabled;
        this._vvtdEnabled = config.vvtdEnabled;
        this._vapp.internalValue = config.vapp;
    }
    get alternateGuestName() {
        return this.getStringAttribute('alternate_guest_name');
    }
    set alternateGuestName(value) {
        this._alternateGuestName = value;
    }
    resetAlternateGuestName() {
        this._alternateGuestName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alternateGuestNameInput() {
        return this._alternateGuestName;
    }
    get annotation() {
        return this.getStringAttribute('annotation');
    }
    set annotation(value) {
        this._annotation = value;
    }
    resetAnnotation() {
        this._annotation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get annotationInput() {
        return this._annotation;
    }
    get bootDelay() {
        return this.getNumberAttribute('boot_delay');
    }
    set bootDelay(value) {
        this._bootDelay = value;
    }
    resetBootDelay() {
        this._bootDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootDelayInput() {
        return this._bootDelay;
    }
    get bootRetryDelay() {
        return this.getNumberAttribute('boot_retry_delay');
    }
    set bootRetryDelay(value) {
        this._bootRetryDelay = value;
    }
    resetBootRetryDelay() {
        this._bootRetryDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryDelayInput() {
        return this._bootRetryDelay;
    }
    get bootRetryEnabled() {
        return this.getBooleanAttribute('boot_retry_enabled');
    }
    set bootRetryEnabled(value) {
        this._bootRetryEnabled = value;
    }
    resetBootRetryEnabled() {
        this._bootRetryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryEnabledInput() {
        return this._bootRetryEnabled;
    }
    // change_version - computed: true, optional: false, required: false
    get changeVersion() {
        return this.getStringAttribute('change_version');
    }
    get cpuHotAddEnabled() {
        return this.getBooleanAttribute('cpu_hot_add_enabled');
    }
    set cpuHotAddEnabled(value) {
        this._cpuHotAddEnabled = value;
    }
    resetCpuHotAddEnabled() {
        this._cpuHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotAddEnabledInput() {
        return this._cpuHotAddEnabled;
    }
    get cpuHotRemoveEnabled() {
        return this.getBooleanAttribute('cpu_hot_remove_enabled');
    }
    set cpuHotRemoveEnabled(value) {
        this._cpuHotRemoveEnabled = value;
    }
    resetCpuHotRemoveEnabled() {
        this._cpuHotRemoveEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotRemoveEnabledInput() {
        return this._cpuHotRemoveEnabled;
    }
    get cpuLimit() {
        return this.getNumberAttribute('cpu_limit');
    }
    set cpuLimit(value) {
        this._cpuLimit = value;
    }
    resetCpuLimit() {
        this._cpuLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuLimitInput() {
        return this._cpuLimit;
    }
    get cpuPerformanceCountersEnabled() {
        return this.getBooleanAttribute('cpu_performance_counters_enabled');
    }
    set cpuPerformanceCountersEnabled(value) {
        this._cpuPerformanceCountersEnabled = value;
    }
    resetCpuPerformanceCountersEnabled() {
        this._cpuPerformanceCountersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerformanceCountersEnabledInput() {
        return this._cpuPerformanceCountersEnabled;
    }
    get cpuReservation() {
        return this.getNumberAttribute('cpu_reservation');
    }
    set cpuReservation(value) {
        this._cpuReservation = value;
    }
    resetCpuReservation() {
        this._cpuReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuReservationInput() {
        return this._cpuReservation;
    }
    get cpuShareCount() {
        return this.getNumberAttribute('cpu_share_count');
    }
    set cpuShareCount(value) {
        this._cpuShareCount = value;
    }
    resetCpuShareCount() {
        this._cpuShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareCountInput() {
        return this._cpuShareCount;
    }
    get cpuShareLevel() {
        return this.getStringAttribute('cpu_share_level');
    }
    set cpuShareLevel(value) {
        this._cpuShareLevel = value;
    }
    resetCpuShareLevel() {
        this._cpuShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareLevelInput() {
        return this._cpuShareLevel;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    resetDatacenterId() {
        this._datacenterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    // default_ip_address - computed: true, optional: false, required: false
    get defaultIpAddress() {
        return this.getStringAttribute('default_ip_address');
    }
    get disks() {
        return this._disks;
    }
    get efiSecureBootEnabled() {
        return this.getBooleanAttribute('efi_secure_boot_enabled');
    }
    set efiSecureBootEnabled(value) {
        this._efiSecureBootEnabled = value;
    }
    resetEfiSecureBootEnabled() {
        this._efiSecureBootEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get efiSecureBootEnabledInput() {
        return this._efiSecureBootEnabled;
    }
    get enableDiskUuid() {
        return this.getBooleanAttribute('enable_disk_uuid');
    }
    set enableDiskUuid(value) {
        this._enableDiskUuid = value;
    }
    resetEnableDiskUuid() {
        this._enableDiskUuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDiskUuidInput() {
        return this._enableDiskUuid;
    }
    get enableLogging() {
        return this.getBooleanAttribute('enable_logging');
    }
    set enableLogging(value) {
        this._enableLogging = value;
    }
    resetEnableLogging() {
        this._enableLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableLoggingInput() {
        return this._enableLogging;
    }
    get eptRviMode() {
        return this.getStringAttribute('ept_rvi_mode');
    }
    set eptRviMode(value) {
        this._eptRviMode = value;
    }
    resetEptRviMode() {
        this._eptRviMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eptRviModeInput() {
        return this._eptRviMode;
    }
    get extraConfig() {
        return this.getStringMapAttribute('extra_config');
    }
    set extraConfig(value) {
        this._extraConfig = value;
    }
    resetExtraConfig() {
        this._extraConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigInput() {
        return this._extraConfig;
    }
    get extraConfigRebootRequired() {
        return this.getBooleanAttribute('extra_config_reboot_required');
    }
    set extraConfigRebootRequired(value) {
        this._extraConfigRebootRequired = value;
    }
    resetExtraConfigRebootRequired() {
        this._extraConfigRebootRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigRebootRequiredInput() {
        return this._extraConfigRebootRequired;
    }
    get firmware() {
        return this.getStringAttribute('firmware');
    }
    set firmware(value) {
        this._firmware = value;
    }
    resetFirmware() {
        this._firmware = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firmwareInput() {
        return this._firmware;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get guestId() {
        return this.getStringAttribute('guest_id');
    }
    set guestId(value) {
        this._guestId = value;
    }
    resetGuestId() {
        this._guestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get guestIdInput() {
        return this._guestId;
    }
    // guest_ip_addresses - computed: true, optional: false, required: false
    get guestIpAddresses() {
        return this.getListAttribute('guest_ip_addresses');
    }
    get hardwareVersion() {
        return this.getNumberAttribute('hardware_version');
    }
    set hardwareVersion(value) {
        this._hardwareVersion = value;
    }
    resetHardwareVersion() {
        this._hardwareVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hardwareVersionInput() {
        return this._hardwareVersion;
    }
    get hvMode() {
        return this.getStringAttribute('hv_mode');
    }
    set hvMode(value) {
        this._hvMode = value;
    }
    resetHvMode() {
        this._hvMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hvModeInput() {
        return this._hvMode;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ideControllerScanCount() {
        return this.getNumberAttribute('ide_controller_scan_count');
    }
    set ideControllerScanCount(value) {
        this._ideControllerScanCount = value;
    }
    resetIdeControllerScanCount() {
        this._ideControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ideControllerScanCountInput() {
        return this._ideControllerScanCount;
    }
    // instance_uuid - computed: true, optional: false, required: false
    get instanceUuid() {
        return this.getStringAttribute('instance_uuid');
    }
    get latencySensitivity() {
        return this.getStringAttribute('latency_sensitivity');
    }
    set latencySensitivity(value) {
        this._latencySensitivity = value;
    }
    resetLatencySensitivity() {
        this._latencySensitivity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get latencySensitivityInput() {
        return this._latencySensitivity;
    }
    get memory() {
        return this.getNumberAttribute('memory');
    }
    set memory(value) {
        this._memory = value;
    }
    resetMemory() {
        this._memory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryInput() {
        return this._memory;
    }
    get memoryHotAddEnabled() {
        return this.getBooleanAttribute('memory_hot_add_enabled');
    }
    set memoryHotAddEnabled(value) {
        this._memoryHotAddEnabled = value;
    }
    resetMemoryHotAddEnabled() {
        this._memoryHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryHotAddEnabledInput() {
        return this._memoryHotAddEnabled;
    }
    get memoryLimit() {
        return this.getNumberAttribute('memory_limit');
    }
    set memoryLimit(value) {
        this._memoryLimit = value;
    }
    resetMemoryLimit() {
        this._memoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryLimitInput() {
        return this._memoryLimit;
    }
    get memoryReservation() {
        return this.getNumberAttribute('memory_reservation');
    }
    set memoryReservation(value) {
        this._memoryReservation = value;
    }
    resetMemoryReservation() {
        this._memoryReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationInput() {
        return this._memoryReservation;
    }
    get memoryReservationLockedToMax() {
        return this.getBooleanAttribute('memory_reservation_locked_to_max');
    }
    set memoryReservationLockedToMax(value) {
        this._memoryReservationLockedToMax = value;
    }
    resetMemoryReservationLockedToMax() {
        this._memoryReservationLockedToMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationLockedToMaxInput() {
        return this._memoryReservationLockedToMax;
    }
    get memoryShareCount() {
        return this.getNumberAttribute('memory_share_count');
    }
    set memoryShareCount(value) {
        this._memoryShareCount = value;
    }
    resetMemoryShareCount() {
        this._memoryShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareCountInput() {
        return this._memoryShareCount;
    }
    get memoryShareLevel() {
        return this.getStringAttribute('memory_share_level');
    }
    set memoryShareLevel(value) {
        this._memoryShareLevel = value;
    }
    resetMemoryShareLevel() {
        this._memoryShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareLevelInput() {
        return this._memoryShareLevel;
    }
    get moid() {
        return this.getStringAttribute('moid');
    }
    set moid(value) {
        this._moid = value;
    }
    resetMoid() {
        this._moid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get moidInput() {
        return this._moid;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nestedHvEnabled() {
        return this.getBooleanAttribute('nested_hv_enabled');
    }
    set nestedHvEnabled(value) {
        this._nestedHvEnabled = value;
    }
    resetNestedHvEnabled() {
        this._nestedHvEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nestedHvEnabledInput() {
        return this._nestedHvEnabled;
    }
    // network_interface_types - computed: true, optional: false, required: false
    get networkInterfaceTypes() {
        return this.getListAttribute('network_interface_types');
    }
    get networkInterfaces() {
        return this._networkInterfaces;
    }
    get numCoresPerSocket() {
        return this.getNumberAttribute('num_cores_per_socket');
    }
    set numCoresPerSocket(value) {
        this._numCoresPerSocket = value;
    }
    resetNumCoresPerSocket() {
        this._numCoresPerSocket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCoresPerSocketInput() {
        return this._numCoresPerSocket;
    }
    get numCpus() {
        return this.getNumberAttribute('num_cpus');
    }
    set numCpus(value) {
        this._numCpus = value;
    }
    resetNumCpus() {
        this._numCpus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCpusInput() {
        return this._numCpus;
    }
    get replaceTrigger() {
        return this.getStringAttribute('replace_trigger');
    }
    set replaceTrigger(value) {
        this._replaceTrigger = value;
    }
    resetReplaceTrigger() {
        this._replaceTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceTriggerInput() {
        return this._replaceTrigger;
    }
    get runToolsScriptsAfterPowerOn() {
        return this.getBooleanAttribute('run_tools_scripts_after_power_on');
    }
    set runToolsScriptsAfterPowerOn(value) {
        this._runToolsScriptsAfterPowerOn = value;
    }
    resetRunToolsScriptsAfterPowerOn() {
        this._runToolsScriptsAfterPowerOn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterPowerOnInput() {
        return this._runToolsScriptsAfterPowerOn;
    }
    get runToolsScriptsAfterResume() {
        return this.getBooleanAttribute('run_tools_scripts_after_resume');
    }
    set runToolsScriptsAfterResume(value) {
        this._runToolsScriptsAfterResume = value;
    }
    resetRunToolsScriptsAfterResume() {
        this._runToolsScriptsAfterResume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterResumeInput() {
        return this._runToolsScriptsAfterResume;
    }
    get runToolsScriptsBeforeGuestReboot() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_reboot');
    }
    set runToolsScriptsBeforeGuestReboot(value) {
        this._runToolsScriptsBeforeGuestReboot = value;
    }
    resetRunToolsScriptsBeforeGuestReboot() {
        this._runToolsScriptsBeforeGuestReboot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestRebootInput() {
        return this._runToolsScriptsBeforeGuestReboot;
    }
    get runToolsScriptsBeforeGuestShutdown() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_shutdown');
    }
    set runToolsScriptsBeforeGuestShutdown(value) {
        this._runToolsScriptsBeforeGuestShutdown = value;
    }
    resetRunToolsScriptsBeforeGuestShutdown() {
        this._runToolsScriptsBeforeGuestShutdown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestShutdownInput() {
        return this._runToolsScriptsBeforeGuestShutdown;
    }
    get runToolsScriptsBeforeGuestStandby() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_standby');
    }
    set runToolsScriptsBeforeGuestStandby(value) {
        this._runToolsScriptsBeforeGuestStandby = value;
    }
    resetRunToolsScriptsBeforeGuestStandby() {
        this._runToolsScriptsBeforeGuestStandby = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestStandbyInput() {
        return this._runToolsScriptsBeforeGuestStandby;
    }
    get sataControllerScanCount() {
        return this.getNumberAttribute('sata_controller_scan_count');
    }
    set sataControllerScanCount(value) {
        this._sataControllerScanCount = value;
    }
    resetSataControllerScanCount() {
        this._sataControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sataControllerScanCountInput() {
        return this._sataControllerScanCount;
    }
    // scsi_bus_sharing - computed: true, optional: false, required: false
    get scsiBusSharing() {
        return this.getStringAttribute('scsi_bus_sharing');
    }
    get scsiControllerScanCount() {
        return this.getNumberAttribute('scsi_controller_scan_count');
    }
    set scsiControllerScanCount(value) {
        this._scsiControllerScanCount = value;
    }
    resetScsiControllerScanCount() {
        this._scsiControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scsiControllerScanCountInput() {
        return this._scsiControllerScanCount;
    }
    // scsi_type - computed: true, optional: false, required: false
    get scsiType() {
        return this.getStringAttribute('scsi_type');
    }
    get storagePolicyId() {
        return this.getStringAttribute('storage_policy_id');
    }
    set storagePolicyId(value) {
        this._storagePolicyId = value;
    }
    resetStoragePolicyId() {
        this._storagePolicyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storagePolicyIdInput() {
        return this._storagePolicyId;
    }
    get swapPlacementPolicy() {
        return this.getStringAttribute('swap_placement_policy');
    }
    set swapPlacementPolicy(value) {
        this._swapPlacementPolicy = value;
    }
    resetSwapPlacementPolicy() {
        this._swapPlacementPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapPlacementPolicyInput() {
        return this._swapPlacementPolicy;
    }
    get syncTimeWithHost() {
        return this.getBooleanAttribute('sync_time_with_host');
    }
    set syncTimeWithHost(value) {
        this._syncTimeWithHost = value;
    }
    resetSyncTimeWithHost() {
        this._syncTimeWithHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostInput() {
        return this._syncTimeWithHost;
    }
    get syncTimeWithHostPeriodically() {
        return this.getBooleanAttribute('sync_time_with_host_periodically');
    }
    set syncTimeWithHostPeriodically(value) {
        this._syncTimeWithHostPeriodically = value;
    }
    resetSyncTimeWithHostPeriodically() {
        this._syncTimeWithHostPeriodically = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostPeriodicallyInput() {
        return this._syncTimeWithHostPeriodically;
    }
    get toolsUpgradePolicy() {
        return this.getStringAttribute('tools_upgrade_policy');
    }
    set toolsUpgradePolicy(value) {
        this._toolsUpgradePolicy = value;
    }
    resetToolsUpgradePolicy() {
        this._toolsUpgradePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get toolsUpgradePolicyInput() {
        return this._toolsUpgradePolicy;
    }
    get uuid() {
        return this.getStringAttribute('uuid');
    }
    set uuid(value) {
        this._uuid = value;
    }
    resetUuid() {
        this._uuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uuidInput() {
        return this._uuid;
    }
    // vapp_transport - computed: true, optional: false, required: false
    get vappTransport() {
        return this.getListAttribute('vapp_transport');
    }
    get vbsEnabled() {
        return this.getBooleanAttribute('vbs_enabled');
    }
    set vbsEnabled(value) {
        this._vbsEnabled = value;
    }
    resetVbsEnabled() {
        this._vbsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vbsEnabledInput() {
        return this._vbsEnabled;
    }
    // vtpm - computed: true, optional: false, required: false
    get vtpm() {
        return this.getBooleanAttribute('vtpm');
    }
    get vvtdEnabled() {
        return this.getBooleanAttribute('vvtd_enabled');
    }
    set vvtdEnabled(value) {
        this._vvtdEnabled = value;
    }
    resetVvtdEnabled() {
        this._vvtdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vvtdEnabledInput() {
        return this._vvtdEnabled;
    }
    get vapp() {
        return this._vapp;
    }
    putVapp(value) {
        this._vapp.internalValue = value;
    }
    resetVapp() {
        this._vapp.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vappInput() {
        return this._vapp.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alternate_guest_name: cdktf.stringToTerraform(this._alternateGuestName),
            annotation: cdktf.stringToTerraform(this._annotation),
            boot_delay: cdktf.numberToTerraform(this._bootDelay),
            boot_retry_delay: cdktf.numberToTerraform(this._bootRetryDelay),
            boot_retry_enabled: cdktf.booleanToTerraform(this._bootRetryEnabled),
            cpu_hot_add_enabled: cdktf.booleanToTerraform(this._cpuHotAddEnabled),
            cpu_hot_remove_enabled: cdktf.booleanToTerraform(this._cpuHotRemoveEnabled),
            cpu_limit: cdktf.numberToTerraform(this._cpuLimit),
            cpu_performance_counters_enabled: cdktf.booleanToTerraform(this._cpuPerformanceCountersEnabled),
            cpu_reservation: cdktf.numberToTerraform(this._cpuReservation),
            cpu_share_count: cdktf.numberToTerraform(this._cpuShareCount),
            cpu_share_level: cdktf.stringToTerraform(this._cpuShareLevel),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            efi_secure_boot_enabled: cdktf.booleanToTerraform(this._efiSecureBootEnabled),
            enable_disk_uuid: cdktf.booleanToTerraform(this._enableDiskUuid),
            enable_logging: cdktf.booleanToTerraform(this._enableLogging),
            ept_rvi_mode: cdktf.stringToTerraform(this._eptRviMode),
            extra_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._extraConfig),
            extra_config_reboot_required: cdktf.booleanToTerraform(this._extraConfigRebootRequired),
            firmware: cdktf.stringToTerraform(this._firmware),
            folder: cdktf.stringToTerraform(this._folder),
            guest_id: cdktf.stringToTerraform(this._guestId),
            hardware_version: cdktf.numberToTerraform(this._hardwareVersion),
            hv_mode: cdktf.stringToTerraform(this._hvMode),
            id: cdktf.stringToTerraform(this._id),
            ide_controller_scan_count: cdktf.numberToTerraform(this._ideControllerScanCount),
            latency_sensitivity: cdktf.stringToTerraform(this._latencySensitivity),
            memory: cdktf.numberToTerraform(this._memory),
            memory_hot_add_enabled: cdktf.booleanToTerraform(this._memoryHotAddEnabled),
            memory_limit: cdktf.numberToTerraform(this._memoryLimit),
            memory_reservation: cdktf.numberToTerraform(this._memoryReservation),
            memory_reservation_locked_to_max: cdktf.booleanToTerraform(this._memoryReservationLockedToMax),
            memory_share_count: cdktf.numberToTerraform(this._memoryShareCount),
            memory_share_level: cdktf.stringToTerraform(this._memoryShareLevel),
            moid: cdktf.stringToTerraform(this._moid),
            name: cdktf.stringToTerraform(this._name),
            nested_hv_enabled: cdktf.booleanToTerraform(this._nestedHvEnabled),
            num_cores_per_socket: cdktf.numberToTerraform(this._numCoresPerSocket),
            num_cpus: cdktf.numberToTerraform(this._numCpus),
            replace_trigger: cdktf.stringToTerraform(this._replaceTrigger),
            run_tools_scripts_after_power_on: cdktf.booleanToTerraform(this._runToolsScriptsAfterPowerOn),
            run_tools_scripts_after_resume: cdktf.booleanToTerraform(this._runToolsScriptsAfterResume),
            run_tools_scripts_before_guest_reboot: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestReboot),
            run_tools_scripts_before_guest_shutdown: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestShutdown),
            run_tools_scripts_before_guest_standby: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestStandby),
            sata_controller_scan_count: cdktf.numberToTerraform(this._sataControllerScanCount),
            scsi_controller_scan_count: cdktf.numberToTerraform(this._scsiControllerScanCount),
            storage_policy_id: cdktf.stringToTerraform(this._storagePolicyId),
            swap_placement_policy: cdktf.stringToTerraform(this._swapPlacementPolicy),
            sync_time_with_host: cdktf.booleanToTerraform(this._syncTimeWithHost),
            sync_time_with_host_periodically: cdktf.booleanToTerraform(this._syncTimeWithHostPeriodically),
            tools_upgrade_policy: cdktf.stringToTerraform(this._toolsUpgradePolicy),
            uuid: cdktf.stringToTerraform(this._uuid),
            vbs_enabled: cdktf.booleanToTerraform(this._vbsEnabled),
            vvtd_enabled: cdktf.booleanToTerraform(this._vvtdEnabled),
            vapp: dataVsphereVirtualMachineVappToTerraform(this._vapp.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            alternate_guest_name: {
                value: cdktf.stringToHclTerraform(this._alternateGuestName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            annotation: {
                value: cdktf.stringToHclTerraform(this._annotation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            boot_delay: {
                value: cdktf.numberToHclTerraform(this._bootDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            boot_retry_delay: {
                value: cdktf.numberToHclTerraform(this._bootRetryDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            boot_retry_enabled: {
                value: cdktf.booleanToHclTerraform(this._bootRetryEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_hot_add_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuHotAddEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_hot_remove_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuHotRemoveEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_limit: {
                value: cdktf.numberToHclTerraform(this._cpuLimit),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_performance_counters_enabled: {
                value: cdktf.booleanToHclTerraform(this._cpuPerformanceCountersEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cpu_reservation: {
                value: cdktf.numberToHclTerraform(this._cpuReservation),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_share_count: {
                value: cdktf.numberToHclTerraform(this._cpuShareCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            cpu_share_level: {
                value: cdktf.stringToHclTerraform(this._cpuShareLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            efi_secure_boot_enabled: {
                value: cdktf.booleanToHclTerraform(this._efiSecureBootEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_disk_uuid: {
                value: cdktf.booleanToHclTerraform(this._enableDiskUuid),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_logging: {
                value: cdktf.booleanToHclTerraform(this._enableLogging),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ept_rvi_mode: {
                value: cdktf.stringToHclTerraform(this._eptRviMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            extra_config: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._extraConfig),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            extra_config_reboot_required: {
                value: cdktf.booleanToHclTerraform(this._extraConfigRebootRequired),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            firmware: {
                value: cdktf.stringToHclTerraform(this._firmware),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            guest_id: {
                value: cdktf.stringToHclTerraform(this._guestId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            hardware_version: {
                value: cdktf.numberToHclTerraform(this._hardwareVersion),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            hv_mode: {
                value: cdktf.stringToHclTerraform(this._hvMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ide_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._ideControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            latency_sensitivity: {
                value: cdktf.stringToHclTerraform(this._latencySensitivity),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            memory: {
                value: cdktf.numberToHclTerraform(this._memory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_hot_add_enabled: {
                value: cdktf.booleanToHclTerraform(this._memoryHotAddEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            memory_limit: {
                value: cdktf.numberToHclTerraform(this._memoryLimit),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_reservation: {
                value: cdktf.numberToHclTerraform(this._memoryReservation),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_reservation_locked_to_max: {
                value: cdktf.booleanToHclTerraform(this._memoryReservationLockedToMax),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            memory_share_count: {
                value: cdktf.numberToHclTerraform(this._memoryShareCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            memory_share_level: {
                value: cdktf.stringToHclTerraform(this._memoryShareLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            moid: {
                value: cdktf.stringToHclTerraform(this._moid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            nested_hv_enabled: {
                value: cdktf.booleanToHclTerraform(this._nestedHvEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            num_cores_per_socket: {
                value: cdktf.numberToHclTerraform(this._numCoresPerSocket),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            num_cpus: {
                value: cdktf.numberToHclTerraform(this._numCpus),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            replace_trigger: {
                value: cdktf.stringToHclTerraform(this._replaceTrigger),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            run_tools_scripts_after_power_on: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsAfterPowerOn),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_after_resume: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsAfterResume),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_reboot: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestReboot),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_shutdown: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestShutdown),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            run_tools_scripts_before_guest_standby: {
                value: cdktf.booleanToHclTerraform(this._runToolsScriptsBeforeGuestStandby),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sata_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._sataControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            scsi_controller_scan_count: {
                value: cdktf.numberToHclTerraform(this._scsiControllerScanCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            storage_policy_id: {
                value: cdktf.stringToHclTerraform(this._storagePolicyId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            swap_placement_policy: {
                value: cdktf.stringToHclTerraform(this._swapPlacementPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sync_time_with_host: {
                value: cdktf.booleanToHclTerraform(this._syncTimeWithHost),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sync_time_with_host_periodically: {
                value: cdktf.booleanToHclTerraform(this._syncTimeWithHostPeriodically),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tools_upgrade_policy: {
                value: cdktf.stringToHclTerraform(this._toolsUpgradePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            uuid: {
                value: cdktf.stringToHclTerraform(this._uuid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            vbs_enabled: {
                value: cdktf.booleanToHclTerraform(this._vbsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vvtd_enabled: {
                value: cdktf.booleanToHclTerraform(this._vvtdEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vapp: {
                value: dataVsphereVirtualMachineVappToHclTerraform(this._vapp.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "DataVsphereVirtualMachineVappList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DataVsphereVirtualMachine = DataVsphereVirtualMachine;
_f = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachine[_f] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachine", version: "9.4.0" };
// =================
// STATIC PROPERTIES
// =================
DataVsphereVirtualMachine.tfResourceType = "vsphere_virtual_machine";
//# sourceMappingURL=data:application/json;base64,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