"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatastoreCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/datastore_cluster vsphere_datastore_cluster}
*/
class DatastoreCluster extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DatastoreCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatastoreCluster to import
    * @param importFromId The id of the existing DatastoreCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/datastore_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatastoreCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_datastore_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/datastore_cluster vsphere_datastore_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastoreClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_datastore_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.10.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._folder = config.folder;
        this._id = config.id;
        this._name = config.name;
        this._sdrsAdvancedOptions = config.sdrsAdvancedOptions;
        this._sdrsAutomationLevel = config.sdrsAutomationLevel;
        this._sdrsDefaultIntraVmAffinity = config.sdrsDefaultIntraVmAffinity;
        this._sdrsEnabled = config.sdrsEnabled;
        this._sdrsFreeSpaceThreshold = config.sdrsFreeSpaceThreshold;
        this._sdrsFreeSpaceThresholdMode = config.sdrsFreeSpaceThresholdMode;
        this._sdrsFreeSpaceUtilizationDifference = config.sdrsFreeSpaceUtilizationDifference;
        this._sdrsIoBalanceAutomationLevel = config.sdrsIoBalanceAutomationLevel;
        this._sdrsIoLatencyThreshold = config.sdrsIoLatencyThreshold;
        this._sdrsIoLoadBalanceEnabled = config.sdrsIoLoadBalanceEnabled;
        this._sdrsIoLoadImbalanceThreshold = config.sdrsIoLoadImbalanceThreshold;
        this._sdrsIoReservableIopsThreshold = config.sdrsIoReservableIopsThreshold;
        this._sdrsIoReservablePercentThreshold = config.sdrsIoReservablePercentThreshold;
        this._sdrsIoReservableThresholdMode = config.sdrsIoReservableThresholdMode;
        this._sdrsLoadBalanceInterval = config.sdrsLoadBalanceInterval;
        this._sdrsPolicyEnforcementAutomationLevel = config.sdrsPolicyEnforcementAutomationLevel;
        this._sdrsRuleEnforcementAutomationLevel = config.sdrsRuleEnforcementAutomationLevel;
        this._sdrsSpaceBalanceAutomationLevel = config.sdrsSpaceBalanceAutomationLevel;
        this._sdrsSpaceUtilizationThreshold = config.sdrsSpaceUtilizationThreshold;
        this._sdrsVmEvacuationAutomationLevel = config.sdrsVmEvacuationAutomationLevel;
        this._tags = config.tags;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get sdrsAdvancedOptions() {
        return this.getStringMapAttribute('sdrs_advanced_options');
    }
    set sdrsAdvancedOptions(value) {
        this._sdrsAdvancedOptions = value;
    }
    resetSdrsAdvancedOptions() {
        this._sdrsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsAdvancedOptionsInput() {
        return this._sdrsAdvancedOptions;
    }
    get sdrsAutomationLevel() {
        return this.getStringAttribute('sdrs_automation_level');
    }
    set sdrsAutomationLevel(value) {
        this._sdrsAutomationLevel = value;
    }
    resetSdrsAutomationLevel() {
        this._sdrsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsAutomationLevelInput() {
        return this._sdrsAutomationLevel;
    }
    get sdrsDefaultIntraVmAffinity() {
        return this.getBooleanAttribute('sdrs_default_intra_vm_affinity');
    }
    set sdrsDefaultIntraVmAffinity(value) {
        this._sdrsDefaultIntraVmAffinity = value;
    }
    resetSdrsDefaultIntraVmAffinity() {
        this._sdrsDefaultIntraVmAffinity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsDefaultIntraVmAffinityInput() {
        return this._sdrsDefaultIntraVmAffinity;
    }
    get sdrsEnabled() {
        return this.getBooleanAttribute('sdrs_enabled');
    }
    set sdrsEnabled(value) {
        this._sdrsEnabled = value;
    }
    resetSdrsEnabled() {
        this._sdrsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsEnabledInput() {
        return this._sdrsEnabled;
    }
    get sdrsFreeSpaceThreshold() {
        return this.getNumberAttribute('sdrs_free_space_threshold');
    }
    set sdrsFreeSpaceThreshold(value) {
        this._sdrsFreeSpaceThreshold = value;
    }
    resetSdrsFreeSpaceThreshold() {
        this._sdrsFreeSpaceThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceThresholdInput() {
        return this._sdrsFreeSpaceThreshold;
    }
    get sdrsFreeSpaceThresholdMode() {
        return this.getStringAttribute('sdrs_free_space_threshold_mode');
    }
    set sdrsFreeSpaceThresholdMode(value) {
        this._sdrsFreeSpaceThresholdMode = value;
    }
    resetSdrsFreeSpaceThresholdMode() {
        this._sdrsFreeSpaceThresholdMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceThresholdModeInput() {
        return this._sdrsFreeSpaceThresholdMode;
    }
    get sdrsFreeSpaceUtilizationDifference() {
        return this.getNumberAttribute('sdrs_free_space_utilization_difference');
    }
    set sdrsFreeSpaceUtilizationDifference(value) {
        this._sdrsFreeSpaceUtilizationDifference = value;
    }
    resetSdrsFreeSpaceUtilizationDifference() {
        this._sdrsFreeSpaceUtilizationDifference = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceUtilizationDifferenceInput() {
        return this._sdrsFreeSpaceUtilizationDifference;
    }
    get sdrsIoBalanceAutomationLevel() {
        return this.getStringAttribute('sdrs_io_balance_automation_level');
    }
    set sdrsIoBalanceAutomationLevel(value) {
        this._sdrsIoBalanceAutomationLevel = value;
    }
    resetSdrsIoBalanceAutomationLevel() {
        this._sdrsIoBalanceAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoBalanceAutomationLevelInput() {
        return this._sdrsIoBalanceAutomationLevel;
    }
    get sdrsIoLatencyThreshold() {
        return this.getNumberAttribute('sdrs_io_latency_threshold');
    }
    set sdrsIoLatencyThreshold(value) {
        this._sdrsIoLatencyThreshold = value;
    }
    resetSdrsIoLatencyThreshold() {
        this._sdrsIoLatencyThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLatencyThresholdInput() {
        return this._sdrsIoLatencyThreshold;
    }
    get sdrsIoLoadBalanceEnabled() {
        return this.getBooleanAttribute('sdrs_io_load_balance_enabled');
    }
    set sdrsIoLoadBalanceEnabled(value) {
        this._sdrsIoLoadBalanceEnabled = value;
    }
    resetSdrsIoLoadBalanceEnabled() {
        this._sdrsIoLoadBalanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLoadBalanceEnabledInput() {
        return this._sdrsIoLoadBalanceEnabled;
    }
    get sdrsIoLoadImbalanceThreshold() {
        return this.getNumberAttribute('sdrs_io_load_imbalance_threshold');
    }
    set sdrsIoLoadImbalanceThreshold(value) {
        this._sdrsIoLoadImbalanceThreshold = value;
    }
    resetSdrsIoLoadImbalanceThreshold() {
        this._sdrsIoLoadImbalanceThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLoadImbalanceThresholdInput() {
        return this._sdrsIoLoadImbalanceThreshold;
    }
    get sdrsIoReservableIopsThreshold() {
        return this.getNumberAttribute('sdrs_io_reservable_iops_threshold');
    }
    set sdrsIoReservableIopsThreshold(value) {
        this._sdrsIoReservableIopsThreshold = value;
    }
    resetSdrsIoReservableIopsThreshold() {
        this._sdrsIoReservableIopsThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservableIopsThresholdInput() {
        return this._sdrsIoReservableIopsThreshold;
    }
    get sdrsIoReservablePercentThreshold() {
        return this.getNumberAttribute('sdrs_io_reservable_percent_threshold');
    }
    set sdrsIoReservablePercentThreshold(value) {
        this._sdrsIoReservablePercentThreshold = value;
    }
    resetSdrsIoReservablePercentThreshold() {
        this._sdrsIoReservablePercentThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservablePercentThresholdInput() {
        return this._sdrsIoReservablePercentThreshold;
    }
    get sdrsIoReservableThresholdMode() {
        return this.getStringAttribute('sdrs_io_reservable_threshold_mode');
    }
    set sdrsIoReservableThresholdMode(value) {
        this._sdrsIoReservableThresholdMode = value;
    }
    resetSdrsIoReservableThresholdMode() {
        this._sdrsIoReservableThresholdMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservableThresholdModeInput() {
        return this._sdrsIoReservableThresholdMode;
    }
    get sdrsLoadBalanceInterval() {
        return this.getNumberAttribute('sdrs_load_balance_interval');
    }
    set sdrsLoadBalanceInterval(value) {
        this._sdrsLoadBalanceInterval = value;
    }
    resetSdrsLoadBalanceInterval() {
        this._sdrsLoadBalanceInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsLoadBalanceIntervalInput() {
        return this._sdrsLoadBalanceInterval;
    }
    get sdrsPolicyEnforcementAutomationLevel() {
        return this.getStringAttribute('sdrs_policy_enforcement_automation_level');
    }
    set sdrsPolicyEnforcementAutomationLevel(value) {
        this._sdrsPolicyEnforcementAutomationLevel = value;
    }
    resetSdrsPolicyEnforcementAutomationLevel() {
        this._sdrsPolicyEnforcementAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsPolicyEnforcementAutomationLevelInput() {
        return this._sdrsPolicyEnforcementAutomationLevel;
    }
    get sdrsRuleEnforcementAutomationLevel() {
        return this.getStringAttribute('sdrs_rule_enforcement_automation_level');
    }
    set sdrsRuleEnforcementAutomationLevel(value) {
        this._sdrsRuleEnforcementAutomationLevel = value;
    }
    resetSdrsRuleEnforcementAutomationLevel() {
        this._sdrsRuleEnforcementAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsRuleEnforcementAutomationLevelInput() {
        return this._sdrsRuleEnforcementAutomationLevel;
    }
    get sdrsSpaceBalanceAutomationLevel() {
        return this.getStringAttribute('sdrs_space_balance_automation_level');
    }
    set sdrsSpaceBalanceAutomationLevel(value) {
        this._sdrsSpaceBalanceAutomationLevel = value;
    }
    resetSdrsSpaceBalanceAutomationLevel() {
        this._sdrsSpaceBalanceAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsSpaceBalanceAutomationLevelInput() {
        return this._sdrsSpaceBalanceAutomationLevel;
    }
    get sdrsSpaceUtilizationThreshold() {
        return this.getNumberAttribute('sdrs_space_utilization_threshold');
    }
    set sdrsSpaceUtilizationThreshold(value) {
        this._sdrsSpaceUtilizationThreshold = value;
    }
    resetSdrsSpaceUtilizationThreshold() {
        this._sdrsSpaceUtilizationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsSpaceUtilizationThresholdInput() {
        return this._sdrsSpaceUtilizationThreshold;
    }
    get sdrsVmEvacuationAutomationLevel() {
        return this.getStringAttribute('sdrs_vm_evacuation_automation_level');
    }
    set sdrsVmEvacuationAutomationLevel(value) {
        this._sdrsVmEvacuationAutomationLevel = value;
    }
    resetSdrsVmEvacuationAutomationLevel() {
        this._sdrsVmEvacuationAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsVmEvacuationAutomationLevelInput() {
        return this._sdrsVmEvacuationAutomationLevel;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            folder: cdktf.stringToTerraform(this._folder),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            sdrs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._sdrsAdvancedOptions),
            sdrs_automation_level: cdktf.stringToTerraform(this._sdrsAutomationLevel),
            sdrs_default_intra_vm_affinity: cdktf.booleanToTerraform(this._sdrsDefaultIntraVmAffinity),
            sdrs_enabled: cdktf.booleanToTerraform(this._sdrsEnabled),
            sdrs_free_space_threshold: cdktf.numberToTerraform(this._sdrsFreeSpaceThreshold),
            sdrs_free_space_threshold_mode: cdktf.stringToTerraform(this._sdrsFreeSpaceThresholdMode),
            sdrs_free_space_utilization_difference: cdktf.numberToTerraform(this._sdrsFreeSpaceUtilizationDifference),
            sdrs_io_balance_automation_level: cdktf.stringToTerraform(this._sdrsIoBalanceAutomationLevel),
            sdrs_io_latency_threshold: cdktf.numberToTerraform(this._sdrsIoLatencyThreshold),
            sdrs_io_load_balance_enabled: cdktf.booleanToTerraform(this._sdrsIoLoadBalanceEnabled),
            sdrs_io_load_imbalance_threshold: cdktf.numberToTerraform(this._sdrsIoLoadImbalanceThreshold),
            sdrs_io_reservable_iops_threshold: cdktf.numberToTerraform(this._sdrsIoReservableIopsThreshold),
            sdrs_io_reservable_percent_threshold: cdktf.numberToTerraform(this._sdrsIoReservablePercentThreshold),
            sdrs_io_reservable_threshold_mode: cdktf.stringToTerraform(this._sdrsIoReservableThresholdMode),
            sdrs_load_balance_interval: cdktf.numberToTerraform(this._sdrsLoadBalanceInterval),
            sdrs_policy_enforcement_automation_level: cdktf.stringToTerraform(this._sdrsPolicyEnforcementAutomationLevel),
            sdrs_rule_enforcement_automation_level: cdktf.stringToTerraform(this._sdrsRuleEnforcementAutomationLevel),
            sdrs_space_balance_automation_level: cdktf.stringToTerraform(this._sdrsSpaceBalanceAutomationLevel),
            sdrs_space_utilization_threshold: cdktf.numberToTerraform(this._sdrsSpaceUtilizationThreshold),
            sdrs_vm_evacuation_automation_level: cdktf.stringToTerraform(this._sdrsVmEvacuationAutomationLevel),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._sdrsAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            sdrs_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_default_intra_vm_affinity: {
                value: cdktf.booleanToHclTerraform(this._sdrsDefaultIntraVmAffinity),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sdrs_enabled: {
                value: cdktf.booleanToHclTerraform(this._sdrsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sdrs_free_space_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsFreeSpaceThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_free_space_threshold_mode: {
                value: cdktf.stringToHclTerraform(this._sdrsFreeSpaceThresholdMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_free_space_utilization_difference: {
                value: cdktf.numberToHclTerraform(this._sdrsFreeSpaceUtilizationDifference),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_io_balance_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsIoBalanceAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_io_latency_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsIoLatencyThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_io_load_balance_enabled: {
                value: cdktf.booleanToHclTerraform(this._sdrsIoLoadBalanceEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            sdrs_io_load_imbalance_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsIoLoadImbalanceThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_io_reservable_iops_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsIoReservableIopsThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_io_reservable_percent_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsIoReservablePercentThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_io_reservable_threshold_mode: {
                value: cdktf.stringToHclTerraform(this._sdrsIoReservableThresholdMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_load_balance_interval: {
                value: cdktf.numberToHclTerraform(this._sdrsLoadBalanceInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_policy_enforcement_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsPolicyEnforcementAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_rule_enforcement_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsRuleEnforcementAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_space_balance_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsSpaceBalanceAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            sdrs_space_utilization_threshold: {
                value: cdktf.numberToHclTerraform(this._sdrsSpaceUtilizationThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            sdrs_vm_evacuation_automation_level: {
                value: cdktf.stringToHclTerraform(this._sdrsVmEvacuationAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DatastoreCluster = DatastoreCluster;
_a = JSII_RTTI_SYMBOL_1;
DatastoreCluster[_a] = { fqn: "@cdktf/provider-vsphere.datastoreCluster.DatastoreCluster", version: "9.4.0" };
// =================
// STATIC PROPERTIES
// =================
DatastoreCluster.tfResourceType = "vsphere_datastore_cluster";
//# sourceMappingURL=data:application/json;base64,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