/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DrsVmOverrideConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#compute_cluster_id DrsVmOverride#compute_cluster_id}
    */
    readonly computeClusterId: string;
    /**
    * The automation level for this virtual machine in the cluster. Can be one of manual, partiallyAutomated, or fullyAutomated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#drs_automation_level DrsVmOverride#drs_automation_level}
    */
    readonly drsAutomationLevel?: string;
    /**
    * Enable DRS for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#drs_enabled DrsVmOverride#drs_enabled}
    */
    readonly drsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#id DrsVmOverride#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The managed object ID of the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#virtual_machine_id DrsVmOverride#virtual_machine_id}
    */
    readonly virtualMachineId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override vsphere_drs_vm_override}
*/
export declare class DrsVmOverride extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_drs_vm_override";
    /**
    * Generates CDKTF code for importing a DrsVmOverride resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DrsVmOverride to import
    * @param importFromId The id of the existing DrsVmOverride that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DrsVmOverride to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/drs_vm_override vsphere_drs_vm_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DrsVmOverrideConfig
    */
    constructor(scope: Construct, id: string, config: DrsVmOverrideConfig);
    private _computeClusterId?;
    get computeClusterId(): string;
    set computeClusterId(value: string);
    get computeClusterIdInput(): string | undefined;
    private _drsAutomationLevel?;
    get drsAutomationLevel(): string;
    set drsAutomationLevel(value: string);
    resetDrsAutomationLevel(): void;
    get drsAutomationLevelInput(): string | undefined;
    private _drsEnabled?;
    get drsEnabled(): boolean | cdktf.IResolvable;
    set drsEnabled(value: boolean | cdktf.IResolvable);
    resetDrsEnabled(): void;
    get drsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
