/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the vSphere cluster the host will belong to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#cluster Host#cluster}
    */
    readonly cluster?: string;
    /**
    * Must be set if host is a member of a managed compute_cluster resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#cluster_managed Host#cluster_managed}
    */
    readonly clusterManaged?: boolean | cdktf.IResolvable;
    /**
    * Set the state of the host. If set to false then the host will be asked to disconnect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#connected Host#connected}
    */
    readonly connected?: boolean | cdktf.IResolvable;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#custom_attributes Host#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * ID of the vSphere datacenter the host will belong to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#datacenter Host#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Force add the host to the vSphere inventory even if it's already managed by a different vCenter Server instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#force Host#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * FQDN or IP address of the host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#hostname Host#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#id Host#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * License key that will be applied to this host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#license Host#license}
    */
    readonly license?: string;
    /**
    * Set the host's lockdown status. Default is disabled. Valid options are 'disabled', 'normal', 'strict'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#lockdown Host#lockdown}
    */
    readonly lockdown?: string;
    /**
    * Set the host's maintenance mode. Default is false
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#maintenance Host#maintenance}
    */
    readonly maintenance?: boolean | cdktf.IResolvable;
    /**
    * Password of the administration account of the host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#password Host#password}
    */
    readonly password: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#tags Host#tags}
    */
    readonly tags?: string[];
    /**
    * Host's certificate SHA-1 thumbprint. If not set then the CA that signed the host's certificate must be trusted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#thumbprint Host#thumbprint}
    */
    readonly thumbprint?: string;
    /**
    * Username of the administration account of the host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#username Host#username}
    */
    readonly username: string;
    /**
    * services block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#services Host#services}
    */
    readonly services?: HostServices[] | cdktf.IResolvable;
}
export interface HostServicesNtpd {
    /**
    * Whether the NTP service is enabled. Default is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#enabled Host#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#ntp_servers Host#ntp_servers}
    */
    readonly ntpServers?: string[];
    /**
    * The policy for the NTP service. Valid values are 'Start and stop with host', 'Start and stop manually', 'Start and stop with port usage'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#policy Host#policy}
    */
    readonly policy?: string;
}
export declare function hostServicesNtpdToTerraform(struct?: HostServicesNtpdOutputReference | HostServicesNtpd): any;
export declare function hostServicesNtpdToHclTerraform(struct?: HostServicesNtpdOutputReference | HostServicesNtpd): any;
export declare class HostServicesNtpdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HostServicesNtpd | undefined;
    set internalValue(value: HostServicesNtpd | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ntpServers?;
    get ntpServers(): string[];
    set ntpServers(value: string[]);
    resetNtpServers(): void;
    get ntpServersInput(): string[] | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
export interface HostServices {
    /**
    * ntpd block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#ntpd Host#ntpd}
    */
    readonly ntpd?: HostServicesNtpd;
}
export declare function hostServicesToTerraform(struct?: HostServices | cdktf.IResolvable): any;
export declare function hostServicesToHclTerraform(struct?: HostServices | cdktf.IResolvable): any;
export declare class HostServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HostServices | cdktf.IResolvable | undefined;
    set internalValue(value: HostServices | cdktf.IResolvable | undefined);
    private _ntpd;
    get ntpd(): HostServicesNtpdOutputReference;
    putNtpd(value: HostServicesNtpd): void;
    resetNtpd(): void;
    get ntpdInput(): HostServicesNtpd | undefined;
}
export declare class HostServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HostServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HostServicesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host vsphere_host}
*/
export declare class Host extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_host";
    /**
    * Generates CDKTF code for importing a Host resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Host to import
    * @param importFromId The id of the existing Host that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Host to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/host vsphere_host} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostConfig
    */
    constructor(scope: Construct, id: string, config: HostConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    resetCluster(): void;
    get clusterInput(): string | undefined;
    private _clusterManaged?;
    get clusterManaged(): boolean | cdktf.IResolvable;
    set clusterManaged(value: boolean | cdktf.IResolvable);
    resetClusterManaged(): void;
    get clusterManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _connected?;
    get connected(): boolean | cdktf.IResolvable;
    set connected(value: boolean | cdktf.IResolvable);
    resetConnected(): void;
    get connectedInput(): boolean | cdktf.IResolvable | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _license?;
    get license(): string;
    set license(value: string);
    resetLicense(): void;
    get licenseInput(): string | undefined;
    private _lockdown?;
    get lockdown(): string;
    set lockdown(value: string);
    resetLockdown(): void;
    get lockdownInput(): string | undefined;
    private _maintenance?;
    get maintenance(): boolean | cdktf.IResolvable;
    set maintenance(value: boolean | cdktf.IResolvable);
    resetMaintenance(): void;
    get maintenanceInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    resetThumbprint(): void;
    get thumbprintInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _services;
    get services(): HostServicesList;
    putServices(value: HostServices[] | cdktf.IResolvable): void;
    resetServices(): void;
    get servicesInput(): cdktf.IResolvable | HostServices[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
