/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OfflineSoftwareDepotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/offline_software_depot#id OfflineSoftwareDepot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The remote location where the contents for this depot are served.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/offline_software_depot#location OfflineSoftwareDepot#location}
    */
    readonly location: string;
}
export interface OfflineSoftwareDepotComponent {
}
export declare function offlineSoftwareDepotComponentToTerraform(struct?: OfflineSoftwareDepotComponent): any;
export declare function offlineSoftwareDepotComponentToHclTerraform(struct?: OfflineSoftwareDepotComponent): any;
export declare class OfflineSoftwareDepotComponentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OfflineSoftwareDepotComponent | undefined;
    set internalValue(value: OfflineSoftwareDepotComponent | undefined);
    get displayName(): string;
    get key(): string;
    get version(): string[];
}
export declare class OfflineSoftwareDepotComponentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OfflineSoftwareDepotComponentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/offline_software_depot vsphere_offline_software_depot}
*/
export declare class OfflineSoftwareDepot extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_offline_software_depot";
    /**
    * Generates CDKTF code for importing a OfflineSoftwareDepot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OfflineSoftwareDepot to import
    * @param importFromId The id of the existing OfflineSoftwareDepot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/offline_software_depot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OfflineSoftwareDepot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/offline_software_depot vsphere_offline_software_depot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OfflineSoftwareDepotConfig
    */
    constructor(scope: Construct, id: string, config: OfflineSoftwareDepotConfig);
    private _component;
    get component(): OfflineSoftwareDepotComponentList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
