/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VsphereProviderConfig {
    /**
    * If set, VMware vSphere client will permit unverifiable SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#allow_unverified_ssl VsphereProvider#allow_unverified_ssl}
    */
    readonly allowUnverifiedSsl?: boolean | cdktf.IResolvable;
    /**
    * API timeout in minutes (Default: 5)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#api_timeout VsphereProvider#api_timeout}
    */
    readonly apiTimeout?: number;
    /**
    * govmomi debug
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#client_debug VsphereProvider#client_debug}
    */
    readonly clientDebug?: boolean | cdktf.IResolvable;
    /**
    * govmomi debug path for debug
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#client_debug_path VsphereProvider#client_debug_path}
    */
    readonly clientDebugPath?: string;
    /**
    * govmomi debug path for a single run
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#client_debug_path_run VsphereProvider#client_debug_path_run}
    */
    readonly clientDebugPathRun?: string;
    /**
    * The user password for vSphere API operations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#password VsphereProvider#password}
    */
    readonly password: string;
    /**
    * Persist vSphere client sessions to disk
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#persist_session VsphereProvider#persist_session}
    */
    readonly persistSession?: boolean | cdktf.IResolvable;
    /**
    * The directory to save vSphere REST API sessions to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#rest_session_path VsphereProvider#rest_session_path}
    */
    readonly restSessionPath?: string;
    /**
    * The user name for vSphere API operations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#user VsphereProvider#user}
    */
    readonly user: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#vcenter_server VsphereProvider#vcenter_server}
    */
    readonly vcenterServer?: string;
    /**
    * Keep alive interval for the VIM session in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#vim_keep_alive VsphereProvider#vim_keep_alive}
    */
    readonly vimKeepAlive?: number;
    /**
    * The directory to save vSphere SOAP API sessions to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#vim_session_path VsphereProvider#vim_session_path}
    */
    readonly vimSessionPath?: string;
    /**
    * The vSphere Server name for vSphere API operations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#vsphere_server VsphereProvider#vsphere_server}
    */
    readonly vsphereServer?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#alias VsphereProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs vsphere}
*/
export declare class VsphereProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "vsphere";
    /**
    * Generates CDKTF code for importing a VsphereProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VsphereProvider to import
    * @param importFromId The id of the existing VsphereProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VsphereProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs vsphere} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VsphereProviderConfig
    */
    constructor(scope: Construct, id: string, config: VsphereProviderConfig);
    private _allowUnverifiedSsl?;
    get allowUnverifiedSsl(): boolean | cdktf.IResolvable | undefined;
    set allowUnverifiedSsl(value: boolean | cdktf.IResolvable | undefined);
    resetAllowUnverifiedSsl(): void;
    get allowUnverifiedSslInput(): boolean | cdktf.IResolvable | undefined;
    private _apiTimeout?;
    get apiTimeout(): number | undefined;
    set apiTimeout(value: number | undefined);
    resetApiTimeout(): void;
    get apiTimeoutInput(): number | undefined;
    private _clientDebug?;
    get clientDebug(): boolean | cdktf.IResolvable | undefined;
    set clientDebug(value: boolean | cdktf.IResolvable | undefined);
    resetClientDebug(): void;
    get clientDebugInput(): boolean | cdktf.IResolvable | undefined;
    private _clientDebugPath?;
    get clientDebugPath(): string | undefined;
    set clientDebugPath(value: string | undefined);
    resetClientDebugPath(): void;
    get clientDebugPathInput(): string | undefined;
    private _clientDebugPathRun?;
    get clientDebugPathRun(): string | undefined;
    set clientDebugPathRun(value: string | undefined);
    resetClientDebugPathRun(): void;
    get clientDebugPathRunInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    get passwordInput(): string | undefined;
    private _persistSession?;
    get persistSession(): boolean | cdktf.IResolvable | undefined;
    set persistSession(value: boolean | cdktf.IResolvable | undefined);
    resetPersistSession(): void;
    get persistSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _restSessionPath?;
    get restSessionPath(): string | undefined;
    set restSessionPath(value: string | undefined);
    resetRestSessionPath(): void;
    get restSessionPathInput(): string | undefined;
    private _user?;
    get user(): string | undefined;
    set user(value: string | undefined);
    get userInput(): string | undefined;
    private _vcenterServer?;
    get vcenterServer(): string | undefined;
    set vcenterServer(value: string | undefined);
    resetVcenterServer(): void;
    get vcenterServerInput(): string | undefined;
    private _vimKeepAlive?;
    get vimKeepAlive(): number | undefined;
    set vimKeepAlive(value: number | undefined);
    resetVimKeepAlive(): void;
    get vimKeepAliveInput(): number | undefined;
    private _vimSessionPath?;
    get vimSessionPath(): string | undefined;
    set vimSessionPath(value: string | undefined);
    resetVimSessionPath(): void;
    get vimSessionPathInput(): string | undefined;
    private _vsphereServer?;
    get vsphereServer(): string | undefined;
    set vsphereServer(value: string | undefined);
    resetVsphereServer(): void;
    get vsphereServerInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
