/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDrsVmOverrideConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the datastore cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#datastore_cluster_id StorageDrsVmOverride#datastore_cluster_id}
    */
    readonly datastoreClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#id StorageDrsVmOverride#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Overrides any Storage DRS automation levels for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#sdrs_automation_level StorageDrsVmOverride#sdrs_automation_level}
    */
    readonly sdrsAutomationLevel?: string;
    /**
    * Overrides the default Storage DRS setting for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#sdrs_enabled StorageDrsVmOverride#sdrs_enabled}
    */
    readonly sdrsEnabled?: string;
    /**
    * Overrides the intra-VM affinity setting for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#sdrs_intra_vm_affinity StorageDrsVmOverride#sdrs_intra_vm_affinity}
    */
    readonly sdrsIntraVmAffinity?: string;
    /**
    * The managed object ID of the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#virtual_machine_id StorageDrsVmOverride#virtual_machine_id}
    */
    readonly virtualMachineId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override vsphere_storage_drs_vm_override}
*/
export declare class StorageDrsVmOverride extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_storage_drs_vm_override";
    /**
    * Generates CDKTF code for importing a StorageDrsVmOverride resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageDrsVmOverride to import
    * @param importFromId The id of the existing StorageDrsVmOverride that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageDrsVmOverride to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/storage_drs_vm_override vsphere_storage_drs_vm_override} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDrsVmOverrideConfig
    */
    constructor(scope: Construct, id: string, config: StorageDrsVmOverrideConfig);
    private _datastoreClusterId?;
    get datastoreClusterId(): string;
    set datastoreClusterId(value: string);
    get datastoreClusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sdrsAutomationLevel?;
    get sdrsAutomationLevel(): string;
    set sdrsAutomationLevel(value: string);
    resetSdrsAutomationLevel(): void;
    get sdrsAutomationLevelInput(): string | undefined;
    private _sdrsEnabled?;
    get sdrsEnabled(): string;
    set sdrsEnabled(value: string);
    resetSdrsEnabled(): void;
    get sdrsEnabledInput(): string | undefined;
    private _sdrsIntraVmAffinity?;
    get sdrsIntraVmAffinity(): string;
    set sdrsIntraVmAffinity(value: string);
    resetSdrsIntraVmAffinity(): void;
    get sdrsIntraVmAffinityInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
