/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VappEntityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Managed object ID of the vApp container the entity is a member of.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#container_id VappEntity#container_id}
    */
    readonly containerId: string;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#custom_attributes VappEntity#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#id VappEntity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * How to start the entity. Valid settings are none or powerOn. If set to none, then the entity does not participate in auto-start.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#start_action VappEntity#start_action}
    */
    readonly startAction?: string;
    /**
    * Delay in seconds before continuing with the next entity in the order of entities to be started.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#start_delay VappEntity#start_delay}
    */
    readonly startDelay?: number;
    /**
    * Order to start and stop target in vApp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#start_order VappEntity#start_order}
    */
    readonly startOrder?: number;
    /**
    * Defines the stop action for the entity. Can be set to none, powerOff, guestShutdown, or suspend. If set to none, then the entity does not participate in auto-stop.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#stop_action VappEntity#stop_action}
    */
    readonly stopAction?: string;
    /**
    * Delay in seconds before continuing with the next entity in the order of entities to be stopped.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#stop_delay VappEntity#stop_delay}
    */
    readonly stopDelay?: number;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#tags VappEntity#tags}
    */
    readonly tags?: string[];
    /**
    * Managed object ID of the entity to power on or power off. This can be a virtual machine or a vApp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#target_id VappEntity#target_id}
    */
    readonly targetId: string;
    /**
    * Determines if the VM should be marked as being started when VMware Tools are ready instead of waiting for start_delay. This property has no effect for vApps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#wait_for_guest VappEntity#wait_for_guest}
    */
    readonly waitForGuest?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity vsphere_vapp_entity}
*/
export declare class VappEntity extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_vapp_entity";
    /**
    * Generates CDKTF code for importing a VappEntity resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VappEntity to import
    * @param importFromId The id of the existing VappEntity that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VappEntity to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vapp_entity vsphere_vapp_entity} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VappEntityConfig
    */
    constructor(scope: Construct, id: string, config: VappEntityConfig);
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _startAction?;
    get startAction(): string;
    set startAction(value: string);
    resetStartAction(): void;
    get startActionInput(): string | undefined;
    private _startDelay?;
    get startDelay(): number;
    set startDelay(value: number);
    resetStartDelay(): void;
    get startDelayInput(): number | undefined;
    private _startOrder?;
    get startOrder(): number;
    set startOrder(value: number);
    resetStartOrder(): void;
    get startOrderInput(): number | undefined;
    private _stopAction?;
    get stopAction(): string;
    set stopAction(value: string);
    resetStopAction(): void;
    get stopActionInput(): string | undefined;
    private _stopDelay?;
    get stopDelay(): number;
    set stopDelay(value: number);
    resetStopDelay(): void;
    get stopDelayInput(): number | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetId?;
    get targetId(): string;
    set targetId(value: string);
    get targetIdInput(): string | undefined;
    private _waitForGuest?;
    get waitForGuest(): boolean | cdktf.IResolvable;
    set waitForGuest(value: boolean | cdktf.IResolvable);
    resetWaitForGuest(): void;
    get waitForGuestInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
