/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineClassConfig extends cdktf.TerraformMetaArguments {
    /**
    * The percentage of the available CPU capacity which will be reserved.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#cpu_reservation VirtualMachineClass#cpu_reservation}
    */
    readonly cpuReservation?: number;
    /**
    * The number of CPUs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#cpus VirtualMachineClass#cpus}
    */
    readonly cpus: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#id VirtualMachineClass#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The amount of memory (in MB).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#memory VirtualMachineClass#memory}
    */
    readonly memory: number;
    /**
    * The percentage of the available memory capacity which will be reserved.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#memory_reservation VirtualMachineClass#memory_reservation}
    */
    readonly memoryReservation?: number;
    /**
    * The name of the virtual machine class.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#name VirtualMachineClass#name}
    */
    readonly name: string;
    /**
    * A comma-separated list of GPU devices.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#vgpu_devices VirtualMachineClass#vgpu_devices}
    */
    readonly vgpuDevices?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class vsphere_virtual_machine_class}
*/
export declare class VirtualMachineClass extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_virtual_machine_class";
    /**
    * Generates CDKTF code for importing a VirtualMachineClass resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineClass to import
    * @param importFromId The id of the existing VirtualMachineClass that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineClass to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/virtual_machine_class vsphere_virtual_machine_class} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineClassConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineClassConfig);
    private _cpuReservation?;
    get cpuReservation(): number;
    set cpuReservation(value: number);
    resetCpuReservation(): void;
    get cpuReservationInput(): number | undefined;
    private _cpus?;
    get cpus(): number;
    set cpus(value: number);
    get cpusInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    get memoryInput(): number | undefined;
    private _memoryReservation?;
    get memoryReservation(): number;
    set memoryReservation(value: number);
    resetMemoryReservation(): void;
    get memoryReservationInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vgpuDevices?;
    get vgpuDevices(): string[];
    set vgpuDevices(value: string[]);
    resetVgpuDevices(): void;
    get vgpuDevicesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
